/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions;

import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.BytesBody;
import org.jboss.soa.esb.notification.NotificationList;

/**
 * Contains utility methods for actions 
 * @author <a href="mailto:schifest@heuristica.com.ar">schifest@heuristica.com.ar</a>
 * @since Version 4.0
 */
public class ActionUtils 
{
    @Deprecated
    public static final String PRE_ACTION_DATA = "org.jboss.soa.esb.actions.pre";
    @Deprecated
	public static final String POST_ACTION_DATA = "org.jboss.soa.esb.actions.post";

    /**
     * Obtain the current object from standard spot within message 
     * @param message - from where to obtain the 'current object'
     * @return Object stored in Body with key ActionProcessor.POST_ACTION_DATA
     * @deprecated use get(POST_ACTION_DATA) on Body instead.
     */
	
    public static Object getTaskObject(Message message)
    {
    	Object payload = null ;
        if (message != null) {
            payload = message.getBody().get(POST_ACTION_DATA);
            
            if(payload == null) {
    		payload = (byte[]) message.getBody().get(BytesBody.BYTES_LOCATION);
            }
    	}
    	
    	return payload;
    }
    /**
     * Obtain previous 'current object' from standard spot within message 
     * @param message - from where to obtain the value
     * @return Object stored in Body with key ActionProcessor.BEFORE_ACTION
     * @deprecated use get(BEFORE_ACTION) on Body instead.
     */
    
    public static Object getTaskBeforeObject(Message message)
    {
    	return (null==message)? null : message.getBody().get(PRE_ACTION_DATA);
    }
    /**
     * Copy 'current object' to a temporary holder within message 
     * @param message 
     * @deprecated use BEFORE_ACTION and CURRENT_ACTION instead.
     */
    
    public static void copyCurrentToPrevious(Message message)
    {
    	Body body = message.getBody();
    	body.remove(PRE_ACTION_DATA);
    	Object obj = body.get(POST_ACTION_DATA);
    	if (null != obj)
    		body.add(PRE_ACTION_DATA,obj);
    }
    /**
     * Put current object in standard spot within message
     * <br/>NULL values are not stored 
     * @param message - to operate on
     * @param obj - Object to store - Won't be stored if &lt;null&gt;
     * @return Object previous 'current object'
     * @deprecated use set(POST_ACTION_DATA) instead.
     */
    
    public static Object setTaskObject(Message message, Object obj)
    {
        Object oRet = message.getBody().remove(POST_ACTION_DATA);
    	
    	if (null!=obj) {
    		message.getBody().add(POST_ACTION_DATA,obj);
    	}
    	if(obj instanceof byte[]) {
    		message.getBody().add(BytesBody.BYTES_LOCATION, (byte[])obj);
    	}
    	
    	return oRet;
    }	

    public static NotificationList getNotifyList(ConfigTree tree, String type)
    {
    	ConfigTree[] array = tree.getChildren(NotificationList.ELEMENT);
    	for (ConfigTree curr : array)
    	{
    		String sType = curr.getAttribute(NotificationList.TYPE);
    		if (null==sType)
    			continue;
    		if (type.toLowerCase().startsWith(sType.toLowerCase()))
    			return new NotificationList(curr);
    	}
    	return null;
    }
}
