/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.services.security;

import javax.security.auth.callback.CallbackHandler;

import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;

/**
 * EsbCallbackHandler extends CallbackHandler to proved access to 
 * an AuthenticationRequest instance, and SecurityConfig instance. 
 * <p/>
 * This can be used to access security information, like principals and credentials
 * needed by a callbacks.
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 * @since 4.4
 *
 */
public interface EsbCallbackHandler extends CallbackHandler
{
	void setAuthenticationRequest(final AuthenticationRequest authRequest);
	
	void setSecurityConfig(final SecurityConfig config);
}
