/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.internal.soa.esb.rosetta.pooling;

import javax.jms.Session;

import org.jboss.jms.client.JBossSession;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.SessionDelegate;


/**
 * Force executor initialisation for JBossSession.
 */
public class SessionExecutorInit
{
    /**
     * This method uses internal knowledge of the JBoss Messaging version
     * used within the project.  It initialises the thread used in the internal
     * QueuedExecutor so that it is created as a daemon thread instead of a normal
     * application thread.
     * 
     * JBESB-1873
     * 
     * @param session The created session to check.
     */
    public static void initExecutor(final Session session)
    {
        try
        {
            if (session instanceof JBossSession)
            {
                final JBossSession jbossSession = (JBossSession)session ;
                final SessionDelegate sessionDelegate = jbossSession.getDelegate() ;
                if (sessionDelegate instanceof ClientSessionDelegate)
                {
                    final ClientSessionDelegate clientSessionDelegate = (ClientSessionDelegate)sessionDelegate ;
                    final HierarchicalState state = clientSessionDelegate.getState() ;
                    if (state instanceof SessionState)
                    {
                        final SessionState sessionState = (SessionState)state ;
                        sessionState.getExecutor().restart() ;
                    }
                }
            }
        }
        catch (final Throwable th) {} // Hide all errors 
    }
}
