/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import javax.jms.JMSException;

/**
 * This exception is thrown from a JMS session/producer/consumer method when the
 * underlying exception appears to have been closed.  This will occur when the connection
 * has not been closed through the standard JMS exception listener route.
 * 
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class JmsConnectionFailureException extends JMSException
{
    /**
     * The serial version UID of this exception
     */
    private static final long serialVersionUID = 4352490530798177236L;

    /**
     * Construct an jms connection failure exception with the specified message.
     * @param message The exception message.
     */
    public JmsConnectionFailureException(final String message) 
    {
        super(message) ;
    }

    /**
     * Construct an jms connection failure exception with the specified message and associated cause.
     * @param message The exception message.
     * @param cause The associated cause.
     */
    public JmsConnectionFailureException(String message, Throwable cause)
    {
        this(message) ;
        initCause(cause) ;
   }
}
