package org.jboss.internal.soa.esb.message.format.serialized;

import java.net.URI;

import org.jboss.internal.soa.esb.message.format.serialized.body.content.BytesBodyImpl;
import org.jboss.internal.soa.esb.message.format.serialized.body.content.MapBodyImpl;
import org.jboss.internal.soa.esb.message.format.serialized.body.content.ObjectBodyImpl;
import org.jboss.internal.soa.esb.message.format.serialized.body.content.TextBodyImpl;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.body.content.Payload;
import org.jboss.soa.esb.message.format.MessagePlugin;
import org.jboss.soa.esb.message.format.MessageType;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * Used to plug in new message formats dynamically.
 *  
 * @author Mark Little
 *
 */

public class SerializedMessagePlugin implements MessagePlugin
{
	public Message getMessage ()
	{
		return new MessageImpl();
	}
	
	public URI getType ()
	{
		return MessageType.JAVA_SERIALIZED;
	}
	
	public Object createBodyType (Message msg, String type)
	{
		Object theBody = null;
		
		if (type.equals(Payload.BYTES_BODY))
		{
			try
			{
				theBody = new BytesBodyImpl((BodyImpl) msg.getBody());
			}
			catch (Exception ex)
			{
				return null;
			}
		}
		
		if (type.equals(Payload.TEXT_BODY))
			theBody = new TextBodyImpl((BodyImpl) msg.getBody());
		
		if (type.equals(Payload.OBJECT_BODY))
			theBody = new ObjectBodyImpl((BodyImpl) msg.getBody());
		
		if (type.equals(Payload.MAP_BODY))
			theBody = new MapBodyImpl((BodyImpl) msg.getBody());
		
		if (theBody != null)
		{
			((MessageImpl) msg).replaceBody((BodyImpl) theBody);
			
			return theBody;
		}
		else
			return msg.getBody();
	}
}
