/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.internal.soa.esb.message.format.serialized;

import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.ContextObjectInputStream;
import org.jboss.internal.soa.esb.message.format.MessageSerializer;

import java.io.*;

/**
 * Java Message serializer.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class JavaMessageSerializer extends MessageSerializer {


    public void serialize(Message message, OutputStream outStream) throws IOException {
        assertMessageInstanceOK(message);

        // Write the preamble....
        outStream.write(MessageSerializer.PREAMBLE_JAVA);

        // Write the message...
        ObjectOutputStream output = new ObjectOutputStream(outStream);
        try {
            output.writeObject(message);
        } finally {
            output.close();
        }
    }

    public Message deserialize(InputStream inStream) throws IOException {
        // Read and test the preamble...
        if(inStream.read() != MessageSerializer.PREAMBLE_JAVA) {
            throw new IOException("Cannot deserialize message.  Unrecognized message preamble.");
        }

        ObjectInputStream input = new ContextObjectInputStream(inStream);
        try {
            return (Message) input.readObject();
        } catch (ClassNotFoundException e) {
            throw (IOException) (new IOException("Unable to deserialize message instance.").initCause(e));
        } finally {
            input.close();
        }
    }

    public static boolean isJavaMessage(Message message) {
        return message instanceof MessageImpl;
    }

    private void assertMessageInstanceOK(Message message) throws IOException {
        if (!(isJavaMessage(message))) {
            throw new IOException("Invalid Message instance.  Expecting instance of '" + MessageImpl.class.getName() + "'.");
        }
    }
}