/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.listeners.war;

import org.jboss.internal.soa.esb.assertion.AssertArgument;

import java.util.Set;
import java.util.LinkedHashSet;

/**
 * Security Constraints.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class SecurityConstraints {

    private Servlet servlet;
    private Set<String> protectedMethods = new LinkedHashSet<String>() ;
    private Set<String> allowedRoles = new AllowedRoleSet<String>();
    private String transportGuarantee;

    public SecurityConstraints(Servlet servlet) {
        AssertArgument.isNotNull(servlet, "servlet");
        this.servlet = servlet;
        servlet.setSecurityConstraints(this);
    }

    public Set<String> getProtectedMethods() {
        return protectedMethods;
    }

    public Set<String> getAllowedRoles() {
        return allowedRoles;
    }

    public String getTransportGuarantee() {
        return transportGuarantee;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this.transportGuarantee = transportGuarantee;
    }

    private class AllowedRoleSet<T extends String> extends LinkedHashSet<String> {

        public boolean add(String role) {
            // Also add the role to the parent WebModel securityRoles, so the
            // <security-role> entries can be easily added to the web.xml...
            servlet.getWebModel().getSecurityRoles().add(role);
            return super.add(role);
        }
    }
}
