/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */

package org.jboss.internal.soa.esb.listeners.gateway.filefilter;

import java.io.File;
import java.io.FileFilter;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.util.Util;

/**
 * Simple file filter for local filesystem Will accept only files that end with
 * the String supplied at constructor time
 */

// normal file filter
public class FileEndsWith implements FileFilter
{   
    public FileEndsWith(String p_sEnd) throws ConfigurationException
    {
        m_sSuffix = p_sEnd;
        
        if (Util.isNullString(m_sSuffix))
            throw new ConfigurationException("Must specify file extension");
    }
    
    public boolean accept (File p_f)
    {
        return (p_f.isFile()) ? p_f.toString().endsWith(m_sSuffix) : false;
    }
    
    private String m_sSuffix;
}
