/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.internal.soa.esb.dependencies;

import java.util.Properties;

import org.jboss.system.ServiceMBean;

/**
 * Provide generic JCA inflow adapter functionality.
 *
 * Initialises a JCA inflow activation and adapts onto the required interface.
 *
 * @author <a href="kevin.conner@jboss.com">Kevin Conner</a>
 */
public interface JCAInflowAdapterMBean extends ServiceMBean
{
    /**
     * Set the messaging interface.
     * @param messagingInterface The name of the messaging interface.
     */
    public void setMessagingInterface(final String messagingInterface) ;
    
    /**
     * Get the messaging interface.
     * @return The name of the messaging interface or null if not set.
     */
    public String getMessagingInterface() ;
    
    /**
     * Set the type of the inflow bean.
     * @param beanType The type of the inflow bean.
     */
    public void setBeanType(final String beanType) ;
    
    /**
     * Get the type of the inflow bean.
     * @return The type of the inflow bean.
     */
    public String getBeanType() ;
    
    /**
     * Set the name of the JCA resource adapter.
     * @param adapter The JCA resource adapter.
     */
    public void setAdapter(final String adapter) ;
    
    /**
     * Get the name of the JCA resource adapter.
     * @return The JCA resource adapter.
     */
    public String getAdapter() ;
    
    /**
     * Set the transacted flag.
     * @param isTransacted true if the delivery is transacted, false otherwise.
     */
    public void setIsTransacted(final boolean isTransacted) ;
    
    /**
     * Get the transacted flag.
     * @return true if the delivery is transacted, false otherwise.
     */
    public boolean getIsTransacted() ;
    
    /**
     * Set the name of the activation bridge.
     * @param activationBridge The name of the activation bridge.
     */
    public void setActivationBridge(final String activationBridge) ;
    
    /**
     * Get the name of the activation bridge.
     * @return The name of the activation bridge or null if not set.
     */
    public String getActivationBridge() ;
    
    /**
     * Set the activation specification properties.
     * @param activationSpec The activation specification properties.
     */
    public void setActivationSpec(final Properties properties) ;
    
    /**
     * Get the activation specification properties.
     * @return The activation specification properties.
     */
    public Properties getActivationSpec() ;
    
    /**
     * Set the description for the message inflow.
     * @param description The description for the message inflow.
     */
    public void setDescription(final String description) ;
    
    /**
     * Get the description for the message inflow.
     * @return The description for the message inflow or null if not set.
     */
    public String getDescription() ;
}
