/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.internal.soa.esb.couriers.transport;

/**
 * The exception raised for InVM transport errors.
 * 
 * @author <a href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class InVMException extends Exception
{
    /**
     * serial version UID of this exception.
     */
    private static final long serialVersionUID = 3419916783144269048L;

    /**
     * Construct a default InVM exception.
     */
    public InVMException()
    {
    }

    /**
     * Construct an InVM exception with the specified message.
     * @param message The exception message.
     */
    public InVMException(final String message) 
    {
        super(message);
    }

    /**
     * Construct an InVM exception with the associated cause.
     * @param cause The associated cause.
     */
    public InVMException(final Throwable cause)
    {
        super(cause);
    }

    /**
     * Construct an InVM exception with the specified message and associated cause.
     * @param message The exception message.
     * @param cause The associated cause.
     */
    public InVMException(String message, Throwable cause)
    {
        super(message, cause);
    }
}
 