/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ftp;

import org.apache.ftpserver.usermanager.PropertiesUserManager;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.ftplet.User;

import java.io.File;

/**
 * comment
 *
 * @author <a href="bill@jboss.com">Bill Burke</a>
 * @version $Revision: 1.1 $
 */
public class VirtualPropertiesUserManager extends PropertiesUserManager
{
   private String basePath;


   public VirtualPropertiesUserManager()
   {
   }


   public String getBasePath()
   {
      return basePath;
   }

   public void setBasePath(String basePath)
   {
      this.basePath = basePath;
   }


   @Override
   public void setPropFile(File propFile)
   {
      super.setPropFile(propFile);
   }

   @Override
   public synchronized User getUserByName(String userName)
   {
      BaseUser user = (BaseUser)super.getUserByName(userName);
      String home = user.getHomeDirectory();
      if (home == null) return user;
      
      user.setHomeDirectory(basePath + home.substring(2));
      return user;
   }
}
