<%@page contentType="text/html; charset=UTF-8"%>
<%@page import="java.net.URI"%>
<%@page import="java.util.ArrayList"%>
<%@page import="java.util.List"%>
<%@page import="org.jboss.internal.soa.esb.publish.ContractPublisher"%>
<%@page import="org.jboss.internal.soa.esb.publish.ContractReferencePublisher"%>
<%@page import="org.jboss.internal.soa.esb.publish.Publisher"%>
<%@page import="org.jboss.soa.esb.addressing.EPR"%>
<%@page import="org.jboss.soa.esb.listeners.config.ServicePublisher"%>
<%@page import="org.jboss.soa.esb.Service"%>
<%@page import="org.jboss.soa.esb.services.registry.Registry"%>
<%@page import="org.jboss.soa.esb.services.registry.RegistryException"%>
<%@page import="org.jboss.soa.esb.services.registry.RegistryFactory"%>
<html>
<head>
    <title>JBoss ESB - Service List</title>
    <link rel='stylesheet' href='./styles.css'>
</head>
<body>

<div class="pageSection">
<h2>JBoss ESB Service Deployments</h2>
</div>

<div class="pageSection">
    <%
        List<Service> services = ServicePublisher.getServices();
        Registry registry = RegistryFactory.getRegistry();

        for (Service service: services) {
            String serviceCategory = service.getCategory();
            String serviceName = service.getName();
            
            final List<ServicePublisher> servicePublishers = ServicePublisher.getServicePublishers(service) ;
            if ((servicePublishers != null) && (servicePublishers.size() > 0)) {
    %>
    <fieldset>
        <legend><b><%=service%></b></legend>
                <%=servicePublishers.get(0).getDescription()%>
    <%
                for(ServicePublisher servicePublisher: servicePublishers) {
                    final Publisher publisher = servicePublisher.getPublisher() ;
                    if (!(publisher instanceof ContractReferencePublisher)) {
                        List eprs;

                        try {
                            eprs = (List) registry.findEPRs(serviceCategory, serviceName);
                        } catch (Exception e) {
                            // ignore for now - just return an empty list
                            eprs = new ArrayList();
                        }
                        for (int ii = 0; ii < eprs.size(); ii++) {
                            EPR epr = (EPR) eprs.get(ii);
                            URI eprURI = URI.create(epr.getAddr().getAddress());
                            String protocol = eprURI.getScheme();
                            String relContractURI = "contract.jsp?serviceCat=" + serviceCategory + "&serviceName=" + serviceName + "&protocol=" + protocol;
    %>
        <fieldset>
            <legend><b><%=protocol.toUpperCase()%></b></legend>

            <ul>
                <li><b>Endpoint</b>: <%=eprURI%></li>
    <%
                            if(publisher != null && protocol.toLowerCase().startsWith("http")) {
                                URI thisPage = URI.create(request.getRequestURL().toString());
                                URI contractURI = thisPage.resolve(relContractURI);
    %>
                <li><b>Contract</b>: <a href="<%=relContractURI%>"><%=contractURI%></a></li>
    <%
                            } else {
    %>
                <li><b>Contract</b>: Unavailable</li>
    <%
                            }
    %>
            </ul>
        </fieldset>
    <%
                        }
                    } else {
                        final ContractReferencePublisher contractReferencePublisher = (ContractReferencePublisher)publisher ;
                        final URI serviceURI = contractReferencePublisher.getServiceURI() ;
                        final URI serviceContractURI = contractReferencePublisher.getServiceContractURI() ;
    %>
         <fieldset>
            <legend><b><%=serviceURI.getScheme().toUpperCase()%></b></legend>

            <ul>
                <li><b>Endpoint</b>: <%=serviceURI%></li>
                <li><b>Contract</b>: <a href="<%=serviceContractURI%>"><%=serviceContractURI%></a></li>
            </ul>
        </fieldset>
        <%
                    }
                }
    %>
    </fieldset>
    <%
            }
        }
    %>
</div>
</body>
</html>
