<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="UTF-8"
		indent="yes" />

	<xsl:param name="url"></xsl:param>
	<xsl:param name="allaccess"></xsl:param>
	<xsl:template match="/web-app">
		<web-app>
			<xsl:for-each select="/web-app/*">
				<xsl:copy-of select="current()" />
			</xsl:for-each>
			<security-role>
				<role-name>user</role-name>
			</security-role>

			<xsl:if test="$allaccess">
				<security-constraint>
					<web-resource-collection> 
						<web-resource-name>All Access</web-resource-name>
						<url-pattern>/contract.jsp</url-pattern>
					</web-resource-collection> 
				</security-constraint>

			</xsl:if>
			<security-constraint>
				<web-resource-collection>
					<web-resource-name>Authenticated Realm
					</web-resource-name>
					<url-pattern>
						<xsl:value-of select="$url" />
					</url-pattern>
				</web-resource-collection>
				<auth-constraint>
					<role-name>user</role-name>
				</auth-constraint>
			</security-constraint>

			<login-config>
				<auth-method>FORM</auth-method>
				<form-login-config>
					<form-login-page>/login.jsp</form-login-page>
					<form-error-page>/login.jsp?error=1
					</form-error-page>
				</form-login-config>
			</login-config>
		</web-app>
	</xsl:template>

</xsl:stylesheet>
