/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.opensso.aspect;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.system.server.ServerConfigLocator;

import com.sun.identity.setup.SetupConstants;

/**
 * Aspect used to override default preset config directory.
 * 
 * @author <a href='mailto:Kevin.Conner@jboss.com'>Kevin Conner</a>
 */
public class PresetConfigDirAspect
{
    public Object getString(final MethodCalledByMethodInvocation invocation)
        throws Throwable
    {
        Object result = null ;
        try
        {
            result = invocation.invokeNext();
        }
        catch (final MissingResourceException mre)
        {
            result = getPath() ;
        }
        
        return result ;
    }
    
    public Object getBundle(final MethodCalledByMethodInvocation invocation)
        throws Throwable
    {
        Object result = null ;
        try
        {
            result = invocation.invokeNext();
        }
        catch (final MissingResourceException mre)
        {
            final Map<String, String> propertyMap = new HashMap<String, String>() ;
            propertyMap.put(SetupConstants.PRESET_CONFIG_DIR, getPath()) ;
            result = new MapResourceBundle(propertyMap) ;
        }
        
        return result ;
    }
    
    private String getPath()
    {
        final File openssoDir = new File(ServerConfigLocator.locate().getServerDataDir(), "opensso") ;
        return openssoDir.getAbsolutePath() ;
    }
    
    private static final class MapResourceBundle extends ResourceBundle
    {
        private final Map<String, String> propertyMap ;
        
        MapResourceBundle(final Map<String, String> propertyMap)
        {
            this.propertyMap = propertyMap ;
        }
        
        protected Object handleGetObject(final String key)
        {
            return propertyMap.get(key) ;
        }
        
        public Enumeration<String> getKeys()
        {
            return Collections.enumeration(propertyMap.keySet()) ;
        }
    }
}
