package org.jboss.soa.esb.samples.quickstart.helloworld;

import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import javax.ejb.EJB;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;

import org.jboss.security.annotation.SecurityDomain;  
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.ws.annotation.EndpointConfig;


@WebService(serviceName = "HelloWorldWS-WSS", 
		     endpointInterface = "org.jboss.soa.esb.samples.quickstart.helloworld.HelloWorldEjbWSWSS")
@SecurityDomain("JBossWS") 
@EndpointConfig(configName="Standard WSSecurity Endpoint")

@Stateless
public class HelloWorldEjbWSWSSBean implements HelloWorldEjbWSWSS{

	@Resource SessionContext wsCtx;
	
	@PermitAll
	public void sayHello() {
		
		try {
	
			ServiceInvoker invoker = new ServiceInvoker("QuickStart","HelloworldEjb3WSWSS");
			Message message = MessageFactory.getInstance().getMessage();
			
			
			message.getBody().add("Hello " + wsCtx.getCallerPrincipal().getName());
			invoker.deliverAsync(message);
			
	
		} catch (MessageDeliverException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}

}
