/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.web.struts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.samples.jpetstore.domain.Account;
import org.springframework.samples.jpetstore.web.struts.AccountActionForm;
import org.springframework.samples.jpetstore.web.struts.BaseAction;

public class NewAccountAction
extends BaseAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AccountActionForm acctForm = (AccountActionForm)form;
        if ("newAccount".equals(acctForm.getValidate())) {
            acctForm.getAccount().setListOption(request.getParameter("account.listOption") != null);
            acctForm.getAccount().setBannerOption(request.getParameter("account.bannerOption") != null);
            Account account = acctForm.getAccount();
            String username = acctForm.getAccount().getUsername();
            this.getPetStore().insertAccount(account);
            acctForm.setAccount(this.getPetStore().getAccount(username));
            PagedListHolder myList = new PagedListHolder(this.getPetStore().getProductListByCategory(account.getFavouriteCategoryId()));
            myList.setPageSize(4);
            acctForm.setMyList(myList);
            request.getSession().setAttribute("accountForm", (Object)acctForm);
            request.getSession().removeAttribute("workingAccountForm");
            return mapping.findForward("success");
        }
        request.setAttribute("message", (Object)"Your account was not created because the submitted information was not validated.");
        return mapping.findForward("failure");
    }
}

