/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.web.spring;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.samples.jpetstore.domain.Order;
import org.springframework.samples.jpetstore.domain.logic.PetStoreFacade;
import org.springframework.samples.jpetstore.web.spring.UserSession;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.util.WebUtils;

public class ViewOrderController
implements Controller {
    private PetStoreFacade petStore;

    public void setPetStore(PetStoreFacade petStore) {
        this.petStore = petStore;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserSession userSession = (UserSession)WebUtils.getRequiredSessionAttribute((HttpServletRequest)request, (String)"userSession");
        int orderId = Integer.parseInt(request.getParameter("orderId"));
        Order order = this.petStore.getOrder(orderId);
        if (userSession.getAccount().getUsername().equals(order.getUsername())) {
            return new ModelAndView("ViewOrder", "order", (Object)order);
        }
        return new ModelAndView("Error", "message", (Object)"You may only view your own orders.");
    }
}

