/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.samples.jpetstore.dao.ibatis;

import java.util.HashMap;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.samples.jpetstore.dao.ItemDao;
import org.springframework.samples.jpetstore.domain.Item;
import org.springframework.samples.jpetstore.domain.LineItem;
import org.springframework.samples.jpetstore.domain.Order;

public class SqlMapItemDao
extends SqlMapClientDaoSupport
implements ItemDao {
    public void updateQuantity(Order order) throws DataAccessException {
        for (int i = 0; i < order.getLineItems().size(); ++i) {
            LineItem lineItem = (LineItem)order.getLineItems().get(i);
            String itemId = lineItem.getItemId();
            Integer increment = new Integer(lineItem.getQuantity());
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("itemId", itemId);
            param.put("increment", increment);
            this.getSqlMapClientTemplate().update("updateInventoryQuantity", param, 1);
        }
    }

    public boolean isItemInStock(String itemId) throws DataAccessException {
        Integer i = (Integer)this.getSqlMapClientTemplate().queryForObject("getInventoryQuantity", (Object)itemId);
        return i != null && i > 0;
    }

    public List getItemListByProduct(String productId) throws DataAccessException {
        return this.getSqlMapClientTemplate().queryForList("getItemListByProduct", (Object)productId);
    }

    public Item getItem(String itemId) throws DataAccessException {
        Item item = (Item)this.getSqlMapClientTemplate().queryForObject("getItem", (Object)itemId);
        if (item != null) {
            Integer qty = (Integer)this.getSqlMapClientTemplate().queryForObject("getInventoryQuantity", (Object)itemId);
            item.setQuantity(qty);
        }
        return item;
    }
}

