/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.util;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.common.OutputReaderThread;
import com.sun.identity.tune.config.WS7ContainerConfigInfo;
import com.sun.identity.tune.constants.AMTuneConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AMTuneUtil
implements AMTuneConstants {
    private static AMTuneLogger pLogger;
    private static MessageWriter mWriter;
    private static boolean isWindows2003;
    private static boolean isSunOs;
    private static boolean isLinux;
    private static String tempFile;
    private static Map sysInfoMap;
    private static boolean utilInit;
    private static String osArch;
    private static boolean isNiagara;
    private static String date;
    public static String TMP_DIR;

    public static boolean initializeUtil() throws AMTuneException {
        date = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz").format(new Date());
        pLogger = AMTuneLogger.getLoggerInst();
        mWriter = MessageWriter.getInstance();
        AMTuneUtil.checkSystemEnv();
        AMTuneUtil.setTmpDir();
        tempFile = TMP_DIR + "perftune-temp.txt";
        sysInfoMap = new HashMap();
        try {
            if (AMTuneUtil.isWindows2003()) {
                AMTuneUtil.getWinSystemInfo();
                File temp = new File(tempFile);
                if (temp.isFile()) {
                    temp.delete();
                }
            } else if (AMTuneUtil.isSunOs()) {
                AMTuneUtil.checkRootUser();
                AMTuneUtil.getSunOSSystemInfo();
            } else if (AMTuneUtil.isLinux()) {
                AMTuneUtil.checkRootUser();
                AMTuneUtil.getLinuxSystemInfo();
            } else {
                utilInit = false;
                throw new AMTuneException("Unsupported OS.");
            }
            pLogger.log(Level.FINEST, "initializeUtil", "System configuration : " + sysInfoMap.toString());
        }
        catch (Exception ex) {
            pLogger.logException("perftuneutilinit", ex);
            utilInit = false;
            throw new AMTuneException(ex.getMessage());
        }
        return utilInit;
    }

    private static void checkSystemEnv() throws AMTuneException {
        block12: {
            mWriter.writelnLocaleMsg("pt-checking-system-env");
            osArch = System.getProperty("os.arch");
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            pLogger.log(Level.INFO, "checkSystemEnv", "OS name :" + osName);
            pLogger.log(Level.INFO, "checkSystemEnv", "OS Version :" + osVersion);
            pLogger.log(Level.INFO, "checkSystemEnv", "OS Arch :" + osArch);
            if (osName.equalsIgnoreCase("SUNOS")) {
                isSunOs = true;
                if (osArch.contains("sparc") || osArch.contains("86")) {
                    int solVersion = Integer.parseInt(osVersion.replace("5.", ""));
                    if (solVersion > 8) {
                        return;
                    }
                    mWriter.writelnLocaleMsg("pt-unsupported-sol");
                    throw new AMTuneException("Unsupported Solaris Version");
                }
                mWriter.writelnLocaleMsg("pt-unsupported-arch");
                throw new AMTuneException("Unsupported Architecture");
            }
            if (osName.equalsIgnoreCase("Windows 2003")) {
                isWindows2003 = true;
            } else {
                if (osName.equalsIgnoreCase("Linux")) {
                    isLinux = true;
                    String rVersionFile = "/etc/redhat-release";
                    try {
                        FileHandler fh = new FileHandler(rVersionFile);
                        String reqLine = fh.getLine("Red Hat");
                        if (reqLine == null || reqLine != null && reqLine.trim().length() == 0) {
                            mWriter.writelnLocaleMsg("pt-unsupported-lnx");
                            String curVersion = fh.getLine(0);
                            if (curVersion != null) {
                                pLogger.log(Level.SEVERE, "checkSystemEnv", "Unsupported Linux : " + curVersion);
                            }
                            throw new AMTuneException("Unsupported Linux ");
                        }
                        int relidx = reqLine.indexOf("release");
                        String ver = reqLine.substring(relidx + 8, relidx + 10);
                        pLogger.log(Level.INFO, "checkSystemEnv", "Red Hat version " + ver);
                        int version = Integer.parseInt(ver.trim());
                        if (version < 4) {
                            mWriter.writelnLocaleMsg("pt-unsupported-lnx");
                            throw new AMTuneException("Unsupported Red Hat Linux " + version);
                        }
                        break block12;
                    }
                    catch (FileNotFoundException fe) {
                        throw new AMTuneException("File not found " + rVersionFile);
                    }
                    catch (IOException ioe) {
                        throw new AMTuneException("Error reading file " + ioe.getMessage());
                    }
                }
                mWriter.writelnLocaleMsg("pt-unsupported-os");
                throw new AMTuneException("Unsupported Operating system.");
            }
        }
    }

    private static void getSunOSSystemInfo() throws AMTuneException {
        try {
            AMTuneUtil.getCommonNXSystemInfo();
            String nCmd = "/bin/uname -i";
            StringBuffer rBuf = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writeLocaleMsg("pt-unable-hw-pt");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Error finding hardware platform");
            }
            String hwPlatform = rBuf.toString();
            if (hwPlatform != null && hwPlatform.trim().length() > 0) {
                if (hwPlatform.length() > 15) {
                    hwPlatform = hwPlatform.substring(5, 15);
                }
            } else {
                mWriter.writeLocaleMsg("pt-unable-hw-pt");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Hardware platform is null.");
            }
            sysInfoMap.put("HWPLATFORM", hwPlatform.trim());
            nCmd = "/usr/sbin/psrinfo";
            rBuf.setLength(0);
            extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writeLocaleMsg("pt-unable-no-cpu");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("psrinfo command error.");
            }
            int noCpus = AMTuneUtil.getWordCount(rBuf.toString(), "on-line");
            if (noCpus == 0) {
                mWriter.writeLocaleMsg("pt-unable-no-cpu");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("No of CPUs 0.");
            }
            if (hwPlatform != null && hwPlatform.indexOf("Sun-Fire-T") >= 0) {
                isNiagara = true;
                pLogger.log(Level.INFO, "getSunOSSystemInfo", "Tuning Niagarabox");
                noCpus = noCpus >= 4 ? (noCpus /= 4) : 1;
            }
            sysInfoMap.put("Processor", Integer.toString(noCpus));
            rBuf.setLength(0);
            nCmd = "/usr/sbin/prtconf";
            extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writeLocaleMsg("pt-unable-avmem");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("prtconf command error.");
            }
            StringTokenizer st = new StringTokenizer(rBuf.toString(), "\n");
            while (st.hasMoreTokens()) {
                String reqLine = st.nextToken();
                if (reqLine.indexOf("Memory size: ") < 0) continue;
                String size = reqLine.replace("Memory size: ", "").replace(" Megabytes", "");
                sysInfoMap.put("Total Physical Memory:", size);
            }
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "getSunOSSystemInfo", "Error finding SUNOS system information ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private static void getCommonNXSystemInfo() throws AMTuneException {
        try {
            String nCmd = "/bin/domainname";
            StringBuffer rBuf = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writeLocaleMsg("pt-unable-domainname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Domainname command error.");
            }
            String domainName = rBuf.toString();
            if (domainName == null || domainName.length() <= 1) {
                mWriter.writeLocaleMsg("pt-unable-domainname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Domain name is null");
            }
            sysInfoMap.put("Domain:", domainName.trim());
            nCmd = "/bin/hostname";
            rBuf.setLength(0);
            extVal = AMTuneUtil.executeCommand(nCmd, rBuf);
            if (extVal == -1) {
                mWriter.writeLocaleMsg("pt-unable-hostname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Hostname command error.");
            }
            String hostName = rBuf.toString();
            if (hostName != null && hostName.trim().length() > 1) {
                if (hostName.indexOf(".") != -1) {
                    hostName = hostName.substring(0, hostName.indexOf("."));
                }
            } else {
                mWriter.writeLocaleMsg("pt-unable-hostname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Host name is null");
            }
            sysInfoMap.put("Host Name:", hostName.trim() + "." + domainName.trim());
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "getCommonNXSystemInfo", "Error finding hostname or domain name.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private static void getLinuxSystemInfo() throws AMTuneException {
        try {
            AMTuneUtil.getCommonNXSystemInfo();
            FileHandler fh = new FileHandler("/proc/meminfo");
            String memSize = fh.getLine("MemTotal:").replace("MemTotal:", "");
            memSize = memSize.replace("kB", "");
            memSize = memSize.trim();
            if (memSize == null) {
                mWriter.writeLocaleMsg("pt-unable-avmem");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Couldn't find memory size.");
            }
            int size = Integer.parseInt(memSize) / 1024;
            sysInfoMap.put("Total Physical Memory:", Integer.toString(size));
            FileHandler fh2 = new FileHandler("/proc/cpuinfo");
            String[] lines = fh2.getMattchingLines("processor", false);
            if (lines.length < 0) {
                mWriter.writeLocaleMsg("pt-unable-no-cpu");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Couldn't find no of cpus.");
            }
            sysInfoMap.put("Processor", Integer.toString(lines.length));
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "getLinuxSystemInfo", "Error finding LINUX System information");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private static void checkRootUser() throws AMTuneException {
        String userName = System.getProperty("user.name");
        mWriter.writelnLocaleMsg("pt-check-user");
        if (userName.indexOf("root") < 0) {
            mWriter.writelnLocaleMsg("pt-should-be-root-user");
            throw new AMTuneException("Not root user.");
        }
    }

    private static void getWinSystemInfo() throws AMTuneException {
        try {
            String hostNameCmd = "cmd /C systeminfo > " + tempFile;
            StringBuffer rBuf = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(hostNameCmd, rBuf);
            if (extVal == -1) {
                throw new AMTuneException("Couldn't get System information tuning will not be done.");
            }
            FileHandler fh = new FileHandler(tempFile);
            String reqLine = fh.getLine("Domain:");
            if (reqLine == null || reqLine.length() <= 1) {
                mWriter.writeLocaleMsg("pt-unable-domainname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Domain name is null");
            }
            int startIdx = reqLine.lastIndexOf(":");
            String domainName = reqLine.substring(startIdx + 1).trim();
            reqLine = fh.getLine("Host Name:");
            if (reqLine == null || reqLine.length() <= 1) {
                mWriter.writeLocaleMsg("pt-unable-hostname");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Host name is null");
            }
            int startIdx2 = reqLine.lastIndexOf(":");
            String hostName = reqLine.substring(startIdx2 + 1).trim();
            domainName = domainName.replace(hostName + ".", "");
            sysInfoMap.put("Host Name:", hostName + "." + domainName.trim());
            sysInfoMap.put("Domain:", domainName);
            reqLine = fh.getLine("Processor");
            if (reqLine == null || reqLine.length() <= 1) {
                mWriter.writeLocaleMsg("pt-unable-no-cpu");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Couldn't find number of processors.");
            }
            int startIdx3 = reqLine.lastIndexOf(":");
            String numProcessors = reqLine.substring(startIdx3 + 1).trim();
            numProcessors = numProcessors.substring(0, 2).trim();
            sysInfoMap.put("Processor", numProcessors);
            reqLine = fh.getLine("Total Physical Memory:");
            if (reqLine == null || reqLine.length() <= 1) {
                mWriter.writeLocaleMsg("pt-unable-avmem");
                mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Couldn't find number of processors.");
            }
            int startIdx4 = reqLine.lastIndexOf(":");
            String memSize = reqLine.substring(startIdx4 + 1).trim();
            StringTokenizer st = new StringTokenizer(memSize, " ");
            st.hasMoreTokens();
            memSize = st.nextToken();
            memSize = memSize.replace(",", "");
            sysInfoMap.put("Total Physical Memory:", memSize);
            if (hostName != null && domainName != null) {
                domainName = domainName.replace(hostName + ".", "");
                sysInfoMap.put("Host Name:", hostName + "." + domainName);
            }
            fh.close();
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "getWinSystemInfo", "Error finding system information ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public static String getHostName() {
        if (sysInfoMap.get("Host Name:").toString().indexOf(AMTuneUtil.getDomainName()) == -1) {
            return (String)sysInfoMap.get("Host Name:") + "." + AMTuneUtil.getDomainName();
        }
        return (String)sysInfoMap.get("Host Name:");
    }

    public static String getDomainName() {
        return (String)sysInfoMap.get("Domain:");
    }

    public static String getNumberOfCPUS() {
        return (String)sysInfoMap.get("Processor");
    }

    public static String getSystemMemory() {
        return (String)sysInfoMap.get("Total Physical Memory:");
    }

    public static String getOSPlatform() {
        return osArch;
    }

    public static String getHardWarePlatform() {
        return (String)sysInfoMap.get("HWPLATFORM");
    }

    public static int executeCommand(String command, StringBuffer resultBuffer) {
        pLogger.log(Level.FINEST, "executeCommand", "Executing command : " + command);
        try {
            Process execProcess = null;
            execProcess = Runtime.getRuntime().exec(command);
            if (resultBuffer != null) {
                resultBuffer.setLength(0);
            }
            OutputReaderThread outReaderThread = new OutputReaderThread(execProcess.getInputStream());
            OutputReaderThread errorReaderThread = new OutputReaderThread(execProcess.getErrorStream());
            outReaderThread.start();
            errorReaderThread.start();
            execProcess.waitFor();
            int exitValue = execProcess.exitValue();
            outReaderThread.join(3000L);
            errorReaderThread.join(3000L);
            execProcess.destroy();
            outReaderThread.interrupt();
            errorReaderThread.interrupt();
            boolean errorOccured = false;
            if (resultBuffer != null) {
                StringBuffer outBuffer = outReaderThread.getBuffer();
                StringBuffer errorBuffer = errorReaderThread.getBuffer();
                if (outBuffer != null && outBuffer.length() != 0) {
                    pLogger.log(Level.FINEST, "executeCommand", "Out buffer content : " + outBuffer.toString());
                    resultBuffer.append(outBuffer.toString());
                }
                if (errorBuffer != null && errorBuffer.length() != 0) {
                    pLogger.log(Level.FINEST, "executeCommand", "Error buffer content : " + errorBuffer.toString());
                    resultBuffer.append(errorBuffer.toString());
                    errorOccured = true;
                }
            }
            pLogger.log(Level.INFO, "executeCommand", "Command exit value " + exitValue);
            if (exitValue != 0 && errorOccured) {
                throw new AMTuneException("Error executing command. ");
            }
            return exitValue;
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "executeCommand", "Executing command " + command + " failed.");
            pLogger.log(Level.SEVERE, "executeCommand", "Error is " + resultBuffer.toString());
            pLogger.logException("executeCommand", ex);
            resultBuffer.insert(0, ex.getMessage());
            return -1;
        }
    }

    public static int executeScriptCmd(String command, StringBuffer resultBuffer) throws AMTuneException {
        int extVal = -1;
        String tempF = TMP_DIR + "amtunecmdhelper.sh";
        try {
            if (!AMTuneUtil.isWindows2003()) {
                pLogger.log(Level.FINE, "executeScriptCmd", "Command in the file :" + command);
                File tempSh = new File(tempF);
                BufferedWriter br = new BufferedWriter(new FileWriter(tempSh));
                br.write(command);
                br.close();
                extVal = AMTuneUtil.executeCommand("chmod 777 " + tempF, resultBuffer);
                extVal = AMTuneUtil.executeCommand(tempF, resultBuffer);
                tempSh.delete();
            }
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
        finally {
            File tempSh = new File(tempF);
            if (tempSh.isFile()) {
                tempSh.delete();
            }
        }
        return extVal;
    }

    public static double evaluteDivExp(String divExp) throws NumberFormatException, NullPointerException {
        StringTokenizer st = new StringTokenizer(divExp, "/");
        st.hasMoreTokens();
        double operand1 = Double.parseDouble(st.nextToken().trim());
        st.hasMoreTokens();
        double operand2 = Double.parseDouble(st.nextToken().trim());
        return operand1 / operand2;
    }

    public static long getDirSize(String directory) {
        long size = 0L;
        File instanceDir = new File(directory);
        String[] list = instanceDir.list();
        for (int i = 0; i < list.length; ++i) {
            File tFile = new File(directory + "/" + list[i]);
            if (tFile.isDirectory()) {
                size += AMTuneUtil.getDirSize(directory + "/" + list[i]);
                continue;
            }
            size += tFile.length();
        }
        return size;
    }

    public static void replaceToken(StringBuffer buf, String key, String value) {
        if (key == null || value == null || buf == null) {
            return;
        }
        int loc = 0;
        int keyLen = key.length();
        int valLen = value.length();
        while ((loc = buf.toString().indexOf(key, loc)) != -1) {
            buf.replace(loc, loc + keyLen, value);
            loc += valLen;
        }
    }

    public static String getRandomStr() {
        String DATE_FORMAT = "yyyyMMdd";
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        String ranStr = Double.toString(Math.random()).substring(5);
        String rand = df.format(new Date(System.currentTimeMillis())) + "-" + ranStr;
        return rand;
    }

    public static void CopyFile(File source, File dest) throws Exception {
        if (source == null || dest == null) {
            throw new IllegalArgumentException();
        }
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(dest);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static boolean isWindows2003() {
        return isWindows2003;
    }

    public static boolean isSunOs() {
        return isSunOs;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isNiagara() {
        return isNiagara;
    }

    public static String getLastToken(String stream, String delim) {
        String val = " ";
        if (stream != null && stream.trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(stream, delim);
            while (st.hasMoreTokens()) {
                val = st.nextToken().trim();
            }
        }
        return val;
    }

    public static void backupConfigFile(String confFile, String backupDir) throws AMTuneException {
        try {
            File confF = new File(confFile);
            if (!confF.isFile()) {
                mWriter.writelnLocaleMsg("pt-conf-file-missing");
                throw new AMTuneException("Config file " + confFile + " is missing.");
            }
            File bkDir = new File(AMTuneUtil.getCurDir() + "../.." + "/" + backupDir);
            if (!bkDir.isDirectory()) {
                bkDir.mkdirs();
            }
            String baseFileName = confF.getName();
            String bkFileName = bkDir + "/" + baseFileName + "-orig" + AMTuneUtil.getRandomStr();
            mWriter.writeLocaleMsg("pt-bk-file");
            mWriter.writeln(" " + confFile + " to " + bkFileName);
            AMTuneUtil.CopyFile(new File(confFile), new File(bkFileName));
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "backupConfigFile", "Couldn't backup file.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public static void backupConfigFile(String confFile) throws AMTuneException {
        try {
            File confF = new File(confFile);
            if (!confF.isFile()) {
                mWriter.writelnLocaleMsg("pt-conf-file-missing");
                throw new AMTuneException("Config file " + confFile + " is missing.");
            }
            String bkDir = confF.getParent();
            String baseFileName = confF.getName();
            String bkFileName = bkDir + "/" + baseFileName + "-orig" + AMTuneUtil.getRandomStr();
            mWriter.writeLocaleMsg("pt-bk-file");
            mWriter.writeln(" " + confFile + " to " + bkFileName);
            AMTuneUtil.CopyFile(new File(confFile), new File(bkFileName));
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "backupConfigFile", "Couldn't backup file.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public static String getCurDir() {
        File tempF = new File("tempdbk");
        String filePath = tempF.getAbsolutePath();
        filePath = filePath.replace("tempdbk", "");
        return filePath;
    }

    public static void writeResultBufferToTempFile(StringBuffer buf, String tFile) throws AMTuneException {
        try {
            File f = new File(tFile);
            FileWriter fw = new FileWriter(new File(tFile));
            fw.write(buf.toString());
            fw.flush();
            fw.close();
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "writeResultBufferToTempFile", "Couldn't write buffer to file.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public static String getASJVMOption(List curOptList, String reqFlag, boolean lastToken) {
        Iterator optItr = curOptList.iterator();
        while (optItr.hasNext()) {
            String curFlag = (String)optItr.next();
            if (curFlag.indexOf(reqFlag) == -1) continue;
            if (lastToken) {
                return AMTuneUtil.getLastToken(curFlag, "=");
            }
            return curFlag;
        }
        return "<No value set>";
    }

    public static int getWordCount(String str, String reqWord) {
        StringTokenizer st = new StringTokenizer(str, "\n");
        pLogger.log(Level.FINEST, "getWordCount", "Source string :" + str);
        pLogger.log(Level.FINEST, "getWordCount", "Word to find :" + reqWord);
        int count = 0;
        while (st.hasMoreTokens()) {
            String reqStr = st.nextToken();
            if (!reqStr.contains(reqWord)) continue;
            ++count;
        }
        return count;
    }

    public static String[] getMatchedLines(String[] lines, String pattern) {
        ArrayList<String> matList = new ArrayList<String>();
        Pattern p = Pattern.compile(pattern);
        int size = lines.length;
        int i = 0;
        for (i = 0; i < size; ++i) {
            Matcher m = p.matcher(lines[i]);
            if (!m.find()) continue;
            matList.add(lines[i]);
        }
        String[] arr = new String[matList.size()];
        for (i = 0; i < matList.size(); ++i) {
            arr[i] = new String(matList.get(i).toString());
        }
        return arr;
    }

    public static String getMatchedLine(List lines, String pattern) {
        Iterator itr = lines.iterator();
        while (itr.hasNext()) {
            String curLine = itr.next().toString();
            if (curLine.indexOf(pattern) == -1) continue;
            return curLine;
        }
        return null;
    }

    public static String getTodayDateStr() {
        return date;
    }

    public static void printErrorMsg(String propertyName) {
        mWriter.writelnLocaleMsg("pt-cannot-proceed");
        mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
        mWriter.writeln(propertyName);
    }

    public static List getTokensList(String line, String delim) {
        StringTokenizer str = new StringTokenizer(line, delim);
        ArrayList<String> tokens = new ArrayList<String>();
        while (str.hasMoreTokens()) {
            tokens.add(str.nextToken());
        }
        return tokens;
    }

    public static void reStartWS7Serv(WS7ContainerConfigInfo wsConfigInfo) {
        try {
            pLogger.log(Level.INFO, "reStartServ", "Deploying configuration.");
            StringBuffer restartCmd = new StringBuffer(wsConfigInfo.getWSAdminCmd());
            restartCmd.append("restart-instance");
            restartCmd.append(wsConfigInfo.getWSAdminCommonParams());
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = AMTuneUtil.executeCommand(restartCmd.toString(), resultBuffer);
            if (retVal == -1) {
                pLogger.log(Level.SEVERE, "reStartServ", "Error executing command " + restartCmd);
            }
        }
        catch (Exception ex) {
            pLogger.log(Level.SEVERE, "reStartServ", "Restart failed. " + ex.getMessage());
        }
    }

    public static boolean isSupportedWebContainer(String webContainer) {
        return webContainer.indexOf("WS7") != -1 || webContainer.indexOf("AS91") != -1;
    }

    public static boolean isSupportedSMDSVersion(String dsVersion) {
        return (dsVersion.indexOf("6.3") != -1 || dsVersion.indexOf("5.") != -1 || dsVersion.indexOf("openDS") != -1) && !dsVersion.equalsIgnoreCase("6.2");
    }

    public static boolean isSupportedUMDSVersion(String dsVersion) {
        return (dsVersion.indexOf("6.3") != -1 || dsVersion.indexOf("5.") != -1) && !dsVersion.equalsIgnoreCase("6.2");
    }

    private static void setTmpDir() {
        TMP_DIR = AMTuneUtil.isSunOs() || AMTuneUtil.isLinux() ? "/tmp/" : System.getProperty("java.io.tmpdir");
    }

    static {
        utilInit = true;
        isNiagara = false;
    }
}

