/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.base.AMTuneDSBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;

public class TuneDS5Impl
extends AMTuneDSBase {
    private String db2BakPath;
    private String db2IndexPath;
    private String stopCmdPath;
    private String startCmdPath;
    private String dbBackUpDir;

    public TuneDS5Impl(boolean isSMStore) {
        super(isSMStore);
    }

    public void initialize(AMTuneConfigInfo confInfo) throws AMTuneException {
        super.initialize(confInfo);
        if (AMTuneUtil.isWindows2003()) {
            this.db2BakPath = this.instanceDir + "/" + "db2bak.bat ";
            this.db2IndexPath = this.instanceDir + "/" + "db2index.pl ";
            this.stopCmdPath = this.instanceDir + "/" + "stop-slapd.bat";
            this.startCmdPath = this.instanceDir + "/" + "start-slapd.bat";
        } else {
            this.db2BakPath = this.instanceDir + "/" + "db2bak ";
            this.db2IndexPath = this.instanceDir + "/" + "db2index.pl ";
            this.stopCmdPath = this.instanceDir + "/" + "stop-slapd";
            this.startCmdPath = this.instanceDir + "/" + "start-slapd";
        }
        this.dbBackUpDir = "amtune-" + AMTuneUtil.getRandomStr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTuning() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "startTuning", "Start tuning.");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-fam-ds-tuning");
            if (this.isSM) {
                this.mWriter.writelnLocaleMsg("pt-fam-sm-ds-tuning");
            }
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-init");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.computeTuneValues();
            this.mWriter.writeln("=====================================================================");
            this.modifyLDAP();
            if (!AMTuneUtil.isWindows2003()) {
                this.tuneUsingDSE();
            }
            if (!this.isSM) {
                this.tuneDSIndex();
            }
            this.tuneFuture();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "startTuning", "Error tuning DS5.2");
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.pLogger.logException("startTuning", ex);
        }
        finally {
            try {
                this.releaseCon();
            }
            catch (Exception exception) {}
            this.deletePasswordFile();
        }
    }

    protected void tuneUsingDSE() throws AMTuneException {
        try {
            super.tuneUsingDSE();
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "");
            if (this.configInfo.isReviewMode()) {
                return;
            }
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "Modify dse.ldif");
            if (this.curDBHomeLocation.equals(this.newDBHomeLocation)) {
                this.pLogger.log(Level.INFO, "tuneUsingDSE", "Current DB Location is same as recommended value.");
                return;
            }
            this.stopDS();
            this.backUpDS();
            FileHandler dseH = new FileHandler(this.dseLdifPath);
            int reqLineNo = dseH.lineContains("nsslapd-db-home-directory:");
            dseH.replaceLine(reqLineNo, "nsslapd-db-home-directory: " + this.newDBHomeLocation);
            dseH.close();
            this.startDS();
        }
        catch (FileNotFoundException fex) {
            throw new AMTuneException(fex.getMessage());
        }
        catch (IOException ioe) {
            throw new AMTuneException(ioe.getMessage());
        }
    }

    private void modifyLDAP() throws AMTuneException {
        this.pLogger.log(Level.FINE, "modifyLDAP", "Modify LDAP attributes.");
        boolean applyRec = false;
        boolean remAci = false;
        this.ldapTuningRecommendations();
        if (this.configInfo.isReviewMode()) {
            return;
        }
        this.stopDS();
        this.backUpDS();
        this.startDS();
        applyRec = this.applyRecommendations();
        if (applyRec || remAci) {
            this.stopDS();
            this.startDS();
        }
    }

    private void tuneDSIndex() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "tuneDSIndex", "Tune DS Index.");
            String dn = this.getDBDN();
            StringTokenizer firstCol = new StringTokenizer(dn, ",");
            String dbName = firstCol.nextToken().replace("cn=", "");
            List existingIdx = this.getIndexForDB(dbName);
            List notIdxList = this.tuneDSIndex(existingIdx);
            if (this.configInfo.isReviewMode()) {
                return;
            }
            if (notIdxList.size() == 0) {
                this.mWriter.writelnLocaleMsg("pt-all-idx-exist");
            } else {
                this.mWriter.writeLocaleMsg("pt-creating-idx");
                this.mWriter.writeln(notIdxList.toString());
                Iterator idxListItr = notIdxList.iterator();
                while (idxListItr.hasNext()) {
                    String curAttr = (String)idxListItr.next();
                    this.mWriter.writeLocaleMsg("pt-create-idx-attr");
                    this.mWriter.writeln(curAttr);
                    this.createIndex(curAttr);
                    this.mWriter.writelnLocaleMsg("pt-done");
                }
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "tundeDSIndex", "Error tuning DS5 index");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private void createIndex(String attrName) throws AMTuneException {
        try {
            StringBuffer resultBuffer;
            String idxCmd;
            int retVal;
            this.pLogger.log(Level.FINE, "createIndex", "Creating index for " + attrName);
            String dbName = this.getDBName();
            String newDn = "cn=" + attrName + ",cn=index,cn=" + dbName + "," + "cn=ldbm database,cn=plugins,cn=config";
            String[] objClassArr = new String[]{"top", "nsIndex"};
            String[] idxTypes = new String[]{"pres", "eq", "sub"};
            LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute("objectClass", objClassArr), new LDAPAttribute("cn", attrName), new LDAPAttribute("nsSystemIndex", idxTypes)};
            LDAPAttributeSet attrSet = new LDAPAttributeSet(attrs);
            LDAPEntry newIdxEntry = new LDAPEntry(newDn, attrSet);
            this.addLDAPEntry(newIdxEntry);
            String perlExePath = this.configInfo.getPerlBinDir() + "/" + "perl.exe ";
            File pexe = new File(perlExePath);
            if (!pexe.isFile()) {
                perlExePath = "perl.exe ";
            }
            if ((retVal = AMTuneUtil.executeCommand(idxCmd = perlExePath + this.db2IndexPath + "-D \"" + this.dsConfInfo.getDirMgrUid() + "\" -j " + this.dsPassFilePath + " -n " + dbName + " -t " + attrName, resultBuffer = new StringBuffer())) == -1) {
                throw new AMTuneException(resultBuffer.toString());
            }
        }
        catch (Exception ex) {
            this.mWriter.writelnLocaleMsg("pt-idx-create-error");
            this.pLogger.log(Level.SEVERE, "createIndex", "Error creating index for attribute " + attrName);
        }
    }

    protected void backUpDS() throws AMTuneException {
        try {
            String dbBackUpSuccessFile = this.instanceDir + "/" + "bak" + "/" + this.dbBackUpDir + "/" + "SUCCESS.dontdelete";
            File successFile = new File(dbBackUpSuccessFile);
            if (successFile.isFile()) {
                this.pLogger.log(Level.INFO, "backUpDS", "Backup exists");
                return;
            }
            File bakDir = new File(this.instanceDir + "/" + "bak");
            if (!bakDir.isDirectory()) {
                bakDir.mkdir();
            }
            StringBuffer resultBuffer = new StringBuffer();
            String db2BakCmd = this.db2BakPath + bakDir.getAbsolutePath() + "/" + this.dbBackUpDir;
            this.pLogger.log(Level.FINE, "backUpDS", "Backing up DS.");
            int retVal = AMTuneUtil.executeCommand(db2BakCmd, resultBuffer);
            if (retVal == -1) {
                this.mWriter.writelnLocaleMsg("pt-cannot-backup-db");
                this.pLogger.log(Level.SEVERE, "backUpDS", "Error taking backup: " + resultBuffer.toString());
                throw new AMTuneException("Data Base Backup failed.");
            }
            this.pLogger.log(Level.FINE, "backUpDS", "Backing up Done...");
            try {
                File dseLdif = new File(this.dseLdifPath);
                this.pLogger.log(Level.FINE, "backUpDS", "Backing " + this.dseLdifPath);
                File bakDseFile = new File(this.instanceDir + "/" + "bak" + "/" + this.dbBackUpDir + "/" + "dse.ldif");
                AMTuneUtil.CopyFile(dseLdif, bakDseFile);
                this.pLogger.log(Level.FINE, "backUpDS", "Backing Done..");
            }
            catch (Exception ex) {
                throw new AMTuneException("Couldn't bakup dse.ldif. " + ex.getMessage());
            }
            successFile.createNewFile();
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void stopDS() throws AMTuneException {
        this.pLogger.log(Level.FINE, "stopDS", "Stopping DS.");
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = AMTuneUtil.executeCommand(this.stopCmdPath, resultBuffer);
        if (retVal == -1) {
            throw new AMTuneException(resultBuffer.toString());
        }
        this.pLogger.log(Level.FINE, "stopDS", "DS Successfully stopped.");
    }

    protected void startDS() throws AMTuneException {
        this.pLogger.log(Level.FINE, "startDS", "Starting DS.");
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = AMTuneUtil.executeCommand(this.startCmdPath, resultBuffer);
        if (retVal == -1) {
            throw new AMTuneException(resultBuffer.toString());
        }
        this.pLogger.log(Level.FINE, "startDS", "DS Successfully started.");
    }
}

