/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.base;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.intr.TuneFAM;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;

public abstract class AMTuneFAMBase
extends TuneFAM {
    private String famPassFilePath;
    protected String famCmdPath;
    protected AMTuneConfigInfo configInfo;
    protected AMTuneLogger pLogger;
    protected MessageWriter mWriter;
    protected String famadmCommonParamsNoServer;

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        this.configInfo = configInfo;
        this.famPassFilePath = AMTuneUtil.TMP_DIR + "fampassfile";
        this.pLogger = AMTuneLogger.getLoggerInst();
        this.mWriter = MessageWriter.getInstance();
        this.setFAMAdmCmd();
        this.famadmCommonParamsNoServer = " --adminid " + configInfo.getFAMAdmUser() + " --password-file " + this.famPassFilePath;
        this.writePasswordToFile();
    }

    private void setFAMAdmCmd() throws AMTuneException {
        this.famCmdPath = AMTuneUtil.isWindows2003() ? this.configInfo.getFAMAdmLocation() + "/" + "famadm.bat " : this.configInfo.getFAMAdmLocation() + "/" + "famadm ";
        File famAdmF = new File(this.famCmdPath.trim());
        if (!famAdmF.isFile()) {
            this.mWriter.writelnLocaleMsg("pt-fam-tool-not-found");
            this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
            this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
            this.mWriter.writeln("FAMADM_LOCATION");
        }
    }

    protected void writePasswordToFile() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "writePasswordToFile", "Creating FAM password file.");
            File passFile = new File(this.famPassFilePath);
            BufferedWriter pOut = new BufferedWriter(new FileWriter(passFile));
            pOut.write(this.configInfo.getFamAdminPassword());
            pOut.flush();
            pOut.close();
            if (!AMTuneUtil.isWindows2003()) {
                String chmodCmd = "/bin/chmod 400 " + this.famPassFilePath;
                StringBuffer rbuff = new StringBuffer();
                int ext = AMTuneUtil.executeCommand(chmodCmd, rbuff);
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "writePassWordToFile", "Couldn't write password to file. ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void deletePasswordFile() {
        if (!AMTuneUtil.isWindows2003()) {
            String chmodCmd = "/bin/chmod 700 " + this.famPassFilePath;
            StringBuffer rbuff = new StringBuffer();
            int n = AMTuneUtil.executeCommand(chmodCmd, rbuff);
        }
        File passFile = new File(this.famPassFilePath);
        passFile.delete();
    }

    protected void updateFAMServiceCfg(List attrs) {
        StringBuffer resultBuffer = new StringBuffer();
        try {
            StringBuffer updateCmd = new StringBuffer(this.famCmdPath);
            updateCmd.append("update-server-cfg");
            updateCmd.append(this.famadmCommonParamsNoServer);
            updateCmd.append(" ");
            updateCmd.append("--servername");
            updateCmd.append(" ");
            updateCmd.append(this.configInfo.getFAMServerUrl());
            updateCmd.append(" ");
            updateCmd.append("--attributevalues");
            if (!AMTuneUtil.isWindows2003()) {
                updateCmd.append(" ");
            } else {
                updateCmd.append(" \"");
            }
            Iterator itr = attrs.iterator();
            while (itr.hasNext()) {
                int retVal;
                String args = itr.next().toString();
                String cmd = updateCmd.toString() + args;
                if (AMTuneUtil.isWindows2003()) {
                    cmd = cmd + "\"";
                }
                this.pLogger.log(Level.FINEST, "updateFAMServiceCfg", "Executing cmd " + cmd);
                if (!AMTuneUtil.isWindows2003()) {
                    try {
                        retVal = AMTuneUtil.executeScriptCmd(cmd, resultBuffer);
                    }
                    catch (AMTuneException ex) {
                        retVal = -1;
                    }
                } else {
                    retVal = AMTuneUtil.executeCommand(cmd, resultBuffer);
                }
                if (retVal != -1) continue;
                this.pLogger.log(Level.SEVERE, "updateFAMServiceCfg", "Error updating fam service config values.");
                throw new AMTuneException(resultBuffer.toString());
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "updateFAMServiceCfg", "Error updating FAM Server configuration. " + ex.getMessage());
        }
    }

    protected List getDataStoreList(String realmName) throws AMTuneException {
        ArrayList<String> dataStoreList = new ArrayList<String>();
        try {
            this.pLogger.log(Level.INFO, "getDataStoreList", "Getting datastore list. ");
            StringBuffer dataStoreListCmd = new StringBuffer(this.famCmdPath);
            dataStoreListCmd.append("list-datastores");
            dataStoreListCmd.append(" -e ");
            dataStoreListCmd.append(realmName);
            dataStoreListCmd.append(this.famadmCommonParamsNoServer);
            StringBuffer rBuff = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(dataStoreListCmd.toString(), rBuff);
            if (extVal == -1) {
                throw new AMTuneException("List data store cmd failed. ");
            }
            if (rBuff.indexOf("There were no datastores") != -1) {
                this.pLogger.log(Level.SEVERE, "getDataStoreList", "No datastore for the realm:" + realmName);
            } else {
                String reqStr = rBuff.toString().trim().replace("Datastore:", "");
                StringTokenizer str = new StringTokenizer(reqStr, "\n");
                while (str.hasMoreTokens()) {
                    String dsName = str.nextToken();
                    if (dsName == null || dsName.trim().length() <= 0) continue;
                    dataStoreList.add(dsName);
                }
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "getDataStoreList", "Error getting data store list. ");
            throw new AMTuneException(ex.getMessage());
        }
        this.pLogger.log(Level.FINEST, "getDataStoreList", "Returning datastore list. " + ((Object)dataStoreList).toString());
        return dataStoreList;
    }

    protected Map getFAMServerConfig() {
        HashMap<String, String> famCfgInfo = new HashMap<String, String>();
        StringBuffer listSerCfgCmd = new StringBuffer(this.famCmdPath);
        listSerCfgCmd.append("list-server-cfg");
        listSerCfgCmd.append(" ");
        listSerCfgCmd.append("--servername");
        listSerCfgCmd.append(" ");
        listSerCfgCmd.append(this.configInfo.getFAMServerUrl());
        listSerCfgCmd.append(this.famadmCommonParamsNoServer);
        listSerCfgCmd.append(" -w");
        StringBuffer rBuff = new StringBuffer();
        int extVal = AMTuneUtil.executeCommand(listSerCfgCmd.toString(), rBuff);
        if (extVal != -1) {
            StringTokenizer str = new StringTokenizer(rBuff.toString(), "\n");
            while (str.hasMoreTokens()) {
                String line = str.nextToken();
                if (line == null || line.length() <= 0) continue;
                StringTokenizer lStr = new StringTokenizer(line, "=");
                lStr.hasMoreTokens();
                String key = lStr.nextToken();
                if (lStr.hasMoreTokens()) {
                    String val = lStr.nextToken();
                    famCfgInfo.put(key, val);
                    continue;
                }
                famCfgInfo.put(key, "");
            }
        } else {
            this.pLogger.log(Level.WARNING, "getFAMServerConfig", "Error while getting server configuration.");
        }
        this.pLogger.log(Level.FINEST, "getFAMServerConfig", "Returning FAM configuration Map " + ((Object)famCfgInfo).toString());
        return famCfgInfo;
    }
}

