/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.base;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.config.DSConfigInfo;
import com.sun.identity.tune.intr.TuneDS;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;

public abstract class AMTuneDSBase
extends TuneDS {
    protected AMTuneConfigInfo configInfo;
    protected int curNumberOfWorkerThreads;
    protected int newNumberOfWorkerThreads;
    protected String curAccessLogStatus = null;
    protected String instanceDir = null;
    protected String dsVersion = null;
    protected String dbDirectory = null;
    protected String dbDN = null;
    protected String dbSuffix = null;
    protected String dbEntryCacheSize = null;
    protected long curDBCacheSize;
    protected long newDBCacheSize;
    protected String dbLocation = null;
    protected String curDBHomeLocation = null;
    protected String newDBHomeLocation = null;
    protected MessageWriter mWriter;
    protected AMTuneLogger pLogger;
    protected String dseLdifPath;
    protected String dsPassFilePath;
    protected DSConfigInfo dsConfInfo;
    protected boolean isSM;
    private long memAvail;
    private List dbDirs;
    private boolean init = false;
    private boolean smInit = false;
    private LDAPConnection ldapCon;
    private LDAPConnection smCon;
    private long memNeeded;

    protected AMTuneDSBase(boolean isSM) {
        this.isSM = isSM;
    }

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        try {
            this.configInfo = configInfo;
            this.dsConfInfo = !this.isSM ? configInfo.getDSConfigInfo() : configInfo.getSMConfigInfo();
            if (!this.init) {
                this.pLogger = AMTuneLogger.getLoggerInst();
                this.mWriter = MessageWriter.getInstance();
                this.initializeLdapCon();
            }
            if (!configInfo.isUMSMDSSame() && !this.smInit) {
                this.initSMLDAPConnection();
            }
            this.curNumberOfWorkerThreads = Integer.parseInt(this.getNumberOfWorkerThreads());
            this.curAccessLogStatus = this.getAccessLogStatus();
            this.curDBCacheSize = Long.parseLong(this.getDBCacheSize());
            this.dbSuffix = this.getBackEnd();
            this.curDBHomeLocation = this.getDBHomeLocation();
            this.dbDirectory = this.getDBDirectory();
            this.dsPassFilePath = AMTuneUtil.TMP_DIR + "dspassfile";
            this.instanceDir = this.dsConfInfo.getDsInstanceDir();
            this.dseLdifPath = this.instanceDir + "/" + "config" + "/" + "dse.ldif";
            this.writePasswordToFile();
        }
        catch (Exception ex) {
            if (this.pLogger != null) {
                this.pLogger.log(Level.SEVERE, "initialize", "Error initialising Directory Server Base.");
            }
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void deletePasswordFile() {
        File passFile = new File(this.dsPassFilePath);
        passFile.delete();
    }

    protected void writePasswordToFile() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "writePasswordToFile", "Creating DS password file.");
            File passFile = new File(this.dsPassFilePath);
            BufferedWriter pOut = new BufferedWriter(new FileWriter(passFile));
            pOut.write(this.dsConfInfo.getDsDirMgrPassword());
            pOut.flush();
            pOut.close();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "writePassWordToFile", "Couldn't write password to file. ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private void initializeLdapCon() throws AMTuneException {
        try {
            if (!this.init) {
                this.pLogger.log(Level.FINE, "initializeLdapCon", "Initializing LDAP Connection.");
                this.ldapCon = new LDAPConnection();
                this.ldapCon.connect(3, this.dsConfInfo.getDsHost(), Integer.parseInt(this.dsConfInfo.getDsPort()), this.dsConfInfo.getDirMgrUid(), this.dsConfInfo.getDsDirMgrPassword());
                this.init = true;
            }
        }
        catch (LDAPException ex) {
            this.pLogger.logException("initializeLdapCon", ex);
            this.init = false;
            throw new AMTuneException(ex.getMessage());
        }
    }

    private void initSMLDAPConnection() throws AMTuneException {
        try {
            if (!this.smInit) {
                this.pLogger.log(Level.FINE, "initSMLDAPConnection", "Initializing LDAP Connection to SM DS.");
                this.smCon = new LDAPConnection();
                DSConfigInfo smInfo = this.configInfo.getSMConfigInfo();
                this.smCon.connect(3, smInfo.getDsHost(), Integer.parseInt(smInfo.getDsPort()), smInfo.getDirMgrUid(), smInfo.getDsDirMgrPassword());
                this.smInit = true;
            }
        }
        catch (LDAPException ex) {
            this.pLogger.logException("initSMLDAPConnection", ex);
            this.smInit = false;
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected String searchLDAPAttrVal(String base, String filter, String attr) throws AMTuneException {
        return this.searchLDAPAttrVal(base, 2, filter, attr);
    }

    protected String searchLDAPAttrVal(String base, int scope, String filter, String attr) throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "searchLDAPAttrVal", "Searching for  attribute: " + attr);
            String[] ldapAttr = new String[]{attr};
            LDAPSearchResults myResults = this.ldapCon.search(base, scope, filter, ldapAttr, false);
            while (myResults.hasMoreElements()) {
                LDAPEntry myEntry = myResults.next();
                if (attr.equals("dn")) {
                    return myEntry.getDN().replace("dn:", "").trim();
                }
                LDAPAttributeSet entryAttrs = myEntry.getAttributeSet();
                Enumeration attrsInSet = entryAttrs.getAttributes();
                while (attrsInSet.hasMoreElements()) {
                    LDAPAttribute nextAttr = (LDAPAttribute)attrsInSet.nextElement();
                    Enumeration valsInAttr = nextAttr.getStringValues();
                    if (!valsInAttr.hasMoreElements()) continue;
                    String attrVal = (String)valsInAttr.nextElement();
                    return attrVal;
                }
            }
        }
        catch (Exception lex) {
            this.pLogger.log(Level.SEVERE, "searchLDAPAttrVal", "Error getting ldap attribute value " + attr + "from base " + base);
            throw new AMTuneException(lex.getMessage());
        }
        return null;
    }

    protected List getIndexForDB(String dName) throws AMTuneException {
        ArrayList<String> iList = new ArrayList<String>();
        try {
            this.pLogger.log(Level.FINE, "getIndexForDB", "Get index for DB " + dName);
            String[] attr = new String[]{"dn"};
            LDAPSearchResults idxList = this.ldapCon.search("cn=index,cn=" + dName + "," + "cn=ldbm database,cn=plugins,cn=config", 2, "(objectclass=*)", attr, false);
            while (idxList.hasMoreElements()) {
                LDAPEntry myEntry = idxList.next();
                String dn = myEntry.getDN();
                StringTokenizer firstCol = new StringTokenizer(dn, ",");
                String firstCn = firstCol.nextToken().replace("cn=", "");
                iList.add(firstCn);
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "getIndexForDB", "Error finding index for " + dName);
            throw new AMTuneException(ex.getMessage());
        }
        this.pLogger.log(Level.FINEST, "getIndexForDB", "Existing index for " + dName + " is " + ((Object)iList).toString());
        return iList;
    }

    private String getNumberOfWorkerThreads() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getNumberOfWorkerThreads", "Getting number of worker threads.");
        String val = this.searchLDAPAttrVal("cn=config", 0, "(objectclass=*)", "nsslapd-threadnumber");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getNumberOfWorkerThreads", "Number of worker thread is null");
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-no-worker-threads-msg");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Null DS worker threads");
        }
        this.pLogger.log(Level.FINEST, "getNumberOfWorkerThreads", "Returning value " + val);
        return val;
    }

    private String getAccessLogStatus() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getAccessLogStatus", "Getting access log status.");
        String val = this.searchLDAPAttrVal("cn=config", 0, "(objectclass=*)", "nsslapd-accesslog-logging-enabled");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getAccessLogStatus", "Access log Status is null");
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-access-log-status");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Access log Status is null");
        }
        this.pLogger.log(Level.FINE, "getAccessLogStatus", "Returning value. " + val);
        return val;
    }

    private String getDBDirectory() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBDirectory", "Getting DB Directory.");
        String val = this.searchLDAPAttrVal("cn=config", "(nsslapd-suffix=" + this.dsConfInfo.getRootSuffix() + ")", "nsslapd-directory");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getDBDirectory", "Directory Server DB directory null");
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-directory");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Invalid DB directory.");
        }
        this.pLogger.log(Level.FINEST, "getDBDirectory", "Returning value " + val);
        return val;
    }

    protected String getDBDN() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBDN", "Getting DB DN.");
        String val = this.searchLDAPAttrVal("cn=config", "(nsslapd-suffix=" + this.dsConfInfo.getRootSuffix() + ")", "dn");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getDBDN", "Null DBDN");
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-dn-msg");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Null DBDN.");
        }
        this.pLogger.log(Level.FINEST, "getDBDN", "Returning DB DN. " + val);
        return val;
    }

    protected String getDBDNbyBackend(String backEnd) throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBDNbyBackend", "Get DBDN by Back end " + backEnd);
        String val = this.searchLDAPAttrVal("cn=config", "(&(nsslapd-suffix=*" + this.dsConfInfo.getRootSuffix() + ")(cn=" + backEnd + "))", "dn");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getDBDNbyBackend", "Null DBDN for " + backEnd);
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writeln("DB DN value for " + backEnd);
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Null DBDN for " + backEnd);
        }
        this.pLogger.log(Level.FINEST, "getDBDNbyBackend", "Returning value " + val);
        return val;
    }

    private String getBackEnd() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getBackEnd", "Get Back end name.");
        String val = this.searchLDAPAttrVal("cn=mapping tree,cn=config", "(&(|(cn=" + this.dsConfInfo.getRootSuffix() + ")(cn=\"" + this.dsConfInfo.getRootSuffix() + "\")(" + "nsslapd-parent-suffix" + "=" + this.dsConfInfo.getRootSuffix() + "))(" + "nsslapd-backend" + "=*))", "nsslapd-backend").replaceFirst("NetscapeRoot", "");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getBackEnd", "Null Back End");
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-backend-db");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Null Back End");
        }
        this.pLogger.log(Level.FINEST, "getBackEnd", "Returning value " + val);
        return val;
    }

    protected String getDBEntryCacheSizebyBackend(String backEnd) throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBEntryCacheSizebyBackend", "Get DB entry cache size by back end " + backEnd);
        String val = this.searchLDAPAttrVal("cn=config", "(&(nsslapd-suffix=*" + this.dsConfInfo.getRootSuffix() + ")(cn=" + backEnd + "))", "nsslapd-cachememsize");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getDBEntryCacheSizebyBackend", "Null DB Entry cache size for back end " + backEnd);
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writeLocaleMsg("pt-entry-size-msg");
            this.mWriter.writeln(backEnd);
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Null DB Entry cache size for back end " + backEnd);
        }
        this.pLogger.log(Level.FINEST, "getDBEntryCacheSizebyBackend", "Returning value " + val);
        return val;
    }

    private String getSuffixbyBackend(String backEnd) throws AMTuneException {
        this.pLogger.log(Level.FINE, "getSuffixbyBackend", "Get Suffix by back end" + backEnd);
        String val = this.searchLDAPAttrVal("cn=config", "(cn=" + backEnd + ")", "nsslapd-suffix");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getSuffixbyBackend", "Null suffix for back end " + backEnd);
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writeLocaleMsg("pt-back-end-suffix-msg");
            this.mWriter.writeln(backEnd);
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Null suffix for back end " + backEnd);
        }
        this.pLogger.log(Level.FINEST, "getSuffixbyBackend", "Returning value " + val);
        return val;
    }

    private String getDBCacheSize() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBCacheSize", "Get DB cache size.");
        String val = this.searchLDAPAttrVal("cn=config,cn=ldbm database,cn=plugins,cn=config", 0, "(objectclass=*)", "nsslapd-dbcachesize");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getDBCacheSize", "Null DB cache size ");
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-size-msg");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Null DB cache size ");
        }
        this.pLogger.log(Level.FINEST, "getDBCacheSize", "Returning value " + val);
        return val;
    }

    private String getDBHomeLocation() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBHomeLocation", "Get DB Home location");
        String val = this.searchLDAPAttrVal("cn=config,cn=ldbm database,cn=plugins,cn=config", 0, "(objectclass=*)", "nsslapd-db-home-directory");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getDBHomeLocation", "Null DB Home Location ");
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-home-location");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Null DB Home Location ");
        }
        this.pLogger.log(Level.FINEST, "getDBHomeLocation", "Getting DB Home location.");
        return val;
    }

    protected String getDBName() throws AMTuneException {
        this.pLogger.log(Level.FINE, "getDBName", "Get DB Name.");
        String val = this.searchLDAPAttrVal("cn=config", 2, "(&(|(cn=" + this.dsConfInfo.getRootSuffix() + ")(cn=\"" + this.dsConfInfo.getRootSuffix() + "\"))(" + "nsslapd-backend" + "=*))", "nsslapd-backend");
        if (val == null || val != null && val.length() <= 0) {
            this.pLogger.log(Level.SEVERE, "getDBName", "Null DB Name");
            this.mWriter.writeLocaleMsg("pt-failed-to-obtain-conf");
            this.mWriter.writelnLocaleMsg("pt-db-name-msg");
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            throw new AMTuneException("Null DB Name");
        }
        this.pLogger.log(Level.FINEST, "getDBName", "Returing value. " + val);
        return val;
    }

    protected void releaseCon() {
        try {
            if (this.ldapCon != null && this.init) {
                this.ldapCon.disconnect();
            }
            if (this.smCon != null && this.smInit) {
                this.smCon.disconnect();
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    protected void tuneUsingDSE() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "Tune DSE ldif.");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writeLocaleMsg("pt-tuning");
            this.mWriter.writeln(this.dseLdifPath);
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(this.dseLdifPath);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-db-home-dir");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write("nsslapd-db-home-directory: ");
            this.mWriter.writeln(this.curDBHomeLocation);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.write("nsslapd-db-home-directory: ");
            this.mWriter.writeln(this.newDBHomeLocation);
            this.mWriter.writeln(" ");
            this.mWriter.writeln(" ");
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void ldapTuningRecommendations() throws AMTuneException {
        try {
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-root-suffix-msg");
            this.mWriter.writeln(this.dsConfInfo.getRootSuffix());
            this.mWriter.writelnLocaleMsg("pt-db-db-suffix-msg");
            StringTokenizer st = new StringTokenizer(this.dbSuffix, " ");
            while (st.hasMoreTokens()) {
                this.mWriter.writeln("                                          : " + this.getDBDNbyBackend(st.nextToken()));
            }
            this.mWriter.writeLocaleMsg("pt-db-dir-suffix-msg");
            this.mWriter.writeln(this.dbDirectory);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-ds-worker-threads-msg");
            this.mWriter.writeLocaleMsg("pt-dn-msg");
            this.mWriter.writeln("cn=config");
            this.mWriter.writeLocaleMsg("pt-attribute-msg");
            this.mWriter.writeln("nsslapd-threadnumber");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(Integer.toString(this.curNumberOfWorkerThreads));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(Integer.toString(this.newNumberOfWorkerThreads));
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-access-log-msg");
            this.mWriter.writeLocaleMsg("pt-dn-msg");
            this.mWriter.writeln("cn=config");
            this.mWriter.writeLocaleMsg("pt-attribute-msg");
            this.mWriter.writeln("nsslapd-accesslog-logging-enabled");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(this.curAccessLogStatus);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("on");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-db-cache-size-msg");
            this.mWriter.writeLocaleMsg("pt-dn-msg");
            this.mWriter.writeln("cn=config,cn=ldbm database,cn=plugins,cn=config");
            this.mWriter.writeLocaleMsg("pt-attribute-msg");
            this.mWriter.writeln("nsslapd-dbcachesize");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(Long.toString(this.curDBCacheSize));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(Long.toString(this.newDBCacheSize));
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-db-entry-size-msg");
            this.mWriter.writeln(" ");
            st = new StringTokenizer(this.dbSuffix, " ");
            while (st.hasMoreTokens()) {
                String curToken = st.nextToken();
                String curDbEntryCacheSize = this.getDBEntryCacheSizebyBackend(curToken);
                if (curDbEntryCacheSize == null || curDbEntryCacheSize != null && curDbEntryCacheSize.trim().length() == 0) {
                    this.mWriter.writeLocaleMsg("pt-fail-ds-conf");
                    this.mWriter.writeln("DB Entry Cache Size " + curToken);
                    this.mWriter.writelnLocaleMsg("pt-inval-config");
                    throw new AMTuneException("DB cache entry size is 0");
                }
                long newDBEntryCacheSize = this.suggestDBEntryCacheSizebyBackend(curToken);
                if (newDBEntryCacheSize == 0L) {
                    this.mWriter.writeLocaleMsg("pt-cannot-compute-rec-val");
                    this.mWriter.writeln("DB Cache Size for " + curToken);
                    this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                    throw new AMTuneException("New DB cache entry size is 0.");
                }
                this.mWriter.writeLocaleMsg("pt-suffix-msg");
                this.mWriter.writeln(this.getSuffixbyBackend(curToken));
                this.mWriter.writeLocaleMsg("pt-dn-msg");
                this.mWriter.writeln(this.getDBDNbyBackend(curToken));
                this.mWriter.writeLocaleMsg("pt-attribute-msg");
                this.mWriter.writeln("nsslapd-cachememsize");
                this.mWriter.writeLocaleMsg("pt-cur-val");
                this.mWriter.writeln(curDbEntryCacheSize);
                this.mWriter.writeLocaleMsg("pt-rec-val");
                this.mWriter.writeln(Long.toString(newDBEntryCacheSize));
                this.mWriter.writeln(" ");
                this.mWriter.writeln(" ");
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "ldapTuningRecomendations", "Error computing LDAP Recommendaionts");
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void addLDAPEntry(LDAPEntry newEntry) throws AMTuneException {
        try {
            this.pLogger.log(Level.FINEST, "addLDAPEntry", "Adding entry " + newEntry.toString());
            this.ldapCon.add(newEntry);
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected boolean applyRecommendations() throws AMTuneException {
        boolean status = false;
        try {
            this.pLogger.log(Level.FINE, "applyRecommendations", "Applying recommendations. ");
            if (this.curNumberOfWorkerThreads < this.newNumberOfWorkerThreads) {
                this.mWriter.writeLocaleMsg("pt-modify");
                this.mWriter.writelnLocaleMsg("pt-no-worker-threads-msg");
                LDAPAttribute threadNoAttr = new LDAPAttribute("nsslapd-threadnumber", "24");
                LDAPModification threadNo = new LDAPModification(2, threadNoAttr);
                this.pLogger.log(Level.FINEST, "applyRecommendations", "Modifying worker threads. " + threadNoAttr.toString());
                this.ldapCon.modify("cn=config", threadNo);
                status = true;
            } else {
                this.mWriter.writeLocaleMsg("pt-enough");
                this.mWriter.writelnLocaleMsg("pt-ds-worker-msg");
            }
            if (!this.curAccessLogStatus.equals("on")) {
                this.mWriter.writelnLocaleMsg("pt-modify-access-log-status");
                LDAPAttribute accessLogAttr = new LDAPAttribute("nsslapd-accesslog-logging-enabled", "on");
                LDAPModification accessLogModif = new LDAPModification(2, accessLogAttr);
                this.pLogger.log(Level.FINEST, "applyRecommendations", "Modifying access log status. " + accessLogAttr.toString());
                this.ldapCon.modify("cn=config", accessLogModif);
                status = true;
            } else {
                this.mWriter.writelnLocaleMsg("pt-access-log-on");
            }
            if (this.newDBCacheSize > this.curDBCacheSize) {
                this.mWriter.writeLocaleMsg("pt-modify");
                this.mWriter.writelnLocaleMsg("pt-db-size-msg");
                LDAPAttribute cacheSizeAttr = new LDAPAttribute("nsslapd-dbcachesize", Long.toString(this.newDBCacheSize));
                LDAPModification cachesizeModif = new LDAPModification(2, cacheSizeAttr);
                this.pLogger.log(Level.FINEST, "applyRecommendations", "Modifying db cache size. " + cacheSizeAttr.toString());
                this.ldapCon.modify("cn=config,cn=ldbm database,cn=plugins,cn=config", cachesizeModif);
                status = true;
            } else {
                this.mWriter.writeLocaleMsg("pt-db-size-msg");
                this.mWriter.writelnLocaleMsg("pt-already-enough");
            }
            StringTokenizer st = new StringTokenizer(this.dbSuffix, " ");
            while (st.hasMoreTokens()) {
                String curToken = st.nextToken();
                long curDBEntryCacheSize = Long.parseLong(this.getDBEntryCacheSizebyBackend(curToken));
                long newDBEntryCacheSize = this.suggestDBEntryCacheSizebyBackend(curToken);
                if (newDBEntryCacheSize > curDBEntryCacheSize) {
                    this.mWriter.writeLocaleMsg("pt-modify");
                    this.mWriter.writeln("DB Entry Cache Size for " + curToken);
                    String dn = this.getDBDNbyBackend(curToken);
                    LDAPAttribute cacheMemSizeAttr = new LDAPAttribute("nsslapd-cachememsize", Long.toString(newDBEntryCacheSize));
                    LDAPModification cacheMemSizeMod = new LDAPModification(2, cacheMemSizeAttr);
                    this.pLogger.log(Level.FINEST, "applyRecommendations", "Modifying db cache size. " + cacheMemSizeAttr.toString());
                    this.ldapCon.modify(dn, cacheMemSizeMod);
                    status = true;
                    continue;
                }
                this.mWriter.write("DB Entry Cache Size ");
                this.mWriter.writeLocaleMsg("pt-already-enough");
                this.mWriter.writeln(" for " + curToken);
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "applyRecommendations", ex.getMessage());
            throw new AMTuneException(ex.getMessage());
        }
        return status;
    }

    protected List getFAMSearchAttrs() throws AMTuneException {
        ArrayList<String> attrList = new ArrayList<String>();
        try {
            this.pLogger.log(Level.FINE, "getFAMSearchAttrs", "Getting FAM search attributes.");
            String[] sunKeyAttr = new String[]{"sunkeyvalue"};
            String searchAttr = "iplanet-am-auth-ldap-user-search-attributes";
            LDAPConnection dsCon = null;
            String rootSuffix = null;
            if (!this.configInfo.isUMSMDSSame()) {
                dsCon = this.smCon;
                rootSuffix = this.configInfo.getSMConfigInfo().getRootSuffix();
            } else {
                dsCon = this.ldapCon;
                rootSuffix = this.configInfo.getDSConfigInfo().getRootSuffix();
            }
            LDAPSearchResults myResults = dsCon.search("ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthLDAPService,ou=services," + rootSuffix, 2, "(objectclass=*)", sunKeyAttr, false);
            while (myResults.hasMoreElements()) {
                LDAPEntry myEntry = myResults.next();
                LDAPAttributeSet entryAttrs = myEntry.getAttributeSet();
                Enumeration attrsInSet = entryAttrs.getAttributes();
                while (attrsInSet.hasMoreElements()) {
                    LDAPAttribute nextAttr = (LDAPAttribute)attrsInSet.nextElement();
                    Enumeration attrVals = nextAttr.getStringValues();
                    while (attrVals.hasMoreElements()) {
                        String reqVal = (String)attrVals.nextElement();
                        if (reqVal.indexOf(searchAttr) == -1) continue;
                        StringTokenizer st = new StringTokenizer(reqVal, "=");
                        String vals = null;
                        while (st.hasMoreTokens()) {
                            vals = st.nextToken();
                        }
                        if (vals == null) continue;
                        attrList.add(vals);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.FINER, "getFAMSearchAttrs", "Error getting FAM Search Attributes.");
            throw new AMTuneException(ex.getMessage());
        }
        if (attrList.size() == 0) {
            this.pLogger.log(Level.FINER, "getFAMSearchAttrs", "No values found in ou=default,ou=OrganizationConfig,ou=1.0,ou=iPlanetAMAuthLDAPService,ou=services, using default.");
            attrList.add("uid");
        }
        this.pLogger.log(Level.FINER, "getFAMSearchAttrs", "Returning FAM search attributes. " + attrList.toString());
        return attrList;
    }

    protected List verifyIndex(List amSearchAttributes, List existingIndex) throws AMTuneException {
        ArrayList<String> notInIndexList = new ArrayList<String>();
        try {
            this.pLogger.log(Level.FINE, "verifyIndex", "AM Search Attribute " + amSearchAttributes.toString());
            this.pLogger.log(Level.FINE, "verifyIndex", "Existing Index " + existingIndex.toString());
            this.mWriter.writelnLocaleMsg("pt-index-exist");
            this.mWriter.writeln("-------------        ----------");
            Iterator searchAttrItr = amSearchAttributes.iterator();
            while (searchAttrItr.hasNext()) {
                String extAt = null;
                String amAttr = (String)searchAttrItr.next();
                Iterator extItr = existingIndex.iterator();
                boolean exist = false;
                while (extItr.hasNext()) {
                    extAt = (String)extItr.next();
                    if (!extAt.equalsIgnoreCase(amAttr)) continue;
                    exist = true;
                    this.mWriter.writeln("Yes              " + amAttr);
                }
                if (exist) continue;
                this.mWriter.writeln("No               " + amAttr);
                notInIndexList.add(amAttr);
            }
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
        this.pLogger.log(Level.FINE, "verifyIndex", "Attributes to be indexed " + notInIndexList.toString());
        return notInIndexList;
    }

    private List mergeLists(List list1, List list2) {
        Iterator itr2 = list2.iterator();
        while (itr2.hasNext()) {
            String attr = (String)itr2.next();
            boolean found = false;
            Iterator itr1 = list1.iterator();
            while (itr1.hasNext()) {
                String curAttr = itr1.next().toString();
                if (!curAttr.equalsIgnoreCase(attr)) continue;
                found = true;
            }
            if (found) continue;
            list1.add(attr);
        }
        return list1;
    }

    protected List tuneDSIndex(List existingIndex) throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "tuneDSIndex", "Tuning DS index.");
            List amSearchAttrList = this.getFAMSearchAttrs();
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-tuning-ds-idx");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-root-suffix-msg");
            this.mWriter.writeln(this.dsConfInfo.getRootSuffix());
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-auth-attr-msg");
            this.mWriter.writelnLocaleMsg("pt-recommend-idx-msg");
            this.mWriter.write(" ");
            this.pLogger.log(Level.FINE, "tuneDSIndex", "Verifying amsearch attributes in existing index attributes list.");
            List notInSearchIndex = this.verifyIndex(amSearchAttrList, existingIndex);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-verify-fam-index-list");
            this.mWriter.writeln(" ");
            List defaultList = this.getListDefaultFAMIndexes();
            this.pLogger.log(Level.FINE, "tuneDSIndex", "Verifying default attributes in existing index attributes list.");
            List notInDefaultIdx = this.verifyIndex(defaultList, existingIndex);
            this.mWriter.writeln(" ");
            return this.mergeLists(notInSearchIndex, notInDefaultIdx);
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "tuneDSIndex", "Error tuning Index.");
            new AMTuneException(ex.getMessage());
            return null;
        }
    }

    protected void tuneFuture() {
        this.pLogger.log(Level.FINE, "tuneFuture", "Tuning future.");
        this.mWriter.writeln("---------------------------------------------------------------------");
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-future-tuning-msg1");
        this.mWriter.writelnLocaleMsg("pt-future-tuning-msg2");
        this.mWriter.writelnLocaleMsg("pt-future-tuning-msg3");
        this.mWriter.write("1. ");
        this.mWriter.writeLocaleMsg("pt-future-tuning-msg4");
        this.mWriter.writeln("dn: db_dn");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-a");
        this.mWriter.writeln("nsslapd-sizelimit");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-b");
        this.mWriter.writeln("nsslapd-timelimit");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-c");
        this.mWriter.writeln("nsslapd-lookthroughlimit");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-d");
        this.mWriter.writeln("nsslapd-require-index");
        this.mWriter.writeln(" ");
        this.mWriter.write("2. ");
        this.mWriter.writeLocaleMsg("pt-future-tuning-msg4");
        this.mWriter.writeln("dn: cn=config,cn=ldbm database,cn=plugins,cn=config");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-a");
        this.mWriter.writeln("nsslapd-db-transaction-batch-val");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-b");
        this.mWriter.writeln("nsslapd-db-logbuf-size");
        this.mWriter.writeln(" ");
        this.mWriter.write("3. ");
        this.mWriter.writeLocaleMsg("pt-future-tuning-msg4");
        this.mWriter.writeln("dn: cn=referential integrity postoperation,cn=plugins,cn=config");
        this.mWriter.write("    ");
        this.mWriter.writeLocaleMsg("pt-a");
        this.mWriter.writeln("nsslapd-pluginarg0");
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-split-comp-msg");
        this.mWriter.writelnLocaleMsg("pt-database-trans-logs-msg");
        this.mWriter.writelnLocaleMsg("pt-isolate-msg");
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-delegated-admin-msg1");
        this.mWriter.writelnLocaleMsg("pt-delegated-admin-msg2");
        this.mWriter.writeln(" ");
    }

    protected void computeTuneValues() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "computeTuneValues", "Compute Tuning values for DS.");
            this.memAvail = Long.parseLong(AMTuneUtil.getSystemMemory());
            this.memAvail = this.memAvail * 1024L * 1024L;
            this.mWriter.writelnLocaleMsg("pt-calc-ds-mem");
            this.dbDirs = this.availableDBDirs();
            if (this.dbDirs.size() == 0) {
                this.mWriter.writeLocaleMsg("pt-error-loc-db-dir");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Error finding database directory");
            }
            this.newDBCacheSize = this.calculateDBCacheSize();
            if (this.newDBCacheSize == 0L) {
                this.mWriter.writeLocaleMsg("pt-error-compute-db-size=");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Error computing DB cache size.");
            }
            this.memNeeded = this.newDBCacheSize + this.calculateTotalNewEntryDBCacheSize();
            if (this.memNeeded == 0L) {
                this.mWriter.writeLocaleMsg("pt-unable-mem-req");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Error computing required memory.");
            }
            this.mWriter.writeLocaleMsg("pt-avail-mem-size");
            this.mWriter.writeln(Long.toString(this.memAvail));
            this.mWriter.writeLocaleMsg("pt-mem-need-ds-cache");
            this.mWriter.writeln(Long.toString(this.memNeeded));
            if (this.memNeeded > this.memAvail) {
                this.mWriter.writelnLocaleMsg("pt-no-enough-mem");
                throw new AMTuneException("No enought memory.");
            }
            this.mWriter.writelnLocaleMsg("pt-enough-mem");
            String dbDirName = new File(this.instanceDir).getName();
            this.newDBHomeLocation = AMTuneUtil.TMP_DIR + dbDirName;
            File newDBHome = new File(this.newDBHomeLocation);
            boolean createStat = true;
            if (!newDBHome.isDirectory()) {
                createStat = newDBHome.mkdir();
            }
            if (!createStat) {
                this.mWriter.writeLocaleMsg("pt-cannot-new-db-home");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Error creating new DB Home.");
            }
            this.newNumberOfWorkerThreads = Integer.parseInt("24");
            if (this.newNumberOfWorkerThreads == 0) {
                this.mWriter.writeLocaleMsg("pt-cannot-new-ds-threads");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Error computing new DS worker threads");
            }
            File checkPassFile = new File(this.dsPassFilePath);
            if (!checkPassFile.isFile()) {
                this.mWriter.writeLocaleMsg("pt-error-ds-pass-file");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("DS Password file not found.");
            }
        }
        catch (NumberFormatException ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    private long suggestDBEntryCacheSizebyBackend(String backEnd) {
        String dbDir = this.instanceDir + "/" + "db" + "/" + backEnd;
        long dbSize = (long)((double)AMTuneUtil.getDirSize(dbDir) * 1.2) / 1L;
        return dbSize;
    }

    private long calculateTotalNewEntryDBCacheSize() throws AMTuneException {
        this.pLogger.log(Level.FINE, "calculateTotalNewEntryDBCacheSize", "Caliculating total new entry db cache size.");
        StringTokenizer suffixTokens = new StringTokenizer(this.dbSuffix, " ");
        long totalVal = 0L;
        while (suffixTokens.hasMoreTokens()) {
            String curSuffix = suffixTokens.nextToken();
            long sugVal = this.suggestDBEntryCacheSizebyBackend(curSuffix);
            if (sugVal == 0L) {
                this.mWriter.writelnLocaleMsg("pt-cannot-compute-rec-db-size");
                this.mWriter.write(curSuffix + " ");
                this.mWriter.writeLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Error computing recommended db cache size.");
            }
            totalVal += sugVal;
        }
        this.pLogger.log(Level.FINE, "calculateTotalNewEntryDBCacheSize", "Returning total size ." + totalVal);
        return totalVal;
    }

    private long calculateDBCacheSize() {
        this.pLogger.log(Level.FINE, "calculateDBCacheSize", "Caliculate DB cache size.");
        List l = this.dbDirs;
        long size = 0L;
        for (int i = 0; i < l.size(); ++i) {
            size += AMTuneUtil.getDirSize((String)l.get(i));
        }
        size = (long)((double)size * 1.2) / 1L;
        this.pLogger.log(Level.FINE, "calculateDBCacheSize", "Returning size " + size);
        return size;
    }

    private List availableDBDirs() {
        this.pLogger.log(Level.FINE, "availableDBDirs", "Getting DB dirs. ");
        File iDir = new File(this.instanceDir + "/" + "db");
        String[] list = iDir.list();
        ArrayList<String> dirList = new ArrayList<String>();
        int arrLen = 0;
        for (int i = 0; i < list.length; ++i) {
            File curFile = new File(iDir.getAbsolutePath() + "/" + list[i]);
            if (!curFile.isDirectory()) continue;
            dirList.add(arrLen++, curFile.getAbsolutePath());
        }
        this.pLogger.log(Level.FINEST, "availableDBDirs", "Available DB dirs are " + dirList.toString());
        return dirList;
    }

    protected List getListDefaultFAMIndexes() throws AMTuneException {
        ArrayList<String> dIndex = new ArrayList<String>();
        try {
            String idxFile = this.configInfo.getFAMConfigDir() + "/" + "index.ldif";
            File idxFh = new File(idxFile);
            if (!idxFh.isFile()) {
                this.pLogger.log(Level.SEVERE, "getListDefaultFAMIndexes", "Couldn't find file " + idxFile);
            } else {
                FileHandler fh = new FileHandler(idxFile);
                String[] matLines = fh.getMattchingLines("dn:", false);
                for (int i = 0; i < matLines.length; ++i) {
                    String dn = matLines[i].substring(matLines[i].indexOf(" ") + 1, matLines[i].indexOf(","));
                    String idxattr = AMTuneUtil.getLastToken(dn, "=");
                    dIndex.add(idxattr.trim());
                }
            }
            String sdsIdxFile = this.configInfo.getFAMConfigDir() + "/" + "fam_sds_index.ldif";
            File sdsIdxFh = new File(sdsIdxFile);
            if (!sdsIdxFh.isFile()) {
                this.pLogger.log(Level.SEVERE, "getListDefaultFAMIndexes", "Couldn't find file " + sdsIdxFile);
            } else {
                FileHandler fh = new FileHandler(sdsIdxFile);
                String[] matLines = fh.getMattchingLines("dn:", false);
                for (int i = 0; i < matLines.length; ++i) {
                    String dn = matLines[i].substring(matLines[i].indexOf(" ") + 1, matLines[i].indexOf(","));
                    String idxattr = AMTuneUtil.getLastToken(dn, "=");
                    dIndex.add(idxattr.trim());
                }
            }
            if (dIndex.isEmpty()) {
                dIndex.add("nsroledn");
                dIndex.add("memberof");
                dIndex.add("iplanet-am-static-group-dn");
                dIndex.add("iplanet-am-modifiable-by");
                dIndex.add("sunxmlkeyvalue");
                dIndex.add("o");
                dIndex.add("ou");
                dIndex.add("sunPreferredDomain");
                dIndex.add("associatedDomain");
                dIndex.add("sunOrganizationAlias");
                dIndex.add("iplanet-am-user-federation-info-key");
                dIndex.add("sun-fm-saml2-nameid-infokey");
                this.pLogger.log(Level.INFO, "getListDefaultFAMIndexes", "Using default index: " + ((Object)dIndex).toString());
            }
        }
        catch (Exception ex) {
            throw new AMTuneException("Error getting default FAM indexes : " + ex.getMessage());
        }
        return dIndex;
    }
}

