/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.nightly;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;

public class NightlyIndexHtml {
    private static final String TEMPLATE = "\n&raquo;&nbsp;<a href=\"{0}\">{0}</a><br />";
    private static final String NEW_ENTRY = "<!-- new entry -->";
    private static final String LATEST = "<a href=\"{0}\">latest</a>";

    private NightlyIndexHtml() {
    }

    private static void create(String baseDir, String timestamp, String indexURL) throws IOException, MalformedURLException {
        URL url = new URL(indexURL);
        URLConnection conn = url.openConnection();
        DataInputStream dis = new DataInputStream(conn.getInputStream());
        StringBuffer buff = new StringBuffer();
        String line = dis.readLine();
        while (line != null) {
            buff.append(line).append("\n");
            line = dis.readLine();
        }
        dis.close();
        String content = buff.toString();
        Object[] param = new Object[]{timestamp};
        content = content.replaceAll(NEW_ENTRY, NEW_ENTRY + MessageFormat.format(TEMPLATE, param));
        content = content.replaceAll("<a href=.+?>latest</a>", MessageFormat.format(LATEST, param));
        NightlyIndexHtml.writeToFile(baseDir + "/top.index.html", content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String filename, String content) throws IOException {
        if (filename != null) {
            File fileHandle = new File(filename);
            FileWriter out = null;
            try {
                out = new FileWriter(filename);
                out.write(content);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            NightlyIndexHtml.create(args[0], args[1], args[2]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

