/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.DataLayer;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSObjectDB;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.ldap.LDAPEventManager;
import com.sun.identity.sm.ldap.SMDataLayer;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCompareAttrNames;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class SMSLdapObject
extends SMSObjectDB
implements SMSObjectListener {
    static DataLayer dlayer;
    static SMDataLayer smdlayer;
    static int connNumRetry;
    static int connRetryInterval;
    static HashSet retryErrorCodes;
    static Set entriesPresent;
    static Set entriesNotPresent;
    static ResourceBundle bundle;
    boolean initialized;
    static boolean initializedForNotification;
    static Debug debug;
    static String[] OU_ATTR;
    static String[] O_ATTR;
    static boolean enableProxy;

    public SMSLdapObject() throws SMSException {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private synchronized void initialize() throws SMSException {
        if (this.initialized) {
            return;
        }
        SMDataLayer.reset();
        debug = Debug.getInstance((String)"amSMSLdap");
        AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
        bundle = amCache.getResBundle("amSDK", Locale.ENGLISH);
        SMSLdapObject.OU_ATTR[0] = this.getNamingAttribute();
        SMSLdapObject.O_ATTR[0] = this.getOrgNamingAttribute();
        String enableP = SystemProperties.get("com.sun.identity.sm.ldap.enableProxy");
        boolean bl = enableProxy = enableP != null && enableP.equalsIgnoreCase("true");
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: proxy enable value: " + enableProxy);
        }
        try {
            if (enableProxy) {
                dlayer = DataLayer.getInstance();
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: DataLayer instance obtained.");
                }
            } else {
                smdlayer = SMDataLayer.getInstance();
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: SMDataLayer instance obtained.");
                }
            }
            if (dlayer == null && smdlayer == null) {
                debug.error("SMSLdapObject: Unable to initialize LDAP");
                throw new SMSException("amSDK", "ums-configmanagererror", null);
            }
            debug.message("SMSLdapObject: LDAP Initialized successfully");
            connNumRetry = DataLayer.getConnNumRetry();
            connRetryInterval = DataLayer.getConnRetryInterval();
            retryErrorCodes = DataLayer.getRetryErrorCodes();
            String serviceDN = "ou=services," + this.getRootSuffix();
            if (!SMSLdapObject.entryExists(serviceDN)) {
                HashMap attrs = new HashMap();
                HashSet<String> attrValues = new HashSet<String>();
                attrValues.add("top");
                attrValues.add("organizationalunit");
                attrs.put("objectclass", attrValues);
                SMSLdapObject.create(LDAPEventManager.adminPrincipal, serviceDN, attrs);
            }
        }
        catch (Exception e) {
            debug.error("SMSEntry: Unable to initalize(exception):", (Throwable)e);
            throw new SMSException("amSDK", "ums-configmanagererror", null);
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map read(SSOToken token, String dn) throws SMSException, SSOException {
        LDAPAttributeSet attrSet;
        block27: {
            if (dn == null || dn.length() == 0) {
                debug.error("SMSLdapObject: read():Null or Empty DN=" + dn);
                throw new SMSException(new LDAPException(bundle.getString("sms-INVALID_DN") + dn, 32), "sms-NO_SUCH_OBJECT");
            }
            if (!DN.isDN((String)dn)) {
                debug.warning("SMSLdapObject: Invalid DN=" + dn);
                Object[] args = new String[]{dn};
                throw new SMSException("amSDK", "sms-INVALID_DN", args);
            }
            if (entriesNotPresent.contains(dn)) {
                if (!initializedForNotification) {
                    SMSEntry.registerCallbackHandler(null, this);
                    initializedForNotification = true;
                }
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject:read Entry not present: " + dn + " (checked in cached)");
                }
                return null;
            }
            attrSet = null;
            LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
            int errorCode = 0;
            try {
                LDAPEntry ldapEntry = null;
                int retry = 0;
                while (retry <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.read() retry: " + retry);
                    }
                    try {
                        ldapEntry = conn.read(this.getNormalizedName(token, dn), this.getAttributeNames());
                        break;
                    }
                    catch (LDAPException e) {
                        errorCode = e.getLDAPResultCode();
                        if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                            throw e;
                        }
                        ++retry;
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
                if (ldapEntry == null) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject: insufficient access rights to access DN=" + dn);
                    }
                    throw new SMSException("amSDK", "sms-INSUFFICIENT_ACCESS_RIGHTS", null);
                }
                attrSet = ldapEntry.getAttributeSet();
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: reading entry: " + dn);
                }
            }
            catch (LDAPException ex) {
                errorCode = ex.getLDAPResultCode();
                if (ex.getLDAPResultCode() == 32) {
                    this.objectChanged(dn, 1);
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject: entry not present:" + dn);
                    }
                    break block27;
                }
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject.read: Error in accessing entry DN: " + dn, (Throwable)ex);
                }
                throw new SMSException(ex, "sms-entry-cannot-access");
            }
            finally {
                SMSLdapObject.releaseConnection(conn, errorCode);
            }
        }
        Map answer = null;
        if (attrSet != null) {
            Enumeration enums = attrSet.getAttributes();
            while (enums.hasMoreElements()) {
                LDAPAttribute attr = (LDAPAttribute)enums.nextElement();
                String attrName = attr.getName();
                if (attr == null) continue;
                HashSet<String> values = new HashSet<String>();
                String[] value = attr.getStringValueArray();
                for (int i = 0; i < value.length; ++i) {
                    values.add(value[i]);
                }
                if (answer == null) {
                    answer = new CaseInsensitiveHashMap(10);
                }
                answer.put(attrName, values);
            }
        }
        return answer;
    }

    public void create(SSOToken token, String dn, Map attrs) throws SMSException, SSOException {
        SMSLdapObject.create(token.getPrincipal(), this.getNormalizedName(token, dn), attrs);
        this.objectChanged(dn, 0);
    }

    private static void create(Principal p, String dn, Map attrs) throws SMSException, SSOException {
        LDAPConnection conn = SMSLdapObject.getConnection(p);
        try {
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject.create() retry: " + retry);
                }
                try {
                    LDAPAttributeSet attrSet = SMSLdapObject.copyMapToAttrSet(attrs);
                    conn.add(new LDAPEntry(dn, attrSet));
                    break;
                }
                catch (LDAPException e) {
                    if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                        throw e;
                    }
                    ++retry;
                    try {
                        Thread.sleep(connRetryInterval);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        catch (LDAPException le) {
            debug.error("SMSLdapObject::create() Error in creating entry: " + dn + "\nBy Principal: " + p.getName(), (Throwable)le);
            throw new SMSException(le, "sms-entry-cannot-create");
        }
        finally {
            SMSLdapObject.releaseConnection(conn);
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: Successfully created entry: " + dn);
        }
    }

    public void modify(SSOToken token, String dn, ModificationItem[] mods) throws SMSException, SSOException {
        LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
        try {
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject.modify() retry: " + retry);
                }
                try {
                    LDAPModificationSet modSet = SMSLdapObject.copyModItemsToLDAPModSet(mods);
                    conn.modify(this.getNormalizedName(token, dn), modSet);
                    break;
                }
                catch (LDAPException e) {
                    if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                        throw e;
                    }
                    ++retry;
                    try {
                        Thread.sleep(connRetryInterval);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        catch (LDAPException le) {
            debug.error("SMSLdapObject::modify() Error in modifying entry: " + dn + "\nBy Principal: " + token.getPrincipal().getName(), (Throwable)le);
            throw new SMSException(le, "sms-entry-cannot-modify");
        }
        finally {
            SMSLdapObject.releaseConnection(conn);
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: Successfully modified entry: " + dn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SSOToken token, String dn) throws SMSException, SSOException {
        Iterator se = this.subEntries(token, dn, "*", 0, false, false).iterator();
        while (se.hasNext()) {
            String entry = (String)se.next();
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: deleting sub-entry: " + entry);
            }
            this.delete(token, this.getNamingAttribute() + "=" + entry + "," + dn);
        }
        Set subOrgNames = this.searchSubOrgNames(token, dn, "*", 0, false, false, false);
        Iterator so = subOrgNames.iterator();
        while (so.hasNext()) {
            String subOrg = (String)so.next();
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: deleting suborganization: " + subOrg);
            }
            this.delete(token, this.getNormalizedName(token, subOrg));
        }
        LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
        try {
            SMSLdapObject.delete(conn, this.getNormalizedName(token, dn));
        }
        finally {
            SMSLdapObject.releaseConnection(conn);
        }
        this.objectChanged(dn, 1);
    }

    private static void delete(LDAPConnection conn, String dn) throws SMSException {
        try {
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject.delete() retry: " + retry);
                }
                try {
                    conn.delete(dn);
                    break;
                }
                catch (LDAPException e) {
                    if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                        throw e;
                    }
                    ++retry;
                    try {
                        Thread.sleep(connRetryInterval);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        catch (LDAPException le) {
            if (debug.warningEnabled()) {
                debug.warning("SMSLdapObject:delete() Unable to delete entry:" + dn, (Throwable)le);
            }
            throw new SMSException(le, "sms-entry-cannot-delete");
        }
    }

    public Set subEntries(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: SubEntries search: " + dn);
        }
        String[] objs = new String[]{filter};
        String sfilter = MessageFormat.format(this.getSearchFilter(), objs);
        Set answer = this.getSubEntries(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getSubEntries(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        LDAPSearchResults results;
        block21: {
            LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            constraints.setMaxResults(numOfEntries);
            constraints.setServerTimeLimit(0);
            results = null;
            try {
                int retry = 0;
                while (retry <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.subEntries() retry: " + retry);
                    }
                    try {
                        results = conn.search(this.getNormalizedName(token, dn), 1, filter, OU_ATTR, false, constraints);
                        if (sortResults) {
                            LDAPCompareAttrNames comparator = new LDAPCompareAttrNames(this.getNamingAttribute(), ascendingOrder);
                            results.sort((LDAPEntryComparator)comparator);
                        }
                        break;
                    }
                    catch (LDAPException e) {
                        if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                            throw e;
                        }
                        ++retry;
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
            }
            catch (LDAPException le) {
                if (le.getLDAPResultCode() == 32) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject: entry not present:" + dn);
                    }
                    break block21;
                }
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Unable to search for sub-entries: " + dn, (Throwable)le);
                }
                throw new SMSException(le, "sms-entry-cannot-search");
            }
            finally {
                SMSLdapObject.releaseConnection(conn);
            }
        }
        OrderedSet answer = new OrderedSet();
        while (results != null && results.hasMoreElements()) {
            LDAPEntry entry;
            try {
                entry = results.next();
            }
            catch (LDAPException ldape) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in obtaining sub-entries: " + dn, (Throwable)ldape);
                }
                throw new SMSException(ldape, "sms-entry-cannot-obtain");
            }
            String temp = LDAPDN.explodeDN((String)entry.getDN(), (boolean)true)[0];
            answer.add(this.getDenormalizedName(token, temp));
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: Successfully obtained sub-entries for : " + dn);
        }
        return answer;
    }

    public Set schemaSubEntries(SSOToken token, String dn, String filter, String sidFilter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: schemaSubEntries search: " + dn);
        }
        String[] objs = new String[]{filter, sidFilter};
        String sfilter = MessageFormat.format(this.getServiceIdSearchFilter(), objs);
        Set answer = this.getSubEntries(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder);
        return answer;
    }

    public String toString() {
        return "SMSLdapObject";
    }

    private static void releaseConnection(LDAPConnection conn) {
        if (conn != null) {
            if (enableProxy) {
                dlayer.releaseConnection(conn);
            } else {
                smdlayer.releaseConnection(conn);
            }
        }
    }

    private static void releaseConnection(LDAPConnection conn, int errorCode) {
        if (conn != null) {
            if (enableProxy) {
                dlayer.releaseConnection(conn, errorCode);
            } else {
                smdlayer.releaseConnection(conn, errorCode);
            }
        }
    }

    private static LDAPConnection getConnection(Principal p) throws SMSException {
        LDAPConnection conn = null;
        conn = enableProxy ? dlayer.getConnection(p) : smdlayer.getConnection();
        if (conn == null) {
            debug.error("SMSLdapObject: Unable to get connection to LDAP server for the principal: " + p);
            throw new SMSException(new LDAPException(bundle.getString("sms-SERVER_DOWN")), "sms-SERVER_DOWN");
        }
        return conn;
    }

    public Set search(SSOToken token, String startDN, String filter) throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: search filter: " + filter);
        }
        LDAPConnection conn = SMSLdapObject.getConnection(LDAPEventManager.adminPrincipal);
        LDAPSearchResults results = null;
        OrderedSet answer = new OrderedSet();
        try {
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            constraints.setMaxResults(0);
            constraints.setServerTimeLimit(0);
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject.search() retry: " + retry);
                }
                try {
                    results = conn.search(this.getNormalizedName(token, startDN), 2, filter, null, false, constraints);
                    break;
                }
                catch (LDAPException e) {
                    if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                        throw e;
                    }
                    ++retry;
                    try {
                        Thread.sleep(connRetryInterval);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        catch (LDAPException le) {
            if (debug.warningEnabled()) {
                debug.warning("SMSLdapObject: LDAP exception in search for filter match: " + filter, (Throwable)le);
            }
            throw new SMSException(le, "sms-error-in-searching");
        }
        finally {
            SMSLdapObject.releaseConnection(conn);
        }
        while (results.hasMoreElements()) {
            LDAPEntry entry;
            try {
                entry = results.next();
            }
            catch (LDAPException ldape) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in searching for filter match: " + filter, (Throwable)ldape);
                }
                throw new SMSException(ldape, "sms-error-in-searching");
            }
            answer.add(entry.getDN());
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject::search returned successfully: " + filter + "\n\tObjects: " + answer);
        }
        return answer;
    }

    public boolean entryExists(SSOToken token, String dn) {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: checking if entry exists: " + dn);
        }
        if (entriesPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in cache: " + dn);
            }
            return true;
        }
        if (entriesNotPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in not-present-cache: " + dn);
            }
            return false;
        }
        boolean entryExists = SMSLdapObject.entryExists(this.getNormalizedName(token, dn));
        if (entryExists) {
            HashSet<String> ee = new HashSet<String>(entriesPresent);
            ee.add(dn);
            entriesPresent = ee;
        } else {
            HashSet<String> enp = new HashSet<String>(entriesNotPresent);
            enp.add(dn);
            entriesNotPresent = enp;
        }
        return entryExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean entryExists(String dn) {
        boolean entryExists = false;
        LDAPConnection conn = null;
        try {
            conn = SMSLdapObject.getConnection(LDAPEventManager.adminPrincipal);
            conn.read(dn, OU_ATTR);
            entryExists = true;
        }
        catch (LDAPException e) {
            if (debug.warningEnabled()) {
                debug.warning("SMSLdapObject:entryExists: " + dn + "does not exist");
            }
        }
        catch (SMSException ssoe) {
            if (debug.warningEnabled()) {
                debug.warning("SMSLdapObject: SMSException while  checking for entry: " + dn, (Throwable)ssoe);
            }
        }
        finally {
            SMSLdapObject.releaseConnection(conn);
        }
        return entryExists;
    }

    public String registerCallbackHandler(SSOToken token, SMSObjectListener changeListener) throws SMSException, SSOException {
        return LDAPEventManager.addObjectChangeListener(changeListener);
    }

    public void deregisterCallbackHandler(String id) {
        LDAPEventManager.removeObjectChangeListener(id);
    }

    private static LDAPAttributeSet copyMapToAttrSet(Map attrs) {
        LDAPAttribute[] ldapAttrs = new LDAPAttribute[attrs.size()];
        Iterator items = attrs.keySet().iterator();
        int i = 0;
        while (items.hasNext()) {
            String attrName = (String)items.next();
            Set attrValues = (Set)attrs.get(attrName);
            ldapAttrs[i] = new LDAPAttribute(attrName, attrValues.toArray(new String[attrValues.size()]));
            ++i;
        }
        return new LDAPAttributeSet(ldapAttrs);
    }

    private static LDAPModificationSet copyModItemsToLDAPModSet(ModificationItem[] mods) throws SMSException {
        LDAPModificationSet modSet = new LDAPModificationSet();
        try {
            block7: for (int i = 0; i < mods.length; ++i) {
                Attribute attribute = mods[i].getAttribute();
                LDAPAttribute attr = new LDAPAttribute(attribute.getID());
                NamingEnumeration<?> ne = attribute.getAll();
                while (ne.hasMore()) {
                    attr.addValue((String)ne.next());
                }
                switch (mods[i].getModificationOp()) {
                    case 1: {
                        modSet.add(0, attr);
                        continue block7;
                    }
                    case 2: {
                        modSet.add(2, attr);
                        continue block7;
                    }
                    case 3: {
                        modSet.add(1, attr);
                    }
                }
            }
        }
        catch (NamingException nne) {
            throw new SMSException(nne, "sms-cannot-copy-fromModItemToModSet");
        }
        return modSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectChanged(String dn, int type) {
        dn = new DN(dn).toRFCString().toLowerCase();
        Set set = entriesPresent;
        synchronized (set) {
            if (type == 1) {
                HashSet<String> enp = new HashSet<String>();
                Iterator items = entriesPresent.iterator();
                while (items.hasNext()) {
                    String odn = (String)items.next();
                    if (dn.equals(new DN(odn).toRFCString().toLowerCase())) continue;
                    enp.add(odn);
                }
                entriesPresent = enp;
            } else if (type == 0) {
                HashSet<String> enp = new HashSet<String>();
                Iterator items = entriesNotPresent.iterator();
                while (items.hasNext()) {
                    String odn = (String)items.next();
                    if (dn.equals(new DN(odn).toRFCString().toLowerCase())) continue;
                    enp.add(odn);
                }
                entriesNotPresent = enp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allObjectsChanged() {
        SMSEntry.debug.error("SMSLDAPObject: got notifications, all objects changed");
        Set set = entriesPresent;
        synchronized (set) {
            entriesPresent.clear();
            entriesNotPresent.clear();
        }
    }

    public Set searchSubOrgNames(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject.searchSubOrgNames search: " + dn);
        }
        String[] objs = new String[]{filter};
        String FILTER_PATTERN_ORG = "(&(objectclass=sunRealmService)(o={0}))";
        String sfilter = MessageFormat.format(FILTER_PATTERN_ORG, objs);
        Set answer = this.searchSubOrganizationNames(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder, recursive);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set searchSubOrganizationNames(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        LDAPSearchResults results;
        block22: {
            LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            constraints.setMaxResults(numOfEntries);
            constraints.setServerTimeLimit(0);
            results = null;
            int scope = 1;
            try {
                int retry = 0;
                while (retry <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.searchSubOrganizationNames() retry: " + retry);
                    }
                    try {
                        if (recursive) {
                            scope = 2;
                        }
                        results = conn.search(this.getNormalizedName(token, dn), scope, filter, O_ATTR, false, constraints);
                        if (sortResults) {
                            LDAPCompareAttrNames comparator = new LDAPCompareAttrNames(this.getOrgNamingAttribute(), ascendingOrder);
                            results.sort((LDAPEntryComparator)comparator);
                        }
                        break;
                    }
                    catch (LDAPException e) {
                        if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                            throw e;
                        }
                        ++retry;
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
            }
            catch (LDAPException le) {
                if (le.getLDAPResultCode() == 32) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject: suborg not present:" + dn);
                    }
                    break block22;
                }
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Unable to search for suborganization names: " + dn, (Throwable)le);
                }
                throw new SMSException(le, "sms-suborg-cannot-search");
            }
            finally {
                SMSLdapObject.releaseConnection(conn);
            }
        }
        OrderedSet answer = new OrderedSet();
        while (results != null && results.hasMoreElements()) {
            LDAPEntry entry;
            try {
                entry = results.next();
            }
            catch (LDAPException ldape) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in obtaining suborganization names: " + dn, (Throwable)ldape);
                }
                throw new SMSException(ldape, "sms-suborg-cannot-obtain");
            }
            String rdn = entry.getDN().toString();
            answer.add(rdn);
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: Successfully obtained suborganization names for : " + dn);
            debug.message("SMSLdapObject: Successfully obtained suborganization names  : " + answer.toString());
        }
        return answer;
    }

    public Set searchOrganizationNames(SSOToken token, String dn, int numOfEntries, boolean sortResults, boolean ascendingOrder, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject:searchOrganizationNames search dn: " + dn);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(&");
        Iterator itr = values.iterator();
        while (itr.hasNext()) {
            String val = (String)itr.next();
            sb.append("(|(").append("sunxmlKeyValue").append("=").append(serviceName).append("-").append(attrName).append("=").append(val).append(")");
            sb.append("(").append("sunxmlKeyValue").append("=").append(attrName).append("=").append(val).append("))");
        }
        sb.append(")");
        String filter = sb.toString();
        String FILTER_PATTERN_SEARCH_ORG = "{0}";
        String dataStore = SMSEntry.getDataStore(token);
        if (dataStore != null && !dataStore.equals(SMSEntry.DATASTORE_ACTIVE_DIR)) {
            FILTER_PATTERN_SEARCH_ORG = "(|(&(objectclass=sunRealmService){0})(&(objectclass=sunServiceComponent){0}))";
        }
        String[] objs = new String[]{filter};
        String sfilter = MessageFormat.format(FILTER_PATTERN_SEARCH_ORG, objs);
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject:orgNames search filter: " + sfilter);
        }
        Set answer = this.getOrgNames(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getOrgNames(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        LDAPSearchResults results;
        block21: {
            LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            constraints.setMaxResults(numOfEntries);
            constraints.setServerTimeLimit(0);
            results = null;
            int scope = 2;
            try {
                int retry = 0;
                while (retry <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject.getOrgNames() retry: " + retry);
                    }
                    try {
                        results = conn.search(this.getNormalizedName(token, dn), scope, filter, O_ATTR, false, constraints);
                        if (sortResults) {
                            LDAPCompareAttrNames comparator = new LDAPCompareAttrNames(this.getOrgNamingAttribute(), ascendingOrder);
                            results.sort((LDAPEntryComparator)comparator);
                        }
                        break;
                    }
                    catch (LDAPException e) {
                        if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                            throw e;
                        }
                        ++retry;
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException ex) {}
                    }
                }
            }
            catch (LDAPException le) {
                if (le.getLDAPResultCode() == 32) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSLdapObject: org not present:" + dn);
                    }
                    break block21;
                }
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Unable to search for organization names: " + dn, (Throwable)le);
                }
                throw new SMSException(le, "sms-org-cannot-search");
            }
            finally {
                SMSLdapObject.releaseConnection(conn);
            }
        }
        OrderedSet answer = new OrderedSet();
        while (results != null && results.hasMoreElements()) {
            LDAPEntry entry;
            try {
                entry = results.next();
            }
            catch (LDAPException ldape) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject: Error in obtaining organization names: " + dn, (Throwable)ldape);
                }
                throw new SMSException(ldape, "sms-org-cannot-obtain");
            }
            String rdn = entry.getDN().toString();
            answer.add(rdn);
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: Successfully obtained organization names for : " + dn);
            debug.message("SMSLdapObject: Successfully obtained organization names  : " + answer.toString());
        }
        return answer;
    }

    private String getDenormalizedName(SSOToken token, String name) {
        String dataStore;
        if (name.indexOf("^") >= 0 && (dataStore = SMSEntry.getDataStore(token)) != null && dataStore.equals(SMSEntry.DATASTORE_ACTIVE_DIR)) {
            name = name.replaceAll("_", "=");
        }
        return name;
    }

    private String getNormalizedName(SSOToken token, String dn) {
        String dataStore;
        if (dn.indexOf("^") >= 0 && (dataStore = SMSEntry.getDataStore(token)) != null && dataStore.equals(SMSEntry.DATASTORE_ACTIVE_DIR)) {
            String[] dns = LDAPDN.explodeDN((String)dn, (boolean)false);
            StringBuffer buff = new StringBuffer();
            String s = dns[0];
            int idx = s.indexOf(61);
            String naming = s.substring(0, idx + 1);
            String value = s.substring(idx + 1).replaceAll("=", "_");
            buff.append(naming).append(value);
            for (int i = 1; i < dns.length; ++i) {
                s = dns[i];
                idx = s.indexOf(61);
                naming = s.substring(0, idx + 1);
                value = s.substring(idx + 1).replaceAll("=", "_");
                buff.append(",").append(naming).append(value);
            }
            dn = buff.toString();
        }
        return dn;
    }

    static {
        connNumRetry = 3;
        connRetryInterval = 1000;
        retryErrorCodes = new HashSet();
        entriesPresent = new HashSet();
        entriesNotPresent = new HashSet();
        OU_ATTR = new String[1];
        O_ATTR = new String[1];
    }
}

