/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.ldap.ServerInstance;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.shared.debug.Debug;
import java.lang.constant.Constable;
import java.util.HashMap;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;

class SMDataLayer {
    private static Debug debug;
    static final int MAX_CONN = 20;
    static final int MAX_BACKLOG = 100;
    static final String LDAP_MAXBACKLOG = "maxbacklog";
    static final String LDAP_RELEASECONNBEFORESEARCH = "releaseconnectionbeforesearchcompletes";
    static final String LDAP_REFERRAL = "referral";
    private static SMDataLayer m_instance;
    private LDAPConnectionPool _ldapPool = null;
    private LDAPConnection _trialConn = null;
    private boolean m_releaseConnectionBeforeSearchCompletes;
    private LDAPSearchConstraints _defaultSearchConstraints = null;

    private SMDataLayer() {
        this.initLdapPool();
    }

    public static void reset() {
        m_instance = null;
    }

    protected static synchronized SMDataLayer getInstance() {
        debug = Debug.getInstance((String)"amSMSLdap");
        if (m_instance == null) {
            m_instance = new SMDataLayer();
        }
        return m_instance;
    }

    protected LDAPConnection getConnection() {
        if (this._ldapPool == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:getConnection()-Invoking _ldapPool.getConnection()");
        }
        LDAPConnection conn = this._ldapPool.getConnection();
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:getConnection()-Got Connection : " + conn);
        }
        return conn;
    }

    public void releaseConnection(LDAPConnection conn, int ldapErrCode) {
        if (this._ldapPool == null || conn == null) {
            return;
        }
        conn.setSearchConstraints(this._defaultSearchConstraints);
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:releaseConnection()-Invoking _ldapPool.close(conn,ldapErrCode) : " + conn + ":" + ldapErrCode);
        }
        this._ldapPool.close(conn, ldapErrCode);
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:releaseConnection()-Released Connection:close(conn,ldapErrCode) : " + conn);
        }
    }

    protected void releaseConnection(LDAPConnection conn) {
        if (this._ldapPool == null || conn == null) {
            return;
        }
        conn.setSearchConstraints(this._defaultSearchConstraints);
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:releaseConnection()-Invoking _ldapPool.close(conn) : " + conn);
        }
        this._ldapPool.close(conn);
        if (debug.messageEnabled()) {
            debug.message("SMDataLayer:releaseConnection()-Released Connection : " + conn);
        }
    }

    private synchronized void initLdapPool() {
        if (this._ldapPool != null) {
            return;
        }
        ServerInstance svrCfg = null;
        String hostName = null;
        HashMap<String, Constable> connOptions = new HashMap<String, Constable>();
        try {
            DSConfigMgr dsCfg = DSConfigMgr.getDSConfigMgr();
            hostName = dsCfg.getHostName("default");
            ServerGroup sg = dsCfg.getServerGroup("sms");
            if (sg != null) {
                this._trialConn = dsCfg.getNewConnection("sms", LDAPUser.Type.AUTH_ADMIN);
                svrCfg = sg.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
                hostName = dsCfg.getHostName("sms");
            } else {
                this._trialConn = dsCfg.getNewAdminConnection();
                svrCfg = dsCfg.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            }
            if (svrCfg == null) {
                debug.error("SMDataLayer:initLdapPool()-Error getting server config.");
            }
            int poolMin = svrCfg.getMinConnections();
            int poolMax = svrCfg.getMaxConnections();
            String connDN = svrCfg.getAuthID();
            String connPWD = svrCfg.getPasswd();
            int maxBackLog = svrCfg.getIntValue(LDAP_MAXBACKLOG, 100);
            this.m_releaseConnectionBeforeSearchCompletes = svrCfg.getBooleanValue(LDAP_RELEASECONNBEFORESEARCH, false);
            boolean referrals = svrCfg.getBooleanValue(LDAP_REFERRAL, true);
            if (debug.messageEnabled()) {
                debug.message("SMDataLayer:initLdapPool()-Creating ldap connection pool with :");
                debug.message("SMDataLayer:initLdapPool()-poolMin : " + poolMin);
                debug.message("SMDataLayer:initLdapPool()-poolMax : " + poolMax);
                debug.message("SMDataLayer:getConnection()-maxBackLog : " + maxBackLog);
            }
            this._trialConn.setOption(30, (Object)new Integer(maxBackLog));
            this._trialConn.setOption(8, (Object)referrals);
            LDAPBind defaultBinder = new LDAPBind(){

                public void bind(LDAPConnection ld) throws LDAPException {
                    String dn = SMDataLayer.this._trialConn.getAuthenticationDN();
                    String pwd = SMDataLayer.this._trialConn.getAuthenticationPassword();
                    String newhost = ld.getHost();
                    int newport = ld.getPort();
                    ld.connect(3, newhost, newport, dn, pwd);
                }
            };
            this._trialConn.setOption(13, (Object)defaultBinder);
            this._defaultSearchConstraints = this._trialConn.getSearchConstraints();
            connOptions.put(LDAP_MAXBACKLOG, new Integer(maxBackLog));
            connOptions.put("referrals", new Boolean(referrals));
            connOptions.put("searchconstraints", (Constable)this._defaultSearchConstraints);
            this._ldapPool = new LDAPConnectionPool("SMS", poolMin, poolMax, hostName, 389, connDN, connPWD, this._trialConn, connOptions);
            ShutdownManager.getInstance().addShutdownListener(new ShutdownListener(){

                public void shutdown() {
                    if (SMDataLayer.this._ldapPool != null) {
                        SMDataLayer.this._ldapPool.destroy();
                    }
                }
            });
        }
        catch (LDAPServiceException ex) {
            debug.error("SMDataLayer:initLdapPool()-Error initializing connection pool " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (LDAPException e) {
            debug.error("SMDataLayer:initLdapPool()-Exception in SMDataLayer.initLdapPool:", (Throwable)e);
            e.printStackTrace();
        }
    }

    static {
        m_instance = null;
    }
}

