/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.InvalidAttributeNameException;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceSchema {
    ServiceSchemaImpl ss;
    String componentName;
    SchemaType type;
    ServiceSchemaManager ssm;
    boolean orgAttrSchema;
    static Debug debug = SMSEntry.debug;

    private ServiceSchema() {
    }

    protected ServiceSchema(ServiceSchemaImpl ssi, String compName, SchemaType type, ServiceSchemaManager ssm) {
        this(ssi, compName, type, ssm, false);
    }

    protected ServiceSchema(ServiceSchemaImpl ssi, String compName, SchemaType type, ServiceSchemaManager ssm, boolean isOrgAttrSchema) {
        this.ss = ssi;
        this.componentName = compName;
        this.type = type;
        this.ssm = ssm;
        this.orgAttrSchema = isOrgAttrSchema;
        this.ss.isOrgAttrSchema = isOrgAttrSchema;
        this.ss.serviceName = ssm.getName();
    }

    public String getServiceName() {
        return this.ssm.getName();
    }

    public String getVersion() {
        return this.ssm.getVersion();
    }

    public String getName() {
        return this.ss.getName();
    }

    public SchemaType getServiceType() {
        return this.type;
    }

    public String getI18NKey() {
        return this.ss.getI18NKey();
    }

    public boolean supportsMultipleConfigurations() {
        return this.ss.supportsMultipleConfigurations();
    }

    public void setI18Nkey(String key) throws SMSException, SSOException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Node sNode = this.ss.getSchemaNode();
        ((Element)sNode).setAttribute("i18nKey", key);
        this.ssm.replaceSchema(ServiceSchemaManagerImpl.getInstance(this.ssm.getSSOToken(), this.ssm.getName(), this.ssm.getVersion()).getDocument());
        this.ss.i18nKey = key;
    }

    public void setInheritance(String value) throws SMSException, SSOException {
        if (!value.equals("single") && !value.equals("multiple")) {
            Object[] arg = new String[]{value};
            throw new SMSException("amSDK", "sms-invalid-inheritance-value", arg);
        }
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Node sNode = this.ss.getSchemaNode();
        ((Element)sNode).setAttribute("inheritance", value);
        this.ssm.replaceSchema(ServiceSchemaManagerImpl.getInstance(this.ssm.getSSOToken(), this.ssm.getName(), this.ssm.getVersion()).getDocument());
        this.ss.inheritance = value;
    }

    public String getPropertiesViewBeanURL() {
        return this.ssm.getPropertiesViewBeanURL();
    }

    public String getStatusAttribute() {
        return this.ss.getStatusAttribute();
    }

    public boolean isExportable() {
        return false;
    }

    public void setExportable(boolean exportable) {
    }

    public String getI18NFileName() {
        return this.ssm.getI18NFileName();
    }

    public void setI18NFileName(String url) throws SMSException, SSOException {
        this.ssm.setI18NFileName(url);
    }

    public Set getAttributeSchemaNames() {
        return this.ss.getAttributeSchemaNames();
    }

    protected Set getSearchableAttributeNames() {
        return this.ss.getSearchableAttributeNames();
    }

    public AttributeSchema getAttributeSchema(String attributeName) {
        AttributeSchemaImpl as = this.ss.getAttributeSchema(attributeName);
        return as == null ? null : new AttributeSchema(as, this.ssm, this);
    }

    public Set getAttributeSchemas() {
        HashSet<AttributeSchema> answer = new HashSet<AttributeSchema>();
        Iterator items = this.getAttributeSchemaNames().iterator();
        while (items.hasNext()) {
            String attrName = (String)items.next();
            answer.add(this.getAttributeSchema(attrName));
        }
        return answer;
    }

    public Set getServiceAttributeNames() {
        return this.ss.getServiceAttributeNames();
    }

    public Map validateAndInheritDefaults(Map attrMap, boolean inherit) throws SMSException {
        return this.validateAndInheritDefaults(attrMap, null, inherit);
    }

    public Map validateAndInheritDefaults(Map attrMap, String orgName, boolean inherit) throws SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        if (attrMap == null || attrMap.isEmpty()) {
            attrMap = new HashMap();
        }
        Iterator keys = attrMap.keySet().iterator();
        Set defAttrSet = this.ss.getAttributeSchemaNames();
        while (keys.hasNext()) {
            String attr = (String)keys.next();
            if (defAttrSet.contains(attr)) continue;
            debug.error("ServiceSchema.validateAndInheritDefaults: " + attr + " is not listed in the service " + this.getServiceName());
            throw new InvalidAttributeNameException("amSDK", "services_validator_invalid_attr_name", null);
        }
        HashMap<String, Object> envMap = Collections.EMPTY_MAP;
        if (orgName != null) {
            envMap = new HashMap<String, Object>();
            envMap.put("organization_name", orgName);
            envMap.put("SSOToken", this.ssm.getSSOToken());
        }
        Iterator ass = this.ss.getAttributeSchemaNames().iterator();
        while (ass.hasNext()) {
            Set valSet;
            String attr = (String)ass.next();
            AttributeSchemaImpl as = this.ss.getAttributeSchema(attr);
            AttributeValidator av = this.ss.getAttributeValidator(attr);
            String anyValue = as.getAny();
            if (inherit && anyValue != null && anyValue.indexOf("required") > -1) {
                Set attrVals = (Set)(attrMap = av.inheritDefaults(attrMap)).get(attr);
                if (attrVals == null || attrVals.isEmpty()) {
                    debug.error("ServiceSchema.validateAndInheritDefaults: " + attr + " is a required attribute and cannot" + " be deleted");
                    Object[] args = new Object[]{attr};
                    throw new SMSException("amSDK", "sms-required-attribute-delete", args);
                }
            } else if (inherit) {
                attrMap = av.inheritDefaults(attrMap);
            }
            if ((valSet = (Set)attrMap.get(attr)) == null) continue;
            String i18nFileName = this.ssm != null ? this.ssm.getI18NFileName() : null;
            av.validate(valSet, i18nFileName, false, envMap);
        }
        if (debug.messageEnabled()) {
            debug.error("ServiceSchema.validate&InheritDef:  returning attrMap: " + attrMap.toString());
        }
        return attrMap;
    }

    public void addAttributeSchema(InputStream xmlAttrSchema) throws SSOException, SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Document doc = SMSSchema.getXMLDocument(xmlAttrSchema, false);
        NodeList nl = doc.getElementsByTagName("AttributeSchema");
        CaseInsensitiveHashSet asNames = new CaseInsensitiveHashSet((Collection)this.ss.getAttributeSchemaNames());
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            AttributeSchemaImpl as = new AttributeSchemaImpl(node);
            if (!asNames.contains(as.getName())) continue;
            Object[] args = new Object[]{as.getName()};
            throw new SMSException("amSDK", "sms-attributeschema-already-exists", args);
        }
        this.appendChildNode(nl);
    }

    public void removeAttributeSchema(String attrName) throws SSOException, SMSException {
        this.removeChildNode("AttributeSchema", attrName);
    }

    public Map getAttributeDefaults() {
        return this.ss.getAttributeDefaults();
    }

    public Map getReadOnlyAttributeDefaults() {
        return this.ss.getReadOnlyAttributeDefaults();
    }

    public void setAttributeDefaults(Map attrs) throws SSOException, SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Document document = this.ssm.getDocumentCopy();
        Iterator items = attrs.keySet().iterator();
        while (items.hasNext()) {
            String attrName = (String)items.next();
            AttributeSchema as = this.getAttributeSchema(attrName);
            if (as == null) {
                Object[] args = new Object[]{attrName};
                throw new SchemaException("amSDK", "sms-invalid-attr-name", args);
            }
            as.setDefaultValues((Set)attrs.get(attrName), document);
        }
        this.ssm.replaceSchema(document);
    }

    public void setAttributeDefaults(String attrName, Set values) throws SchemaException, SMSException, SSOException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        AttributeSchema as = this.getAttributeSchema(attrName);
        if (as == null) {
            Object[] args = new Object[]{attrName};
            throw new SchemaException("amSDK", "sms-invalid-attr-name", args);
        }
        as.setDefaultValues(values);
    }

    public void removeAttributeDefaults(Set attrs) throws SMSException, SSOException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            String asName = (String)it.next();
            AttributeSchema as = this.getAttributeSchema(asName);
            if (as == null) {
                throw new InvalidAttributeNameException("amSDK", "services_validator_invalid_attr_name", null);
            }
            as.removeDefaultValues();
        }
    }

    public Set getSubSchemaNames() {
        return this.ss.getSubSchemaNames();
    }

    public ServiceSchema getSubSchema(String subSchemaName) throws SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        ServiceSchema answer = null;
        ServiceSchemaImpl ssi = this.ss.getSubSchema(subSchemaName);
        if (ssi != null) {
            answer = new ServiceSchema(ssi, this.componentName + "/" + subSchemaName, this.type, this.ssm);
        }
        return answer;
    }

    public void addSubSchema(InputStream xmlSubSchema) throws SSOException, SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        Document doc = SMSSchema.getXMLDocument(xmlSubSchema, false);
        NodeList nl = doc.getElementsByTagName("SubSchema");
        Set asNames = this.ss.getSubSchemaNames();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            String nodeName = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
            if (!asNames.contains(nodeName)) continue;
            Object[] args = new Object[]{nodeName};
            throw new SMSException("amSDK", "sms-subschema-already-exists", args);
        }
        this.appendChildNode(nl);
    }

    public void removeSubSchema(String subSchemaName) throws SSOException, SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        this.removeChildNode("SubSchema", subSchemaName);
    }

    public boolean validateAttributes(Map attributeSet) throws SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        return this.ss.validateAttributes(this.ssm.getSSOToken(), attributeSet, false, null);
    }

    public boolean validateAttributes(Map attributeSet, String orgName) throws SMSException {
        SMSEntry.validateToken(this.ssm.getSSOToken());
        return this.ss.validateAttributes(this.ssm.getSSOToken(), attributeSet, false, orgName);
    }

    public String toString() {
        return this.ss.toString();
    }

    public Node getSchemaNode() {
        Node node = null;
        try {
            node = this.getSchemaNode(this.ssm.getDocumentCopy());
        }
        catch (SMSException ssme) {
            debug.error("ServiceSchema::getSchemaNode: invalid schema");
        }
        return node;
    }

    void appendChildNode(InputStream in, String nodeName) throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("ServiceSchema::appendChildNode called for: " + this.getServiceName() + "(" + this.ssm.getVersion() + ") " + this.componentName + " + " + nodeName);
        }
        Document doc = SMSSchema.getXMLDocument(in, false);
        NodeList nodes = doc.getElementsByTagName(nodeName);
        this.appendChildNode(nodes);
    }

    void appendChildNode(NodeList nodes) throws SSOException, SMSException {
        if (nodes == null || nodes.getLength() == 0) {
            throw new SMSException("amSDK", "sms-SMSSchema_no_schema_element", null);
        }
        Document schemaDoc = this.ssm.getDocumentCopy();
        try {
            Node schemaNode = this.getSchemaNode(schemaDoc);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                Node iNode = schemaDoc.importNode(node, true);
                schemaNode.appendChild(iNode);
            }
        }
        catch (Exception e) {
            throw new SMSException(e.getMessage(), e, "sms-cannot_append_NODE");
        }
        this.ssm.replaceSchema(schemaDoc);
    }

    void removeChildNode(String nodeType, String nodeName) throws SSOException, SMSException {
        Node node;
        Document schemaDoc;
        Node schemaNode;
        if (debug.messageEnabled()) {
            debug.message("ServiceSchema::appendChildNode called for: " + this.getServiceName() + "(" + this.ssm.getVersion() + ") " + this.componentName);
        }
        if ((schemaNode = this.getSchemaNode(schemaDoc = this.ssm.getDocumentCopy())) != null && (node = XMLUtils.getNamedChildNode((Node)schemaNode, (String)nodeType, (String)"name", (String)nodeName)) != null) {
            schemaNode.removeChild(node);
            this.ssm.replaceSchema(schemaDoc);
        }
    }

    Node getSchemaNode(Document document) throws SMSException {
        NodeList nodes = document.getElementsByTagName("Schema");
        if (nodes == null || nodes.getLength() == 0) {
            this.throwInvalidSchemaException();
        }
        Node rNode = nodes.item(0);
        String schemaType = "Global";
        if (this.type.equals(SchemaType.ORGANIZATION)) {
            schemaType = "Organization";
        } else if (this.type.equals(SchemaType.DYNAMIC)) {
            schemaType = "Dynamic";
        } else if (this.type.equals(SchemaType.USER)) {
            schemaType = "User";
        } else if (this.type.equals(SchemaType.POLICY)) {
            schemaType = "Policy";
        } else if (this.type.equals(SchemaType.GROUP)) {
            schemaType = "Group";
        } else if (this.type.equals(SchemaType.DOMAIN)) {
            schemaType = "Domain";
        }
        Node stNode = XMLUtils.getChildNode((Node)rNode, (String)schemaType);
        if (stNode == null) {
            this.throwInvalidSchemaException();
        }
        if (this.componentName == null || this.componentName.length() == 0) {
            return stNode;
        }
        if (this.orgAttrSchema) {
            return XMLUtils.getChildNode((Node)stNode, (String)"OrganizationAttributeSchema");
        }
        StringTokenizer st = new StringTokenizer(this.componentName, "/");
        while (st.hasMoreTokens()) {
            String tokenName = st.nextToken();
            if (tokenName == null || tokenName.length() == 0 || (stNode = XMLUtils.getNamedChildNode((Node)stNode, (String)"SubSchema", (String)"name", (String)tokenName)) != null) continue;
            this.throwInvalidSchemaException();
        }
        return stNode;
    }

    void throwInvalidSchemaException() throws SMSException {
        SMSEntry.debug.error("ServiceSchema::getSchemaNode: Invalid service schema XML: " + this.getServiceName() + "(" + this.ssm.getVersion() + ")");
        throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
    }
}

