/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchemaImpl;
import com.sun.identity.sm.AttributeValidator;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.ServiceSchemaImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class PluginSchemaImpl
extends ServiceSchemaImpl {
    protected String interfaceName;
    protected String iclass;
    protected String jarURL;
    protected String resourceBundleURL;
    protected String i18nFileName;
    protected String viewBeanURL;
    protected String serviceName;
    protected String version;
    protected String schemaDocument;
    CachedSMSEntry smsEntry;
    private static Map pluginSchemas = new HashMap();
    private static final String pluginSchemasMutex = "PluginSchemaMutext";

    PluginSchemaImpl() {
    }

    PluginSchemaImpl(SSOToken token, String serviceName, String version, String pluginName, String interfaceName, String orgName) throws SMSException {
        this.serviceName = serviceName;
        this.version = version;
        this.name = pluginName;
        this.interfaceName = interfaceName;
        StringBuffer sb = new StringBuffer(100);
        sb.append("ou=").append(pluginName).append(",").append("ou=").append(interfaceName).append(",").append("ou=PluginConfig,").append("ou=").append(version).append(",").append("ou=").append(serviceName).append(",").append("ou=services").append(",");
        try {
            this.smsEntry = CachedSMSEntry.getInstance(token, sb.toString() + orgName, this);
        }
        catch (SSOException ssoe) {
            throw new SMSException((Throwable)((Object)ssoe), "sms-INVALID_SSO_TOKEN");
        }
        if (this.smsEntry.getSMSEntry().getAttributeValues("sunPluginSchema") == null && !orgName.equals(SMSEntry.baseDN)) {
            try {
                this.smsEntry = CachedSMSEntry.getInstance(token, sb.toString() + SMSEntry.baseDN, this);
            }
            catch (SSOException ssoe) {
                throw new SMSException((Throwable)((Object)ssoe), "sms-INVALID_SSO_TOKEN");
            }
        }
        this.attrSchemas = new HashMap();
        this.update();
    }

    String getName() {
        return this.name;
    }

    String getVersion() {
        return this.version;
    }

    String getInterfaceName() {
        return this.interfaceName;
    }

    String getClassName() {
        return this.iclass;
    }

    String getJarURL() {
        return this.jarURL;
    }

    String getI18NJarURL() {
        return this.resourceBundleURL;
    }

    String getI18NFileName() {
        return this.i18nFileName;
    }

    String getPropertiesViewBeanURL() {
        return this.viewBeanURL;
    }

    String getI18NKey() {
        return this.i18nKey;
    }

    Set getAttributeSchemaNames() {
        return new HashSet(this.attrSchemas.keySet());
    }

    AttributeSchemaImpl getAttributeSchema(String attrSchemaName) {
        return (AttributeSchemaImpl)this.attrSchemas.get(attrSchemaName);
    }

    CachedSMSEntry getCachedSMSEntry() {
        return this.smsEntry;
    }

    synchronized void updateAndNotifyListeners() {
        this.update();
    }

    synchronized void update() {
        Node pluginNode = null;
        String[] schemaAttrs = this.smsEntry.getSMSEntry().getAttributeValues("sunPluginSchema");
        if (schemaAttrs != null) {
            this.schemaDocument = schemaAttrs[0];
            Document doc = null;
            try {
                doc = SMSSchema.getXMLDocument(schemaAttrs[0], false);
            }
            catch (SMSException smse) {
                SMSEntry.debug.error("PluginSchemaImpl: XML parser error: " + this.serviceName + "(" + this.version + "): " + this.name, (Throwable)smse);
                return;
            }
            NodeList nodes = doc.getElementsByTagName("PluginSchema");
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    if (!XMLUtils.getNodeAttributeValue((Node)nodes.item(i), (String)"name").equals(this.name)) continue;
                    pluginNode = nodes.item(i);
                    break;
                }
            }
        }
        if (pluginNode == null) {
            this.attrSchemas = new HashMap();
            this.attrValidators = new HashMap();
            this.i18nKey = null;
            this.i18nFileName = null;
            this.resourceBundleURL = null;
            this.jarURL = null;
            this.iclass = null;
            this.schemaDocument = SMSSchema.getDummyXML(this.serviceName, this.version);
            return;
        }
        this.iclass = XMLUtils.getNodeAttributeValue(pluginNode, (String)"className");
        this.jarURL = XMLUtils.getNodeAttributeValue(pluginNode, (String)"jarURL");
        this.resourceBundleURL = XMLUtils.getNodeAttributeValue(pluginNode, (String)"i18nJarURL");
        this.i18nFileName = XMLUtils.getNodeAttributeValue(pluginNode, (String)"i18nFileName");
        this.viewBeanURL = XMLUtils.getNodeAttributeValue(pluginNode, (String)"propertiesViewBeanURL");
        this.i18nKey = XMLUtils.getNodeAttributeValue(pluginNode, (String)"i18nKey");
        HashMap<String, AttributeSchemaImpl> newAttributeSchemas = new HashMap<String, AttributeSchemaImpl>();
        HashMap<String, AttributeValidator> newAttrValidators = new HashMap<String, AttributeValidator>();
        Iterator items = XMLUtils.getChildNodes((Node)pluginNode, (String)"AttributeSchema").iterator();
        while (items.hasNext()) {
            Node node = (Node)items.next();
            String aname = XMLUtils.getNodeAttributeValue((Node)node, (String)"name");
            AttributeSchemaImpl asi = (AttributeSchemaImpl)this.attrSchemas.get(aname);
            if (asi == null) {
                asi = new AttributeSchemaImpl(node);
            } else {
                asi.update(node);
            }
            newAttributeSchemas.put(aname, asi);
            newAttrValidators.put(aname, new AttributeValidator(asi));
        }
        this.attrSchemas = newAttributeSchemas;
        this.attrValidators = newAttrValidators;
    }

    AttributeValidator getAttributeValidator(String attrName) {
        AttributeValidator av = (AttributeValidator)this.attrValidators.get(attrName);
        if (av == null) {
            AttributeSchemaImpl as = this.getAttributeSchema(attrName);
            if (as == null) {
                return null;
            }
            av = new AttributeValidator(as);
            this.attrValidators.put(attrName, av);
        }
        return av;
    }

    Document getDocumentCopy() {
        try {
            return SMSSchema.getXMLDocument(this.schemaDocument, false);
        }
        catch (SMSException e) {
            SMSEntry.debug.error("PluginSchemaImpl:: unable to generate XML document: " + this.name);
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        if (this.getName() != null) {
            sb.append("Plugin Schema name: ").append(this.getName()).append("\n");
        }
        if (this.attrSchemas.size() > 0) {
            sb.append("Attribute Schemas:\n");
            Iterator items = this.attrSchemas.keySet().iterator();
            while (items.hasNext()) {
                sb.append(this.attrSchemas.get(items.next()).toString());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PluginSchemaImpl getInstance(SSOToken token, String serviceName, String version, String pluginName, String iName, String orgName) throws SMSException {
        String oName = DNMapper.orgNameToDN(orgName);
        StringBuffer sb = new StringBuffer(100);
        sb.append(oName).append(iName).append(pluginName).append(serviceName).append(version);
        String cName = sb.toString().toLowerCase();
        PluginSchemaImpl answer = (PluginSchemaImpl)pluginSchemas.get(cName);
        if (answer != null) {
            if (!SMSEntry.cacheSMSEntries) {
                answer.update();
            }
            return answer;
        }
        String string = pluginSchemasMutex;
        synchronized (pluginSchemasMutex) {
            answer = (PluginSchemaImpl)pluginSchemas.get(cName);
            if (answer == null) {
                answer = new PluginSchemaImpl(token, serviceName, version, pluginName, iName, oName);
                HashMap<String, PluginSchemaImpl> sudoPluginSchemas = new HashMap<String, PluginSchemaImpl>(pluginSchemas);
                sudoPluginSchemas.put(cName, answer);
                pluginSchemas = sudoPluginSchemas;
            }
            // ** MonitorExit[var10_10] (shouldn't be in output)
            return answer;
        }
    }

    static void clearCache() {
        pluginSchemas = new HashMap();
    }
}

