/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.CreateServiceConfig;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginConfigImpl;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class PluginConfig {
    private String name;
    private SSOToken token;
    private PluginConfigImpl pc;
    private PluginSchemaImpl ps;
    private ServiceConfigManager scm;

    private PluginConfig() {
    }

    protected PluginConfig(String name, ServiceConfigManager scm, PluginConfigImpl pc) throws SMSException, SSOException {
        this.scm = scm;
        this.token = scm.getSSOToken();
        this.pc = pc;
        this.ps = pc.getPluginSchemaImpl();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.scm.getName();
    }

    public String getVersion() {
        return this.scm.getVersion();
    }

    public int getPriority() {
        return this.pc.getPriority();
    }

    public void setPriority(int priority) throws SSOException, SMSException {
        StringBuffer sb = new StringBuffer(8);
        String[] priorities = new String[]{sb.append(priority).toString()};
        SMSEntry e = this.pc.getSMSEntry();
        e.setAttribute("sunsmspriority", priorities);
        this.saveSMSEntry(e);
    }

    public Map getAttributes() {
        return this.pc.getAttributes();
    }

    public void setAttributes(Map attrs) throws SMSException, SSOException {
        HashMap newAttrs = new HashMap(attrs);
        Map oldAttrs = this.getAttributes();
        Iterator it = oldAttrs.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            if (newAttrs.containsKey(s)) continue;
            newAttrs.put(s, oldAttrs.get(s));
        }
        this.ps.validateAttributes(newAttrs, true);
        SMSEntry e = this.pc.getSMSEntry();
        SMSUtils.setAttributeValuePairs(e, newAttrs, this.ps.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public void addAttribute(String attrName, Set values) throws SMSException, SSOException {
        Map attributes = this.getAttributes();
        HashSet newVals = values;
        Set oldVals = (Set)attributes.get(attrName);
        if (oldVals != null) {
            newVals = new HashSet();
            newVals.addAll(oldVals);
            newVals.addAll(values);
        }
        this.ps.validateAttrValues(this.token, attrName, newVals, true, this.pc.getOrganizationName());
        SMSEntry e = this.pc.getSMSEntry();
        SMSUtils.addAttribute(e, attrName, values, this.ps.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public void removeAttribute(String attrName) throws SMSException, SSOException {
        SMSEntry e = this.pc.getSMSEntry();
        SMSUtils.removeAttribute(e, attrName);
        this.saveSMSEntry(e);
    }

    public void removeAttributeValues(String attrName, Set values) throws SMSException, SSOException {
        SMSEntry e = this.pc.getSMSEntry();
        SMSUtils.removeAttributeValues(e, attrName, values, this.ps.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public void replaceAttributeValue(String attrName, String oldValue, String newValue) throws SMSException, SSOException {
        Map attributes = this.getAttributes();
        HashSet<String> newVals = new HashSet<String>();
        Set oldVals = (Set)attributes.get(attrName);
        if (oldVals != null) {
            newVals.addAll(oldVals);
            newVals.remove(oldValue);
        }
        newVals.add(newValue);
        this.ps.validateAttrValues(this.token, attrName, newVals, true, this.pc.getOrganizationName());
        SMSEntry e = this.pc.getSMSEntry();
        SMSUtils.replaceAttributeValue(e, attrName, oldValue, newValue, this.ps.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public void replaceAttributeValues(String attrName, Set oldValues, Set newValues) throws SMSException, SSOException {
        Map attributes = this.getAttributes();
        HashSet newVals = new HashSet();
        Set oldVals = (Set)attributes.get(attrName);
        if (oldVals != null) {
            newVals.addAll(oldVals);
            newVals.removeAll(oldValues);
        }
        newVals.addAll(newValues);
        this.ps.validateAttrValues(this.token, attrName, newVals, true, this.pc.getOrganizationName());
        SMSEntry e = this.pc.getSMSEntry();
        SMSUtils.replaceAttributeValues(e, attrName, oldValues, newValues, this.ps.getSearchableAttributeNames());
        this.saveSMSEntry(e);
    }

    public String getDN() {
        return this.pc.getDN();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Plugin name: " + this.getName());
        sb.append("\n\tAttributes: " + this.getAttributes()).append("\n");
        return sb.toString();
    }

    void saveSMSEntry(SMSEntry e) throws SMSException, SSOException {
        if (e.isNewEntry()) {
            CreateServiceConfig.checkBaseNodesForOrg(this.token, DNMapper.orgNameToDN(this.pc.getOrganizationName()), this.getServiceName(), this.getVersion());
            e.addAttribute("objectclass", "top");
            e.addAttribute("objectclass", "sunServiceComponent");
        }
        e.save(this.token);
        this.pc.refresh(e);
    }

    void delete() throws SMSException, SSOException {
        SMSEntry e = this.pc.getSMSEntry();
        DN dn = new DN(e.getDN());
        CachedSubEntries cse = CachedSubEntries.getInstance(this.token, dn.getParent().toString());
        cse.remove(this.getName());
        e.delete(this.token);
        this.pc.refresh(e);
    }
}

