/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import netscape.ldap.util.DN;

public class CachedSubEntries {
    protected static HashMap smsEntries = new CaseInsensitiveHashMap(100);
    protected Map ssoTokenToSubEntries = new Cache(100);
    protected CachedSMSEntry cEntry;
    protected SMSEntry entry;
    protected String notificationID;
    private static Debug debug = SMSEntry.debug;

    private CachedSubEntries(SSOToken t, String dn) throws SMSException {
        try {
            this.cEntry = CachedSMSEntry.getInstance(t, dn, null);
            this.entry = this.cEntry.smsEntry;
            this.update();
            Class<?> c = this.getClass();
            this.notificationID = SMSEventListenerManager.notifyChangesToSubNodes(t, dn, c.getDeclaredMethod("update", null), this, null);
        }
        catch (NoSuchMethodException e) {
            debug.error("CachedSubEntries: unable to register for notifications: ", (Throwable)e);
        }
        catch (SSOException ssoe) {
            debug.warning("CachedSubEntries::init Invalid SSOToken", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::init: " + dn);
        }
    }

    protected Set getSubEntries(SSOToken t) throws SMSException, SSOException {
        String tokenID = ((Object)t.getTokenID()).toString();
        TreeSet subEntries = (TreeSet)this.ssoTokenToSubEntries.get(tokenID);
        if (!SMSEntry.cacheSMSEntries || subEntries == null) {
            subEntries = this.getSubEntries(t, "*");
        }
        if (SMSEntry.cacheSMSEntries) {
            this.ssoTokenToSubEntries.put(tokenID, subEntries);
            TreeSet answer = new TreeSet();
            answer.addAll(subEntries);
            subEntries = answer;
        }
        return subEntries;
    }

    public Set getSubEntries(SSOToken token, String pattern) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading sub-entries DN: " + this.cEntry.dn2Str + " pattern: " + pattern);
        }
        return this.entry.subEntries(token, pattern, 0, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getSchemaSubEntries(String pattern, String serviceidPattern) throws SMSException, SSOException {
        SSOToken token = this.cEntry.getValidSSOToken();
        if (token == null) {
            HashMap hashMap = smsEntries;
            synchronized (hashMap) {
                smsEntries.remove(this.cEntry.dnRFCStr);
            }
            SMSEventListenerManager.removeNotification(this.notificationID);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        return this.getSchemaSubEntries(token, pattern, serviceidPattern);
    }

    public Set getSchemaSubEntries(SSOToken token, String pattern, String serviceidPattern) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading sub-entries DN: " + this.cEntry.dn2Str + " pattern: " + serviceidPattern);
        }
        return this.entry.schemaSubEntries(token, pattern, serviceidPattern, 0, true, true);
    }

    protected void add(String entry) {
        this.ssoTokenToSubEntries = new Cache(100);
    }

    protected void remove(String entry) {
        this.ssoTokenToSubEntries = new Cache(100);
    }

    protected boolean isEmpty(SSOToken t) throws SMSException, SSOException {
        return this.getSubEntries(t).isEmpty();
    }

    protected boolean contains(SSOToken t, String entry) throws SMSException, SSOException {
        return this.getSubEntries(t).contains(entry);
    }

    protected SMSEntry getSMSEntry() {
        return this.entry;
    }

    protected void update() {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::update called for dn: " + this.cEntry.dn2Str);
        }
        this.ssoTokenToSubEntries = new Cache(100);
    }

    protected void finalize() throws Throwable {
        SMSEventListenerManager.removeNotification(this.notificationID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedSubEntries getInstance(SSOToken token, String dn) throws SMSException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries::getInstance DN: " + dn);
        }
        String entry = new DN(dn).toRFCString();
        CachedSubEntries answer = null;
        HashMap hashMap = smsEntries;
        synchronized (hashMap) {
            answer = (CachedSubEntries)smsEntries.get(entry);
        }
        if (answer == null) {
            answer = new CachedSubEntries(token, dn);
            HashMap hashMap2 = smsEntries;
            synchronized (hashMap2) {
                CachedSubEntries tmp = (CachedSubEntries)smsEntries.get(entry);
                if (tmp == null) {
                    smsEntries.put(entry, answer);
                } else {
                    answer = tmp;
                }
            }
        } else {
            answer.cEntry.addPrincipal(token);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set searchSubOrgNames(SSOToken token, String pattern, boolean recursive) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading subOrgNames DN: " + this.cEntry.dn2Str + " pattern: " + pattern);
        }
        if (token == null) {
            HashMap hashMap = smsEntries;
            synchronized (hashMap) {
                smsEntries.remove(this.cEntry.dnRFCStr);
            }
            SMSEventListenerManager.removeNotification(this.notificationID);
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
        boolean sortResults = true;
        boolean sortOrder = true;
        if (recursive) {
            sortResults = false;
            sortOrder = false;
        }
        return this.entry.searchSubOrgNames(token, pattern, 0, sortResults, sortOrder, recursive);
    }

    public Set searchOrgNames(SSOToken token, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("CachedSubEntries: reading orgNames DN: " + this.cEntry.dn2Str + " attrName: " + attrName);
        }
        return this.entry.searchOrganizationNames(token, 0, true, true, serviceName, attrName, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        HashMap hashMap = smsEntries;
        synchronized (hashMap) {
            smsEntries.clear();
        }
    }
}

