/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.LDAPUtils;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

class UserIdRepo {
    private static final String umSunDSForAM;
    private static final String umSunDSGeneric;
    private static UserIdRepo instance;

    private UserIdRepo() {
    }

    public static UserIdRepo getInstance() {
        return instance;
    }

    void configure(Map userRepo, String basedir, ServletContext servletCtx, SSOToken adminToken) throws Exception {
        boolean bFAMUserSchema;
        String type = (String)userRepo.get("userStoreType");
        if (type == null) {
            type = "LDAPv3ForAMDS";
        }
        if (bFAMUserSchema = type.equals("LDAPv3ForAMDS")) {
            this.loadSchema(userRepo, basedir, servletCtx);
        }
        this.addSubConfig(userRepo, type, adminToken);
    }

    private void addSubConfig(Map userRepo, String type, SSOToken adminToken) throws SMSException, SSOException, IOException {
        String xml = null;
        if (type.equals("LDAPv3ForAMDS")) {
            xml = this.getResourceContent(umSunDSForAM);
        } else if (type.equals("LDAPv3")) {
            xml = this.getResourceContent(umSunDSGeneric);
        }
        if (xml != null) {
            Map data = ServicesDefaultValues.getDefaultValues();
            xml = xml.replaceAll("@SM_CONFIG_ROOT_SUFFIX@", (String)data.get("SM_CONFIG_ROOT_SUFFIX"));
            xml = xml.replaceAll("@UM_CONFIG_ROOT_SUFFIX@", (String)userRepo.get("userStoreRootSuffix"));
            xml = xml.replaceAll("@UM_DIRECTORY_SERVER@", this.getHost(userRepo));
            xml = xml.replaceAll("@UM_DIRECTORY_PORT@", this.getPort(userRepo));
            xml = xml.replaceAll("@UM_DS_DIRMGRDN@", this.getBindDN(userRepo));
            xml = xml.replaceAll("@UM_DS_DIRMGRPASSWD@", this.getBindPassword(userRepo));
            String s = (String)userRepo.get("userStoreSSL");
            String ssl = s != null && s.equals("SSL") ? "true" : "false";
            xml = xml.replaceAll("@UM_SSL@", ssl);
            this.registerService(xml, adminToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(String xml, SSOToken adminSSOToken) throws SSOException, SMSException, IOException {
        ServiceManager serviceManager = new ServiceManager(adminSSOToken);
        ByteArrayInputStream serviceStream = null;
        try {
            serviceStream = new ByteArrayInputStream(xml.getBytes());
            serviceManager.registerServices(serviceStream);
        }
        finally {
            if (serviceStream != null) {
                ((InputStream)serviceStream).close();
            }
        }
    }

    static ServiceConfig getOrgConfig(SSOToken adminToken) throws SMSException, SSOException {
        ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", adminToken);
        ServiceConfig cfg = svcCfgMgr.getOrganizationConfig("", null);
        HashMap<String, Set> values = new HashMap<String, Set>();
        if (cfg == null) {
            OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(adminToken, "/");
            ServiceSchemaManager schemaMgr = new ServiceSchemaManager("sunIdentityRepositoryService", adminToken);
            ServiceSchema orgSchema = schemaMgr.getOrganizationSchema();
            Set attrs = orgSchema.getAttributeSchemas();
            Iterator iter = attrs.iterator();
            while (iter.hasNext()) {
                AttributeSchema as = (AttributeSchema)iter.next();
                values.put(as.getName(), as.getDefaultValues());
            }
            cfg = orgCfgMgr.addServiceConfig("sunIdentityRepositoryService", values);
        }
        return cfg;
    }

    private String getHost(Map userRepo) {
        return (String)userRepo.get("userStoreHostName");
    }

    private String getPort(Map userRepo) {
        return (String)userRepo.get("userStorePort");
    }

    private String getBindDN(Map userRepo) {
        return (String)userRepo.get("userStoreLoginID");
    }

    private String getBindPassword(Map userRepo) {
        return (String)userRepo.get("userStoreLoginPassword");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchema(Map userRepo, String basedir, ServletContext servletCtx) throws Exception {
        LDAPConnection ld = null;
        try {
            ld = this.getLDAPConnection(userRepo);
            String dbName = this.getDBName(userRepo, ld);
            List schemas = this.writeSchemaFiles(basedir, dbName, servletCtx);
            Iterator i = schemas.iterator();
            while (i.hasNext()) {
                String file = (String)i.next();
                LDAPUtils.createSchemaFromLDIF(file, ld);
            }
        }
        finally {
            this.disconnectDServer(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List writeSchemaFiles(String basedir, String dbName, ServletContext servletCtx) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        ResourceBundle rb = ResourceBundle.getBundle("schemaNames");
        String strFiles = rb.getString("sundsSchema");
        StringTokenizer st = new StringTokenizer(strFiles);
        while (st.hasMoreTokens()) {
            int len;
            String file = st.nextToken();
            InputStreamReader fin = new InputStreamReader(servletCtx.getResourceAsStream(file));
            StringBuffer sbuf = new StringBuffer();
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
            OutputStreamWriter fout = null;
            try {
                int idx = file.lastIndexOf("/");
                String absFile = idx != -1 ? file.substring(idx + 1) : file;
                String outfile = basedir + "/" + absFile;
                fout = new FileWriter(outfile);
                String inpStr = sbuf.toString();
                inpStr = inpStr.replaceAll("@DB_NAME@", dbName);
                fout.write(ServicesDefaultValues.tagSwap(inpStr));
                files.add(outfile);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception ex) {}
                }
                if (fout == null) continue;
                try {
                    fout.close();
                }
                catch (Exception ex) {}
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResourceContent(String resName) throws IOException {
        BufferedReader rawReader = null;
        String content = null;
        try {
            rawReader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resName)));
            StringBuffer buff = new StringBuffer();
            String line = null;
            while ((line = rawReader.readLine()) != null) {
                buff.append(line);
            }
            rawReader.close();
            rawReader = null;
            content = buff.toString();
        }
        finally {
            if (rawReader != null) {
                rawReader.close();
            }
        }
        return content;
    }

    private void disconnectDServer(LDAPConnection ld) throws LDAPException {
        if (ld != null && ld.isConnected()) {
            ld.disconnect();
        }
    }

    private LDAPConnection getLDAPConnection(Map userRepo) throws Exception {
        String s = (String)userRepo.get("userStoreSSL");
        boolean ssl = s != null && s.equals("SSL");
        LDAPConnection ld = ssl ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
        ld.setConnectTimeout(300);
        int port = Integer.parseInt(this.getPort(userRepo));
        ld.connect(3, this.getHost(userRepo), port, this.getBindDN(userRepo), this.getBindPassword(userRepo));
        return ld;
    }

    private String getDBName(Map userRepo, LDAPConnection ld) throws LDAPException {
        String dbName = null;
        String suffix = (String)userRepo.get("userStoreRootSuffix");
        String filter = "cn=\"" + suffix + "\"";
        LDAPSearchResults results = ld.search("cn=mapping tree,cn=config", 2, filter, null, false);
        while (results.hasMoreElements()) {
            LDAPEntry entry = results.next();
            String dn = entry.getDN();
            LDAPAttributeSet set = entry.getAttributeSet();
            Enumeration e = set.getAttributes();
            while (e.hasMoreElements() && dbName == null) {
                String[] value;
                LDAPAttribute attr = (LDAPAttribute)e.nextElement();
                String name = attr.getName();
                if (!name.equals("nsslapd-backend") || (value = attr.getStringValueArray()).length <= 0) continue;
                dbName = value[0];
            }
        }
        return dbName != null ? dbName : "userRoot";
    }

    static {
        instance = new UserIdRepo();
        ResourceBundle rb = ResourceBundle.getBundle("serviceNames");
        umSunDSForAM = rb.getString("umSunDSForAM");
        umSunDSGeneric = rb.getString("umSunDSGeneric");
    }
}

