/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.ShutdownPriority;
import com.sun.identity.setup.ConfiguratorException;
import com.sun.identity.setup.ServicesDefaultValues;
import com.sun.identity.setup.SetupProgress;
import com.sun.identity.shared.debug.Debug;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.servlet.ServletContext;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import org.opends.guitools.replicationcli.ReplicationCliMain;
import org.opends.messages.Message;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.extensions.SaltedSHA512PasswordStorageScheme;
import org.opends.server.tools.ImportLDIF;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.util.EmbeddedUtils;

public class EmbeddedOpenDS {
    private static boolean serverStarted = false;
    static final String[] preferredTransforms = new String[]{"RSA/ECB/OAEPWithSHA1AndMGF1Padding", "RSA/ /OAEPPADDINGSHA-1", "RSA/ECB/OAEPWithSHA-1AndMGF-1Padding", "RSA/ECB/PKCS1Padding"};
    static final String OPENDS_TRANSFORMATION = "OPENDS_TRANSFORMATION";

    public static boolean isStarted() {
        return serverStarted;
    }

    public static void setup(Map map, ServletContext servletCtx) throws Exception {
        SetupProgress.reportStart("emb.installingemb", null);
        String xform = EmbeddedOpenDS.getSupportedTransformation();
        if (xform == null) {
            SetupProgress.reportEnd("emb.noxform", null);
            throw new Exception("No transformation found");
        }
        map.put(OPENDS_TRANSFORMATION, xform);
        SetupProgress.reportEnd("emb.success", xform);
        String basedir = (String)map.get("BASE_DIR");
        String odsRoot = basedir + "/" + "opends";
        new File(basedir).mkdir();
        new File(odsRoot).mkdir();
        String[] subDirectories = new String[]{"adminDb", "bak", "bin", "changelogDb", "classes", "config", "db", "db_verify", "ldif", "lib", "locks", "logs", "db_rebuild", "db_unindexed", "db_index_test", "db_import_test", "config/schema", "config/upgrade"};
        for (int i = 0; i < subDirectories.length; ++i) {
            new File(odsRoot, subDirectories[i]).mkdir();
        }
        String[] files = new String[]{"config/upgrade/schema.ldif.3883", "config/upgrade/config.ldif.3883", "config/config.ldif", "config/admin-backend.ldif", "config/famsuffix.ldif", "config/schema/00-core.ldif", "config/schema/01-pwpolicy.ldif", "config/schema/02-config.ldif", "config/schema/03-changelog.ldif", "config/schema/03-rfc2713.ldif", "config/schema/03-rfc2714.ldif", "config/schema/03-rfc2739.ldif", "config/schema/03-rfc2926.ldif", "config/schema/03-rfc3112.ldif", "config/schema/03-rfc3712.ldif", "config/schema/03-uddiv3.ldif", "config/schema/04-rfc2307bis.ldif"};
        for (int i = 0; i < files.length; ++i) {
            int len;
            String file = "/WEB-INF/template/opends/" + files[i];
            InputStreamReader fin = new InputStreamReader(servletCtx.getResourceAsStream(file));
            StringBuffer sbuf = new StringBuffer();
            char[] cbuf = new char[1024];
            while ((len = fin.read(cbuf)) > 0) {
                sbuf.append(cbuf, 0, len);
            }
            OutputStreamWriter fout = null;
            try {
                fout = new FileWriter(odsRoot + "/" + files[i]);
                String inpStr = sbuf.toString();
                fout.write(ServicesDefaultValues.tagSwap(inpStr));
                continue;
            }
            catch (IOException e) {
                Debug.getInstance((String)"amSetupServlet").error("EmbeddedOpenDS.setup(). Error loading ldifs:", (Throwable)e);
                throw e;
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception ex) {}
                }
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        SetupProgress.reportStart("emb.installingemb", odsRoot);
        EmbeddedOpenDS.startServer(odsRoot);
        SetupProgress.reportEnd("emb.done", null);
        if (!EmbeddedOpenDS.isMultiServer(map)) {
            SetupProgress.reportStart("emb.creatingfamsuffix", null);
            EmbeddedOpenDS.shutdownServer("to load ldif");
            EmbeddedOpenDS.loadLDIF(odsRoot, odsRoot + "/config/famsuffix.ldif");
            EmbeddedOpenDS.startServer(odsRoot);
            SetupProgress.reportEnd("emb.done", null);
        }
    }

    private static String getSupportedTransformation() {
        for (int i = 0; i < preferredTransforms.length; ++i) {
            try {
                Cipher.getInstance(preferredTransforms[i]);
                return preferredTransforms[i];
            }
            catch (NoSuchAlgorithmException ex) {
                continue;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void startServer(String odsRoot) throws Exception {
        if (EmbeddedOpenDS.isStarted()) {
            return;
        }
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        debug.message("EmbeddedOpenDS.startServer(" + odsRoot + ")");
        DirectoryEnvironmentConfig config = new DirectoryEnvironmentConfig();
        config.setServerRoot(new File(odsRoot));
        config.setForceDaemonThreads(true);
        config.setConfigClass(ConfigFileHandler.class);
        config.setConfigFile(new File(odsRoot + "/config", "config.ldif"));
        debug.message("EmbeddedOpenDS.startServer:starting DS Server...");
        EmbeddedUtils.startServer((DirectoryEnvironmentConfig)config);
        debug.message("...EmbeddedOpenDS.startServer:DS Server started.");
        for (int sleepcount = 0; !EmbeddedUtils.isRunning() && sleepcount < 60; ++sleepcount) {
            SetupProgress.reportStart("emb.waitingforstarted", null);
            Thread.sleep(1000L);
        }
        if (EmbeddedUtils.isRunning()) {
            SetupProgress.reportEnd("emb.success", null);
        } else {
            SetupProgress.reportEnd("emb.failed", null);
        }
        serverStarted = true;
        ShutdownManager shutdownMan = ShutdownManager.getInstance();
        shutdownMan.addShutdownListener(new ShutdownListener(){

            public void shutdown() {
                try {
                    EmbeddedOpenDS.shutdownServer("Graceful Shutdown");
                }
                catch (Exception ex) {
                    Debug debug = Debug.getInstance((String)"amSetupServlet");
                    debug.error("EmbeddedOpenDS:shutdown hook failed", (Throwable)ex);
                }
            }
        }, ShutdownPriority.LOWEST);
    }

    public static void shutdownServer(String reason) throws Exception {
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        if (EmbeddedOpenDS.isStarted()) {
            debug.message("EmbeddedOpenDS.shutdown server...");
            DirectoryServer.shutDown((String)"com.sun.identity.setup.EmbeddedOpenDS", (Message)Message.EMPTY);
            for (int sleepcount = 0; DirectoryServer.isRunning() && sleepcount < 60; ++sleepcount) {
                Thread.sleep(1000L);
            }
            serverStarted = false;
            debug.message("EmbeddedOpenDS.shutdown server success.");
        }
    }

    public static void setupReplication(Map map) throws Exception {
        SetupProgress.reportStart("emb.creatingreplica", null);
        int ret = EmbeddedOpenDS.setupReplicationEnable(map);
        if (ret == 0) {
            ret = EmbeddedOpenDS.setupReplicationInitialize(map);
        }
        if (ret != 0) {
            SetupProgress.reportEnd("emb.failed", new Integer(ret));
            Debug.getInstance((String)"amSetupServlet").error("EmbeddedOpenDS.setupReplication(). Error setting up replication");
            throw new ConfiguratorException("configurator.embreplfailed");
        }
        SetupProgress.reportEnd("emb.success", null);
        Debug.getInstance((String)"amSetupServlet").message("EmbeddedOpenDS.setupReplication(). replication setup succeeded.");
    }

    public static int setupReplicationEnable(Map map) {
        String[] enableCmd = new String[]{"enable", "--no-prompt", "--host1", "host1val", "--port1", "port1ival", "--bindDN1", "cn=Directory Manager", "--bindPassword1", "xxxxxxxx", "--replicationPort1", "8989", "--host2", "host2val", "--port2", "port2ival", "--bindDN2", "cn=Directory Manager", "--bindPassword2", "xxxxxxxx", "--replicationPort2", "8989", "--adminUID", "admin", "--adminPassword", "xxxxxxxx", "--baseDN", "dc=example,dc=com"};
        enableCmd[3] = (String)map.get("DS_EMB_REPL_HOST2");
        enableCmd[5] = (String)map.get("DS_EMB_REPL_PORT2");
        enableCmd[11] = (String)map.get("DS_EMB_REPL_REPLPORT2");
        enableCmd[13] = (String)map.get("DIRECTORY_SERVER");
        enableCmd[15] = (String)map.get("DIRECTORY_PORT");
        enableCmd[21] = (String)map.get("DS_EMB_REPL_REPLPORT1");
        enableCmd[27] = (String)map.get("ROOT_SUFFIX");
        SetupProgress.reportStart("emb.replcommand", EmbeddedOpenDS.concat(enableCmd));
        enableCmd[9] = (String)map.get("DS_DIRMGRPASSWD");
        enableCmd[19] = (String)map.get("DS_DIRMGRPASSWD");
        enableCmd[25] = (String)map.get("DS_DIRMGRPASSWD");
        int ret = ReplicationCliMain.mainCLI((String[])enableCmd, (boolean)false, (OutputStream)SetupProgress.getOutputStream(), (OutputStream)SetupProgress.getOutputStream(), null);
        if (ret == 0) {
            SetupProgress.reportEnd("emb.success", null);
        } else {
            SetupProgress.reportEnd("emb.failed", null);
        }
        return ret;
    }

    public static int setupReplicationInitialize(Map map) {
        String[] initializeCmd = new String[]{"initialize", "--no-prompt", "--baseDN", "dc=opensso,dc=java,dc=net", "--adminUID", "admin", "--adminPassword", "xxxxxxxx", "--hostSource", "localhost", "--portSource", "50389", "--hostDestination", "localhost", "--portDestination", "51389"};
        initializeCmd[3] = (String)map.get("ROOT_SUFFIX");
        initializeCmd[9] = (String)map.get("DS_EMB_REPL_HOST2");
        initializeCmd[11] = (String)map.get("DS_EMB_REPL_PORT2");
        initializeCmd[13] = (String)map.get("DIRECTORY_SERVER");
        initializeCmd[15] = (String)map.get("DIRECTORY_PORT");
        SetupProgress.reportStart("emb.replcommand", EmbeddedOpenDS.concat(initializeCmd));
        initializeCmd[7] = (String)map.get("DS_DIRMGRPASSWD");
        int ret = ReplicationCliMain.mainCLI((String[])initializeCmd, (boolean)false, (OutputStream)SetupProgress.getOutputStream(), (OutputStream)SetupProgress.getOutputStream(), null);
        if (ret == 0) {
            SetupProgress.reportEnd("emb.success", null);
        } else {
            SetupProgress.reportEnd("emb.failed", null);
        }
        return ret;
    }

    public static boolean isMultiServer(Map map) {
        String replFlag = (String)map.get("DS_EMB_REPL_FLAG");
        return replFlag != null && replFlag.startsWith("embReplFlag");
    }

    private static String concat(String[] args) {
        String ret = "";
        for (int i = 0; i < args.length; ++i) {
            ret = ret + args[i] + " ";
        }
        return ret;
    }

    public static void loadLDIF(String odsRoot, String ldif) {
        Debug debug = Debug.getInstance((String)"amSetupServlet");
        try {
            debug.message("EmbeddedOpenDS:loadLDIF(" + ldif + ")");
            String[] args1 = new String[]{"-C", "org.opends.server.extensions.ConfigFileHandler", "-f", odsRoot + "/config/config.ldif", "-n", "userRoot", "-l", ldif, "-Q"};
            ImportLDIF.mainImportLDIF((String[])args1);
            debug.message("EmbeddedOpenDS:loadLDIF Success");
        }
        catch (Exception ex) {
            debug.error("EmbeddedOpenDS:loadLDIF:ex=" + ex);
        }
    }

    public static String hash(String p) {
        String str = null;
        try {
            byte[] bb = p.getBytes();
            str = SaltedSHA512PasswordStorageScheme.encodeOffline((byte[])bb);
        }
        catch (Exception ex) {
            Debug debug = Debug.getInstance((String)"amSetupServlet");
            debug.error("EmbeddedOpenDS.hash failed : ex=" + ex);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReplicationPort(String username, String password, String hostname, String port) {
        String replDN = "cn=replication server,cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config";
        String[] attrs = new String[]{"ds-cfg-replication-port"};
        String replPort = null;
        LDAPConnection ld = null;
        try {
            Enumeration en;
            LDAPAttribute la;
            LDAPEntry le;
            username = "cn=Directory Manager";
            LDAPConnection lc = EmbeddedOpenDS.getLDAPConnection(hostname, port, username, password);
            if (lc != null && (le = lc.read("cn=replication server,cn=Multimaster Synchronization,cn=Synchronization Providers,cn=config", attrs)) != null && (la = le.getAttribute(attrs[0])) != null && (en = la.getStringValues()) != null && en.hasMoreElements()) {
                replPort = (String)en.nextElement();
            }
        }
        catch (Exception ex) {
            Debug.getInstance((String)"amSetupServlet").error("EmbeddedOpenDS.getReplicationPort(). Error getting replication port:", (Throwable)ex);
        }
        finally {
            EmbeddedOpenDS.disconnectDServer(ld);
        }
        return replPort;
    }

    private static LDAPConnection getLDAPConnection(String dsHostName, String dsPort, String dsManager, String dsAdminPwd) {
        LDAPConnection ld = null;
        try {
            int dsPortInt = Integer.parseInt(dsPort);
            ld = new LDAPConnection();
            ld.setConnectTimeout(300);
            ld.connect(3, dsHostName, dsPortInt, dsManager, dsAdminPwd);
        }
        catch (LDAPException ex) {
            Debug.getInstance((String)"amSetupServlet").error("EmbeddedOpenDS.setup(). Error getting LDAPConnection:", (Throwable)ex);
        }
        return ld;
    }

    private static void disconnectDServer(LDAPConnection ld) {
        if (ld != null && ld.isConnected()) {
            try {
                ld.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }
}

