/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.DSConfigMgrBase;
import com.iplanet.services.ldap.IDSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerGroup;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.AMEncryption;
import com.iplanet.services.util.Crypt;
import com.iplanet.services.util.XMLException;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.setup.AMSetupServlet;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;

public class BootstrapCreator {
    private static BootstrapCreator instance = new BootstrapCreator();
    static final String template = "@DS_PROTO@://@DS_HOST@/@INSTANCE_NAME@?pwd=@DSAMEUSER_PWD@&dsbasedn=@BASE_DN@&dsmgr=@BIND_DN@&dspwd=@BIND_PWD@&ver=1.0";

    private BootstrapCreator() {
    }

    public static BootstrapCreator getInstance() {
        return instance;
    }

    public static void updateBootstrap() throws ConfigurationException {
        try {
            DSConfigMgrBase dsCfg = new DSConfigMgrBase();
            dsCfg.parseServiceConfigXML();
            instance.update(dsCfg);
        }
        catch (XMLException e) {
            throw new ConfigurationException(e.getMessage());
        }
        catch (SMSException e) {
            throw new ConfigurationException(e.getMessage());
        }
        catch (SSOException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static void createBootstrap() throws ConfigurationException {
        try {
            instance.update(DSConfigMgr.getDSConfigMgr());
        }
        catch (LDAPServiceException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static String generate(boolean bSSL, String dsHost, String dsPort, String dsameUserPassword, String dsAdmin, String basedn, String dsPassword) throws UnsupportedEncodingException {
        String protocol = bSSL ? "ldaps" : "ldap";
        String dsameUserPwd = Crypt.encode((String)dsameUserPassword, (AMEncryption)Crypt.getHardcodedKeyEncryptor());
        String dsPwd = Crypt.encode((String)dsPassword, (AMEncryption)Crypt.getHardcodedKeyEncryptor());
        String dsHostPort = dsHost + ":" + dsPort;
        String url = template.replaceAll("@DS_PROTO@", protocol);
        url = url.replaceAll("@DS_HOST@", dsHostPort);
        url = url.replaceAll("@INSTANCE_NAME@", URLEncoder.encode(SystemProperties.getServerInstanceName(), "UTF-8"));
        url = url.replaceAll("@DSAMEUSER_PWD@", URLEncoder.encode(dsameUserPwd, "UTF-8"));
        url = url.replaceAll("@BASE_DN@", URLEncoder.encode(basedn, "UTF-8"));
        url = url.replaceAll("@BIND_DN@", URLEncoder.encode(dsAdmin, "UTF-8"));
        url = url.replaceAll("@BIND_PWD@", URLEncoder.encode(dsPwd, "UTF-8"));
        return url;
    }

    private void update(IDSConfigMgr dsCfg) throws ConfigurationException {
        try {
            String bootstrapString = this.getBootStrapURL(dsCfg);
            String baseDir = SystemProperties.get("com.iplanet.services.configpath");
            AMSetupServlet.writeToFile(baseDir + "/" + "bootstrap", bootstrapString);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public String getBootStrapURL(IDSConfigMgr dsCfg) throws ConfigurationException {
        String bootstrapStr = null;
        try {
            ServerInstance svrCfg;
            ServerGroup sg = dsCfg.getServerGroup("sms");
            ServerGroup defaultGroup = dsCfg.getServerGroup("default");
            if (sg == null) {
                sg = defaultGroup;
                svrCfg = dsCfg.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            } else {
                svrCfg = sg.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            }
            ServerInstance userInstance = defaultGroup.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            String dsameUserPwd = Crypt.encode((String)userInstance.getPasswd(), (AMEncryption)Crypt.getHardcodedKeyEncryptor());
            String connDN = svrCfg.getAuthID();
            String connPwd = Crypt.encode((String)svrCfg.getPasswd(), (AMEncryption)Crypt.getHardcodedKeyEncryptor());
            String rootSuffix = svrCfg.getBaseDN();
            Collection serverList = sg.getServersList();
            StringBuffer bootstrap = new StringBuffer();
            Iterator i = serverList.iterator();
            while (i.hasNext()) {
                Server serverObj = (Server)i.next();
                Server.Type connType = serverObj.getConnectionType();
                String proto = connType.equals(Server.Type.CONN_SIMPLE) ? "ldap" : "ldaps";
                String url = template.replaceAll("@DS_PROTO@", proto);
                String host = serverObj.getServerName() + ":" + serverObj.getPort();
                url = url.replaceAll("@DS_HOST@", host);
                url = url.replaceAll("@INSTANCE_NAME@", URLEncoder.encode(SystemProperties.getServerInstanceName(), "UTF-8"));
                url = url.replaceAll("@DSAMEUSER_PWD@", URLEncoder.encode(dsameUserPwd, "UTF-8"));
                url = url.replaceAll("@BASE_DN@", URLEncoder.encode(rootSuffix, "UTF-8"));
                url = url.replaceAll("@BIND_DN@", URLEncoder.encode(connDN, "UTF-8"));
                url = url.replaceAll("@BIND_PWD@", URLEncoder.encode(connPwd, "UTF-8"));
                bootstrap.append(url).append("\n");
            }
            bootstrapStr = bootstrap.toString();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
        return bootstrapStr;
    }
}

