/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.remote;

import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.ResourceResult;
import com.sun.identity.policy.ResourceResults;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.policy.remote.AdvicesHandleableByAMResponse;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyListenerRequest;
import com.sun.identity.policy.remote.PolicyRequest;
import com.sun.identity.policy.remote.PolicyResponse;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.policy.remote.RemoveListenerRequest;
import com.sun.identity.policy.remote.ResourceResultRequest;
import com.sun.identity.session.util.RestrictedTokenHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.stats.Stats;
import com.sun.identity.sm.SMSException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PolicyRequestHandler
implements RequestHandler {
    static final String REQUEST_AUTH_LEVEL = "requestAuthLevel";
    static final String REQUEST_AUTH_SCHEMES = "requestAuthSchemes";
    static final String REQUEST_IP = "requestIp";
    static final String REQUEST_TIME = "requestTime";
    static final String REQUEST_TIME_ZONE = "requestTimeZone";
    static Debug debug = PolicyService.debug;
    static Map policyEvaluators = Collections.synchronizedMap(new HashMap());
    static Map listenerRegistry = Collections.synchronizedMap(new HashMap());
    String policyServiceRevision;

    public ResponseSet process(Vector requests, HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServletContext servletContext) {
        ResponseSet resSet = new ResponseSet("policy");
        int size = requests.size();
        for (int i = 0; i < size; ++i) {
            Request req = (Request)requests.elementAt(i);
            Response res = null;
            try {
                res = this.processRequest(req);
            }
            catch (PolicyEvaluationException pe) {
                PolicyService ps = new PolicyService();
                try {
                    String rev = this.getPolicyServiceRevision();
                    ps.setRevision(rev);
                }
                catch (PolicyEvaluationException pee) {
                    debug.error("PolicyRequesthandler.process can not get service revision number, ,revision defaulting to :0", (Throwable)pee);
                    ps.setRevision("0");
                }
                PolicyResponse pRes = new PolicyResponse();
                pRes.setMethodID(4);
                pRes.setRequestId(pe.getRequestId());
                pRes.setExceptionMsg(pe.getMessage());
                pRes.setIssueInstant(System.currentTimeMillis());
                ps.setMethodID(2);
                ps.setPolicyResponse(pRes);
                res = new Response(ps.toXMLString());
            }
            if (res == null) continue;
            resSet.addResponse(res);
        }
        return resSet;
    }

    private Response processRequest(Request req) throws PolicyEvaluationException {
        String content = req.getContent();
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.processRequest(): content is " + content);
        }
        PolicyService psReq = PolicyService.parseXML(content);
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.processRequest(): policy service object:" + psReq.toXMLString());
        }
        PolicyService psRes = this.processPolicyServiceRequest(psReq);
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.processRequest(): get response from policy framework: \n" + psRes.toXMLString());
        }
        return new Response(psRes.toXMLString());
    }

    private PolicyService processPolicyServiceRequest(PolicyService psReq) throws PolicyEvaluationException {
        PolicyService psRes = null;
        if (psReq == null) {
            debug.error("PolicyRequestHandler.processPolicyServiceRequest():  null psReq");
            throw new PolicyEvaluationException("amPolicy", "invalid_policy_request_type", null, null);
        }
        if (psReq.getMethodID() == 1) {
            PolicyRequest policyReq = psReq.getPolicyRequest();
            if (policyReq == null) {
                debug.error("PolicyRequestHandler.processPolicyServiceRequest():  null policyRequest");
                throw new PolicyEvaluationException("amPolicy", "invalid_policy_request_type", null, null);
            }
            psRes = new PolicyService();
            psRes.setRevision(this.getPolicyServiceRevision());
            PolicyResponse policyRes = this.processPolicyRequest(policyReq);
            policyRes.setIssueInstant(System.currentTimeMillis());
            psRes.setMethodID(2);
            psRes.setPolicyResponse(policyRes);
            return psRes;
        }
        debug.error("PolicyRequestHandler.processPolicyServiceRequest(): invalid policy request type");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_request_type", null, null);
    }

    private PolicyResponse processPolicyRequest(PolicyRequest req) throws PolicyEvaluationException {
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.processPolicyRequest():  req received:\n" + req.toXMLString());
        }
        PolicyResponse policyRes = new PolicyResponse();
        String requestId = req.getRequestId();
        policyRes.setRequestId(requestId);
        String appSSOTokenIDStr = req.getAppSSOToken();
        SSOToken appToken = null;
        try {
            appToken = this.getSSOToken(appSSOTokenIDStr, null);
        }
        catch (PolicyException pe) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyRequestHandler: Invalid app sso token, " + appSSOTokenIDStr);
            }
            throw new PolicyEvaluationException("amPolicy", "app_sso_token_invalid", null, null, requestId);
        }
        if (req.getMethodID() == 2) {
            PolicyListenerRequest plReq = req.getPolicyListenerRequest();
            boolean addListener = this.addPolicyListener(plReq);
            if (addListener) {
                policyRes.setMethodID(2);
            } else {
                Object[] objs = new String[]{plReq.getNotificationURL()};
                String message = ResBundleUtils.getString("failed.add.policy.listener", objs);
                policyRes.setExceptionMsg(message);
                policyRes.setMethodID(4);
            }
            return policyRes;
        }
        if (req.getMethodID() == 3) {
            RemoveListenerRequest rmReq = req.getRemoveListenerRequest();
            boolean removeListener = this.removePolicyListener(rmReq);
            if (removeListener) {
                policyRes.setMethodID(3);
            } else {
                Object[] objs = new String[]{rmReq.getNotificationURL()};
                String message = ResBundleUtils.getString("failed.remove.policy.listener", objs);
                policyRes.setExceptionMsg(message);
                policyRes.setMethodID(4);
            }
            return policyRes;
        }
        if (req.getMethodID() == 4) {
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler: request to get   advicesHandleableByAM");
            }
            try {
                Set advices = PolicyConfig.getAdvicesHandleableByAM();
                policyRes.setAdvicesHandleableByAMResponse(new AdvicesHandleableByAMResponse(advices));
                policyRes.setMethodID(5);
            }
            catch (PolicyException pe) {
                if (debug.warningEnabled()) {
                    debug.warning("PolicyRequestHandler: could not get  advicesHandleableByAM", (Throwable)pe);
                }
                throw new PolicyEvaluationException("amPolicy", "could_not_get_advices_handleable_by_am", null, pe, requestId);
            }
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler: returning   advicesHandleableByAM policy response");
            }
            return policyRes;
        }
        if (req.getMethodID() == 1) {
            ResourceResultRequest resourceResultReq = req.getResourceResultRequest();
            String userSSOTokenIDStr = resourceResultReq.getUserSSOToken();
            SSOToken userToken = null;
            if (userSSOTokenIDStr != null && !userSSOTokenIDStr.equals("") && !userSSOTokenIDStr.equals("null")) {
                try {
                    userToken = this.getSSOToken(userSSOTokenIDStr, appToken);
                }
                catch (PolicyException pe) {
                    if (debug.warningEnabled()) {
                        debug.warning("PolicyRequestHandler: Invalid user sso token, " + userSSOTokenIDStr);
                    }
                    throw new PolicyEvaluationException("amPolicy", "user_sso_token_invalid", null, null, requestId);
                }
            }
            HashSet resourceResults = new HashSet();
            ResourceResults resourceRst = null;
            Set respAttrs = resourceResultReq.getResponseAttributes();
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler.processPolicyRequest(): respAttrs=\n" + respAttrs);
            }
            Map respDecisions = null;
            if (respAttrs != null && userToken != null) {
                respDecisions = this.getResponseDecisions(userToken, respAttrs);
            }
            String serviceName = resourceResultReq.getServiceName();
            String resourceName = resourceResultReq.getResourceName();
            String resourceScope = resourceResultReq.getResourceScope();
            if (resourceScope != null && resourceScope.equals("response-attributes-only")) {
                ResourceResult resResult = new ResourceResult(resourceName, new PolicyDecision());
                HashSet<ResourceResult> results = new HashSet<ResourceResult>();
                results.add(resResult);
                resourceRst = new ResourceResults(results);
            } else {
                Map envParameters = resourceResultReq.getEnvParms();
                try {
                    this.convertEnvParams(envParameters);
                }
                catch (PolicyException pe) {
                    debug.error("PolicyRequestHandler: Invalid env parameters", (Throwable)pe);
                    throw new PolicyEvaluationException("amPolicy", "invalid_env_parameters", null, pe, requestId);
                }
                PolicyEvaluator policyEvaluator = null;
                try {
                    policyEvaluator = this.getPolicyEvaluator(serviceName);
                    resourceRst = new ResourceResults(policyEvaluator.getResourceResults(userToken, resourceName, resourceScope, envParameters));
                    if (debug.messageEnabled()) {
                        debug.message("PolicyRequestHandler.processPolicyRequest(): resource result:\n" + resourceRst.toXML());
                    }
                }
                catch (Exception se) {
                    debug.error("PolicyRequestHandler: Evaluation error", (Throwable)se);
                    throw new PolicyEvaluationException("amPolicy", "evaluation_error", null, se, requestId);
                }
            }
            resourceRst.setResponseDecisions(respDecisions);
            resourceResults.addAll(resourceRst.getResourceResults());
            policyRes.setResourceResults(resourceResults);
            policyRes.setMethodID(1);
            return policyRes;
        }
        debug.error("PolicyRequestHandler: Invalid policy request format");
        throw new PolicyEvaluationException("amPolicy", "invalid_policy_request_format", null, null);
    }

    private Map getResponseDecisions(SSOToken token, Set attrs) throws PolicyEvaluationException {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        Map userAttrMap = null;
        try {
            AMIdentity id = IdUtils.getIdentity(token);
            userAttrMap = id.getAttributes(attrs);
        }
        catch (IdRepoException ie) {
            debug.error("PolicyRequestHandler: failed to get user attributes.", (Throwable)ie);
            throw new PolicyEvaluationException(ie);
        }
        catch (SSOException se) {
            debug.error("PolicyRequestHandler: bad sso token", (Throwable)((Object)se));
            throw new PolicyEvaluationException((Throwable)((Object)se));
        }
        return userAttrMap;
    }

    private boolean addPolicyListener(PolicyListenerRequest policyListenerReq) {
        if (policyListenerReq == null) {
            debug.error("PolicyRequestHandler.addPolicyListener: invalid policy listener request received");
            return false;
        }
        String serviceTypeName = policyListenerReq.getServiceTypeName();
        String notiURL = policyListenerReq.getNotificationURL();
        if (listenerRegistry.containsKey(notiURL)) {
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler.addPolicyListener: policy listener for service " + serviceTypeName + " has already been registered; the notification URL is " + notiURL);
            }
            return true;
        }
        PolicyEvaluator policyEvaluator = null;
        try {
            policyEvaluator = this.getPolicyEvaluator(serviceTypeName);
            if (policyEvaluator != null) {
                policyEvaluator.addPolicyListener(policyListenerReq);
                listenerRegistry.put(notiURL, policyListenerReq);
                if (debug.messageEnabled()) {
                    debug.message("PolicyRequestHandler.addPolicyListener: policy listener for service " + serviceTypeName + " added");
                }
            }
        }
        catch (PolicyException e) {
            debug.error("PolicyRequestHandler.addPolicyListener: failed to add policy change listener", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean removePolicyListener(RemoveListenerRequest removeListenerReq) {
        if (removeListenerReq == null) {
            debug.error("PolicyRequestHandler.removePolicyListener: invalid remove policy listener request received");
            return false;
        }
        String serviceTypeName = removeListenerReq.getServiceName();
        String notiURL = removeListenerReq.getNotificationURL();
        if (!listenerRegistry.containsKey(notiURL)) {
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler.removePolicyListener: policy listener to be removed for service " + serviceTypeName + " has not been registered yet; the notification URL is " + notiURL);
            }
            return true;
        }
        PolicyListener policyListener = (PolicyListener)listenerRegistry.get(notiURL);
        if (policyListener == null) {
            listenerRegistry.remove(notiURL);
            return true;
        }
        PolicyEvaluator policyEvaluator = null;
        try {
            policyEvaluator = this.getPolicyEvaluator(serviceTypeName);
            if (policyEvaluator != null) {
                policyEvaluator.removePolicyListener(policyListener);
                listenerRegistry.remove(notiURL);
                if (debug.messageEnabled()) {
                    debug.message("PolicyRequestHandler.removePolicyListener: policy listener for service " + serviceTypeName + " removed");
                }
            }
        }
        catch (PolicyException e) {
            debug.error("PolicyRequestHandler.removePolicyListener: failed to remove policy change listener", (Throwable)e);
            return false;
        }
        return true;
    }

    private void convertEnvParams(Map envParams) throws PolicyException {
        if (envParams == null || envParams.size() == 0) {
            return;
        }
        Set reqIPSet = (Set)envParams.get(REQUEST_IP);
        String reqIP = null;
        if (reqIPSet != null) {
            if (reqIPSet.size() != 0) {
                Iterator items = reqIPSet.iterator();
                reqIP = (String)items.next();
                envParams.put(REQUEST_IP, reqIP);
            } else {
                envParams.put(REQUEST_IP, null);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.convertEnvParams(): requestIp is " + reqIP);
        }
        Set reqTimeSet = (Set)envParams.get(REQUEST_TIME);
        Long reqTime = null;
        if (reqTimeSet != null) {
            if (reqTimeSet.size() != 0) {
                Iterator items = reqTimeSet.iterator();
                String reqTimeStr = (String)items.next();
                reqTime = new Long(reqTimeStr);
                envParams.put(REQUEST_TIME, reqTime);
            } else {
                envParams.put(REQUEST_TIME, null);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("PolicyRequestHandler.convertEnvParams(): requestTime is " + reqTime);
        }
        try {
            Set reqTimeZoneSet = (Set)envParams.get(REQUEST_TIME_ZONE);
            TimeZone reqTimeZone = null;
            if (reqTimeZoneSet != null) {
                if (reqTimeZoneSet.size() != 0) {
                    Iterator items = reqTimeZoneSet.iterator();
                    String reqTimeZoneStr = (String)items.next();
                    reqTimeZone = TimeZone.getTimeZone(reqTimeZoneStr);
                    envParams.put(REQUEST_TIME_ZONE, reqTimeZone);
                } else {
                    envParams.put(REQUEST_TIME_ZONE, null);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("PolicyRequestHandler.convertEnvParams(): requestTimeZone is " + reqTimeZone);
            }
        }
        catch (Exception e) {
            throw new PolicyException("amPolicy", "invalid_request_time_zone_in_request", null, e);
        }
    }

    private PolicyEvaluator getPolicyEvaluator(String serviceName) throws PolicyException {
        PolicyEvaluator pe = (PolicyEvaluator)policyEvaluators.get(serviceName);
        if (pe == null) {
            try {
                pe = new PolicyEvaluator(serviceName);
            }
            catch (SSOException e) {
                debug.error("PolicyRequestHandler.getPolicyEvaluator(String): failed to get a policy evaluator for service " + serviceName, (Throwable)((Object)e));
                throw new PolicyException("amPolicy", "unable_to_get_an_evaluator", null, (Throwable)((Object)e));
            }
            policyEvaluators.put(serviceName, pe);
        }
        return pe;
    }

    private SSOToken getSSOToken(String idString, SSOToken context) throws PolicyException {
        SSOToken token = null;
        try {
            token = RestrictedTokenHelper.resolveRestrictedToken(idString, context);
        }
        catch (Exception e) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
        return token;
    }

    synchronized String getPolicyServiceRevision() throws PolicyEvaluationException {
        if (this.policyServiceRevision == null) {
            try {
                this.policyServiceRevision = String.valueOf(ServiceTypeManager.getPolicyServiceRevisionNumber());
            }
            catch (SMSException e) {
                debug.error("PolicyRequestHandler.getPolicyServiceRevision():Unable to get policy service revision", (Throwable)e);
                throw new PolicyEvaluationException("amPolicy", "unable_to_get_policy_serivce_revision", null, null);
            }
            catch (PolicyException e) {
                debug.error("PolicyRequestHandler.getPolicyServiceRevision():Unable to get policy service revision", (Throwable)e);
                throw new PolicyEvaluationException("amPolicy", "unable_to_get_policy_serivce_revision", null, null);
            }
            catch (SSOException e) {
                debug.error("PolicyRequestHandler.getPolicyServiceRevision():Unable to get policy service revision", (Throwable)((Object)e));
                throw new PolicyEvaluationException("amPolicy", "unable_to_get_policy_serivce_revision", null, null);
            }
        }
        return this.policyServiceRevision;
    }

    public static void printStats(Stats policyStats) {
        policyStats.record("PolicyRequestHandler:Number of PolicyEvaluators  in  cache : " + policyEvaluators.size());
        policyStats.record("PolicyRequestHandler:Number of policy change  listeners in  cache : " + listenerRegistry.size());
    }
}

