/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SessionPropertyCondition
implements Condition {
    private static final boolean IGNORE_VALUE_CASE_DEFAULT = true;
    private static final String IGNORE_VALUE_CASE_FALSE_STRING = "false";
    private static final String DELIMITER = "|";
    private List propertyNames = new ArrayList();
    private Map properties;
    private static final Debug debug = Debug.getInstance((String)"amPolicy");
    private boolean ignoreValueCase = true;

    public List getPropertyNames() {
        return this.propertyNames;
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.ANY;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return property;
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        this.properties = (HashMap)properties;
        if (properties == null || properties.isEmpty()) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        if (debug.messageEnabled()) {
            debug.message("SessionPropertyCondition.setProperties():properties=" + properties);
        }
        this.properties = properties;
        this.resetIgnoreValueCase();
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        boolean allowed = true;
        if (debug.messageEnabled()) {
            debug.message("SessionPropertyCondition.getConditionDecision():entering, ignoreValueCase= " + this.ignoreValueCase);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            Set names = this.properties.keySet();
            Iterator namesIter = names.iterator();
            block0: while (namesIter.hasNext() && allowed) {
                String name = (String)namesIter.next();
                Set values = (Set)this.properties.get(name);
                if (debug.messageEnabled()) {
                    debug.message("SessionPropertyCondition.getConditionDecision():propertyName = " + name + ",conditionValues = " + values);
                }
                if (name.equals("valueCaseInsensitive") || values == null || values.isEmpty()) continue;
                String sessionValue = token.getProperty(name);
                Set sessionValues = null;
                if (sessionValue != null && sessionValue.indexOf(DELIMITER) != -1) {
                    sessionValues = PolicyUtils.delimStringToSet(sessionValue, DELIMITER);
                }
                if (debug.messageEnabled()) {
                    debug.message("SessionPropertyCondition.getConditionDecision():,sessionValue = " + sessionValue + ",sessionValues = " + sessionValues);
                }
                if (sessionValue == null) {
                    allowed = false;
                    continue;
                }
                if (sessionValues != null) {
                    String splitSessionValue;
                    Iterator sessionValueIter;
                    if (!this.ignoreValueCase) {
                        sessionValueIter = sessionValues.iterator();
                        while (sessionValueIter.hasNext()) {
                            splitSessionValue = (String)sessionValueIter.next();
                            if (!values.contains(splitSessionValue)) continue;
                            continue block0;
                        }
                    } else {
                        sessionValueIter = sessionValues.iterator();
                        while (sessionValueIter.hasNext()) {
                            splitSessionValue = (String)sessionValueIter.next();
                            Iterator valueIter = values.iterator();
                            while (valueIter.hasNext()) {
                                String value = (String)valueIter.next();
                                if (!splitSessionValue.equalsIgnoreCase(value)) continue;
                                continue block0;
                            }
                        }
                    }
                } else if (!this.ignoreValueCase) {
                    if (values.contains(sessionValue)) {
                        continue;
                    }
                } else {
                    Iterator valueIter = values.iterator();
                    while (valueIter.hasNext()) {
                        String value = (String)valueIter.next();
                        if (!sessionValue.equalsIgnoreCase(value)) continue;
                        continue block0;
                    }
                }
                allowed = false;
            }
        } else {
            if (debug.messageEnabled()) {
                debug.message("SessionPropertyCondition.getConditionDecision():no  parameter defined, defaulting allow = true ");
            }
            allowed = true;
        }
        if (debug.messageEnabled()) {
            debug.message("SessionPropertyCondition.getConditionDecision():allowed= " + allowed);
        }
        return new ConditionDecision(allowed);
    }

    public Object clone() {
        SessionPropertyCondition theClone = null;
        try {
            theClone = (SessionPropertyCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }

    private void resetIgnoreValueCase() {
        if (this.properties != null) {
            Set values = (Set)this.properties.get("valueCaseInsensitive");
            if (values != null && !values.isEmpty()) {
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    String value = (String)iter.next();
                    if (IGNORE_VALUE_CASE_FALSE_STRING.equalsIgnoreCase(value.trim())) {
                        this.ignoreValueCase = false;
                        continue;
                    }
                    this.ignoreValueCase = true;
                }
            } else {
                this.ignoreValueCase = true;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SessionPropertyCondition.resetIgnoreValueCase():ignoreValueCase= " + this.ignoreValueCase);
        }
    }
}

