/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.shared.debug.Debug;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class PrefixResourceName
implements ResourceName {
    protected String delimiter = "/";
    private boolean caseSensitive = false;
    protected String wildcard = "*";
    protected String oneLevelWildcard = "-*-";
    protected boolean wildcardEmbedded = false;
    protected boolean oneLevelWildcardEmbedded = false;
    protected int oneLevelWildcardLength;
    protected int wildcardLength;
    private Debug debug = Debug.getInstance((String)"amPolicy");
    private static String PROTO_DELIMITER = "://";
    private static int PROTO_DELIMITER_SIZE = PROTO_DELIMITER.length();

    public void initialize(Map configParams) {
        String oneLevelWildcardConfig;
        String wildcardConfig;
        String caseConfig;
        String delimiterConfig = (String)configParams.get("delimiter");
        if (delimiterConfig != null) {
            this.delimiter = delimiterConfig;
        }
        if ((caseConfig = (String)configParams.get("caseSensitive")) != null) {
            this.caseSensitive = caseConfig.equals("true") ? true : !caseConfig.equals("false");
        }
        if ((wildcardConfig = (String)configParams.get("wildcard")) != null) {
            this.wildcard = wildcardConfig;
        }
        if ((oneLevelWildcardConfig = (String)configParams.get("oneLevelWildcard")) != null) {
            this.oneLevelWildcard = oneLevelWildcardConfig;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("PrefixResourceName:initialize(): delimiter = " + this.delimiter + " wildcard = " + this.wildcard + " oneLevelWildcard = " + this.oneLevelWildcard + " case = " + caseConfig);
        }
        this.oneLevelWildcardLength = this.oneLevelWildcard.length();
        this.wildcardLength = this.wildcard.length();
        if (this.oneLevelWildcard.indexOf(this.wildcard) != -1) {
            this.wildcardEmbedded = true;
        }
        if (this.wildcard.indexOf(this.oneLevelWildcard) != -1) {
            this.oneLevelWildcardEmbedded = true;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("wildcardEmbedded,oneLevelWildcardEmbedded" + this.wildcardEmbedded + "," + this.oneLevelWildcardEmbedded);
        }
    }

    public Set getServiceTypeNames() {
        return null;
    }

    public ResourceMatch compare(String requestResource, String targetResource, boolean wildcardCompare) {
        int len;
        if (requestResource == null && targetResource == null) {
            return ResourceMatch.EXACT_MATCH;
        }
        if (requestResource == null || targetResource == null) {
            return ResourceMatch.NO_MATCH;
        }
        if (!this.caseSensitive) {
            requestResource = requestResource.toLowerCase();
            targetResource = targetResource.toLowerCase();
        }
        while (requestResource.endsWith(this.delimiter)) {
            len = requestResource.length();
            requestResource = requestResource.substring(0, len - 1);
        }
        while (targetResource.endsWith(this.delimiter)) {
            len = targetResource.length();
            targetResource = targetResource.substring(0, len - 1);
        }
        if (this.oneLevelWildcardEmbedded && targetResource.indexOf(this.wildcard) == -1 && targetResource.indexOf(this.oneLevelWildcard) != -1 && wildcardCompare) {
            this.debug.message("PrefixResourceName:compare():invoking one level compare");
            return this.oneLevelWildcardCompare(requestResource, targetResource, wildcardCompare);
        }
        if ((this.wildcardEmbedded || !this.wildcardEmbedded && !this.oneLevelWildcardEmbedded) && targetResource.indexOf(this.oneLevelWildcard) != -1 && wildcardCompare) {
            this.debug.message("PrefixResourceName:compare():invoking one level compare");
            return this.oneLevelWildcardCompare(requestResource, targetResource, wildcardCompare);
        }
        int beginIndex1 = 0;
        int endIndex1 = 0;
        int beginIndex2 = 0;
        int endIndex2 = 0;
        int strlen1 = 0;
        int strlen2 = 0;
        String substr = null;
        strlen1 = requestResource.length();
        strlen2 = targetResource.length();
        endIndex2 = targetResource.indexOf(this.wildcard, beginIndex2);
        if (!wildcardCompare || endIndex2 == -1) {
            if (requestResource.equals(targetResource)) {
                return ResourceMatch.EXACT_MATCH;
            }
            if (targetResource.startsWith(requestResource + this.delimiter)) {
                return ResourceMatch.SUB_RESOURCE_MATCH;
            }
            if (requestResource.startsWith(targetResource + this.delimiter)) {
                return ResourceMatch.SUPER_RESOURCE_MATCH;
            }
            return ResourceMatch.NO_MATCH;
        }
        substr = targetResource.substring(beginIndex2, endIndex2);
        if (endIndex2 > beginIndex2 && !requestResource.startsWith(substr)) {
            if (substr.startsWith(requestResource + this.delimiter)) {
                return ResourceMatch.SUB_RESOURCE_MATCH;
            }
            return ResourceMatch.NO_MATCH;
        }
        beginIndex1 += endIndex2 - beginIndex2;
        if (endIndex2 >= strlen2 - 1) {
            return ResourceMatch.WILDCARD_MATCH;
        }
        beginIndex2 = endIndex2 + 1;
        while ((endIndex2 = targetResource.indexOf(this.wildcard, beginIndex2)) != -1) {
            substr = targetResource.substring(beginIndex2, endIndex2);
            if (endIndex2 > beginIndex2 && (beginIndex1 = requestResource.indexOf(substr, beginIndex1)) == -1) {
                return ResourceMatch.SUB_RESOURCE_MATCH;
            }
            beginIndex1 += endIndex2 - beginIndex2;
            if (endIndex2 >= strlen2 - 1) {
                return ResourceMatch.WILDCARD_MATCH;
            }
            beginIndex2 = endIndex2 + 1;
        }
        substr = targetResource.substring(beginIndex2, strlen2);
        endIndex1 = requestResource.lastIndexOf(substr, strlen1 - 1);
        if (endIndex1 == -1) {
            return ResourceMatch.SUB_RESOURCE_MATCH;
        }
        if (beginIndex1 > endIndex1) {
            return ResourceMatch.SUB_RESOURCE_MATCH;
        }
        beginIndex1 = endIndex1;
        if (strlen1 - beginIndex1 == strlen2 - beginIndex2) {
            return ResourceMatch.WILDCARD_MATCH;
        }
        if ((substr = requestResource.substring(beginIndex1 += strlen2 - beginIndex2, beginIndex1 + 1)).equals(this.delimiter)) {
            return ResourceMatch.SUPER_RESOURCE_MATCH;
        }
        return ResourceMatch.SUB_RESOURCE_MATCH;
    }

    public ResourceMatch oneLevelWildcardCompare(String requestResource, String targetResource, boolean wildcardCompare) {
        StringTokenizer st1 = new StringTokenizer(requestResource, this.delimiter);
        StringTokenizer st2 = new StringTokenizer(targetResource, this.delimiter);
        String[] requestTokens = new String[st1.countTokens()];
        String[] targetTokens = new String[st2.countTokens()];
        int i = 0;
        int j = 0;
        while (st1.hasMoreTokens()) {
            requestTokens[i++] = st1.nextToken();
        }
        while (st2.hasMoreTokens()) {
            targetTokens[j++] = st2.nextToken();
        }
        boolean wildcardMatch = false;
        j = 0;
        i = 0;
        while (i < requestTokens.length) {
            String requestToken = requestTokens[i++];
            if (j < targetTokens.length) {
                String targetToken;
                ResourceMatch matchTokensResult = null;
                if ((matchTokensResult = this.matchTokens(targetToken = this.aggregateWildcard(targetTokens[j++]), requestToken)) == ResourceMatch.NO_MATCH) {
                    return matchTokensResult;
                }
                if (matchTokensResult != ResourceMatch.WILDCARD_MATCH) continue;
                wildcardMatch = true;
                continue;
            }
            if (i <= requestTokens.length) {
                return ResourceMatch.SUPER_RESOURCE_MATCH;
            }
            return ResourceMatch.NO_MATCH;
        }
        if (j < targetTokens.length) {
            if (j == targetTokens.length - 1 && this.aggregateWildcard(targetTokens[j]).equals(this.oneLevelWildcard)) {
                return ResourceMatch.WILDCARD_MATCH;
            }
            return ResourceMatch.SUB_RESOURCE_MATCH;
        }
        if (wildcardMatch) {
            return ResourceMatch.WILDCARD_MATCH;
        }
        return ResourceMatch.EXACT_MATCH;
    }

    private String aggregateWildcard(String targetToken) {
        int len = 0;
        if (targetToken == null || (len = targetToken.length()) == 0) {
            return targetToken;
        }
        char[] oldchars = targetToken.toCharArray();
        char[] newchars = new char[len];
        int i = 0;
        int j = 0;
        int k = 0;
        boolean foundWildcard = false;
        while (i < len) {
            if (targetToken.startsWith(this.oneLevelWildcard, i)) {
                if (!foundWildcard) {
                    k = i;
                    while (i < k + this.oneLevelWildcardLength) {
                        newchars[j++] = oldchars[i++];
                    }
                    foundWildcard = true;
                    continue;
                }
                i += this.oneLevelWildcardLength;
                continue;
            }
            foundWildcard = false;
            newchars[j++] = oldchars[i++];
        }
        return String.valueOf(newchars, 0, j);
    }

    private ResourceMatch matchTokens(String targetToken, String requestToken) {
        int wildcardIndex = 0;
        if (targetToken == null && requestToken == null) {
            return ResourceMatch.EXACT_MATCH;
        }
        if (targetToken == null || requestToken == null) {
            return ResourceMatch.NO_MATCH;
        }
        int beginTargetIndex = 0;
        int beginRequestIndex = 0;
        String substr = null;
        int targetTokenLength = targetToken.length();
        int requestTokenLength = requestToken.length();
        if (targetToken.indexOf(this.oneLevelWildcard, beginTargetIndex) != -1) {
            while ((wildcardIndex = targetToken.indexOf(this.oneLevelWildcard, beginTargetIndex)) != -1) {
                if (wildcardIndex > beginTargetIndex) {
                    substr = targetToken.substring(beginTargetIndex, wildcardIndex);
                    beginRequestIndex = requestToken.indexOf(substr, beginRequestIndex);
                    if (beginRequestIndex == -1) {
                        return ResourceMatch.NO_MATCH;
                    }
                    beginTargetIndex = beginTargetIndex + substr.length() + this.oneLevelWildcardLength;
                    beginRequestIndex += substr.length();
                    continue;
                }
                if (wildcardIndex != beginTargetIndex) continue;
                if (targetTokenLength == this.oneLevelWildcardLength) {
                    return ResourceMatch.WILDCARD_MATCH;
                }
                beginTargetIndex += this.oneLevelWildcardLength;
            }
            if (beginTargetIndex >= targetTokenLength) {
                return ResourceMatch.WILDCARD_MATCH;
            }
            String targetStr = targetToken.substring(beginTargetIndex, targetTokenLength);
            String remRequest = requestToken.substring(beginRequestIndex, requestTokenLength);
            int remRequestIndex = -1;
            remRequestIndex = remRequest.lastIndexOf(targetStr, remRequest.length() - 1);
            if (remRequestIndex == -1) {
                return ResourceMatch.NO_MATCH;
            }
            if ((beginRequestIndex += remRequestIndex) + targetStr.length() >= requestTokenLength) {
                return ResourceMatch.WILDCARD_MATCH;
            }
            return ResourceMatch.NO_MATCH;
        }
        if (targetToken.equals(requestToken)) {
            return ResourceMatch.EXACT_MATCH;
        }
        return ResourceMatch.NO_MATCH;
    }

    public String append(String superResource, String subResource) {
        if (superResource.endsWith(this.delimiter) && subResource.startsWith(this.delimiter)) {
            superResource = superResource.substring(0, superResource.length() - 1);
        }
        if (!superResource.endsWith(this.delimiter) && !subResource.startsWith(this.delimiter)) {
            subResource = this.delimiter + subResource;
        }
        return superResource + subResource;
    }

    public String getSubResource(String resource, String superResource) {
        String subResource = null;
        if (!superResource.endsWith(this.delimiter)) {
            superResource = superResource + this.delimiter;
        }
        if (resource.startsWith(superResource)) {
            subResource = resource.substring(superResource.length());
        }
        return subResource;
    }

    public String[] split(String res) {
        String protocol = "";
        int doubleD = res.indexOf(this.delimiter + this.delimiter);
        if (doubleD != -1) {
            protocol = res.substring(0, doubleD + 2);
            res = res.substring(doubleD + 2);
        }
        StringTokenizer st = new StringTokenizer(res, this.delimiter);
        int n = st.countTokens();
        String[] retVal = new String[n];
        for (int i = 0; i < n; ++i) {
            retVal[i] = st.nextToken();
        }
        retVal[0] = protocol + retVal[0];
        if (res.startsWith(this.delimiter)) {
            retVal[0] = retVal[0] + this.delimiter;
        }
        if (res.endsWith(this.delimiter)) {
            retVal[n - 1] = retVal[n - 1] + this.delimiter;
        }
        return retVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String canonicalize(String res) throws PolicyException {
        boolean errorCondition = false;
        int startOneLevelIndex = res.indexOf(this.oneLevelWildcard);
        int endOneLevelIndex = startOneLevelIndex != -1 ? startOneLevelIndex + this.oneLevelWildcardLength - 1 : -1;
        int startWildcardIndex = res.indexOf(this.wildcard);
        int endWildcardIndex = startWildcardIndex != -1 ? startWildcardIndex + this.wildcardLength - 1 : -1;
        int resLength = res.length();
        boolean oneLevelFound = false;
        if (this.wildcardEmbedded) {
            while (startWildcardIndex != -1 && startWildcardIndex + this.wildcardLength <= resLength) {
                block15: {
                    if (startOneLevelIndex != -1) {
                        if (startWildcardIndex >= startOneLevelIndex && endOneLevelIndex >= endWildcardIndex) {
                            oneLevelFound = true;
                            break block15;
                        } else {
                            errorCondition = true;
                            break;
                        }
                    }
                    if (oneLevelFound) {
                        errorCondition = true;
                        break;
                    }
                }
                startOneLevelIndex = res.indexOf(this.oneLevelWildcard, endOneLevelIndex + 1);
                endOneLevelIndex = startOneLevelIndex != -1 ? startOneLevelIndex + this.oneLevelWildcardLength - 1 : -1;
                startWildcardIndex = res.indexOf(this.wildcard, endWildcardIndex + 1);
                endWildcardIndex = startWildcardIndex != -1 ? startWildcardIndex + this.wildcardLength - 1 : -1;
            }
        }
        boolean wildcardFound = false;
        if (this.oneLevelWildcardEmbedded) {
            while (startOneLevelIndex != -1 && startOneLevelIndex + this.oneLevelWildcardLength <= resLength) {
                block16: {
                    if (startWildcardIndex != -1) {
                        if (startOneLevelIndex >= startWildcardIndex && endWildcardIndex >= endOneLevelIndex) {
                            wildcardFound = true;
                            break block16;
                        } else {
                            errorCondition = true;
                            break;
                        }
                    }
                    if (wildcardFound) {
                        errorCondition = true;
                        break;
                    }
                }
                startOneLevelIndex = res.indexOf(this.oneLevelWildcard, endOneLevelIndex + 1);
                endOneLevelIndex = startOneLevelIndex != -1 ? startOneLevelIndex + this.oneLevelWildcardLength - 1 : -1;
                startWildcardIndex = res.indexOf(this.wildcard, endWildcardIndex + 1);
                endWildcardIndex = startWildcardIndex != -1 ? startWildcardIndex + this.wildcardLength - 1 : -1;
            }
        }
        if (!this.oneLevelWildcardEmbedded && !this.wildcardEmbedded && res.indexOf(this.oneLevelWildcard) != -1 && res.indexOf(this.wildcard) != -1) {
            errorCondition = true;
        }
        if (errorCondition) {
            throw new PolicyException("amPolicy", "both_type_wildcards_unsupported", null, null);
        }
        int idx = res.indexOf(PROTO_DELIMITER);
        if (idx >= 0) {
            String protoString = res.substring(0, idx + PROTO_DELIMITER_SIZE);
            String remainingRes = res.substring(idx + PROTO_DELIMITER_SIZE);
            return protoString + this.purgeNullPath(remainingRes);
        }
        return this.purgeNullPath(res);
    }

    private String purgeNullPath(String res) {
        if (res == null || res.length() == 0) {
            return "";
        }
        boolean preceedingDelimiter = false;
        int len = res.length();
        char[] oldchars = res.toCharArray();
        char[] newchars = new char[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            if (oldchars[i] == this.delimiter.charAt(0)) {
                if (!preceedingDelimiter) {
                    newchars[j++] = oldchars[i++];
                    preceedingDelimiter = true;
                    continue;
                }
                ++i;
                continue;
            }
            newchars[j++] = oldchars[i++];
            preceedingDelimiter = false;
        }
        return String.valueOf(newchars, 0, j);
    }
}

