/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.SubjectEvaluationCache;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

public class LDAPFilterCondition
implements Condition {
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    private static final Debug debug = Debug.getInstance((String)"amPolicy");
    private static List propertyNames = new ArrayList(1);
    private static final String AMPERSAND = "&";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSE_PARENTHESIS = ")";
    private Map properties;
    private String ldapConditionFilter;
    private long policyConfigExpiresAt;
    private String authid;
    private String authpw;
    private String baseDN;
    private String userSearchFilter;
    private int userSearchScope = 2;
    private String userRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private String orgName;
    private LDAPConnectionPool connPool;
    private String ldapServer;
    private boolean aliasEnabled;

    public List getPropertyNames() {
        return Collections.unmodifiableList(propertyNames);
    }

    public Syntax getPropertySyntax(String property) {
        return Syntax.ANY;
    }

    public String getDisplayName(String property, Locale locale) throws PolicyException {
        return property;
    }

    public Set getValidValues(String property) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map properties) throws PolicyException {
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.setProperties():properties=" + properties);
        }
        this.validateProperties(properties);
        this.properties = properties;
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.setProperties():ldapConditionFilter=" + this.ldapConditionFilter);
        }
    }

    public Map getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public ConditionDecision getConditionDecision(SSOToken token, Map env) throws PolicyException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.getConditionDecision():entering:principalDN=" + token.getPrincipal().getName() + ":ldapConditionFilter=" + this.ldapConditionFilter);
        }
        boolean allowed = true;
        this.resetPolicyConfig(env);
        allowed = this.isMember(token);
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.getConditionDecision():allowed= " + allowed);
        }
        return new ConditionDecision(allowed);
    }

    private boolean isMember(SSOToken token) throws SSOException, PolicyException {
        boolean member = false;
        boolean listenerAdded = false;
        String userLocalDN = token.getPrincipal().getName();
        String tokenID = ((Object)token.getTokenID()).toString();
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.isMember(): userLocalDN from ssoToken is: " + userLocalDN);
        }
        Boolean matchFound = null;
        matchFound = SubjectEvaluationCache.isMember(tokenID, this.ldapServer, this.ldapConditionFilter);
        if (matchFound != null) {
            boolean result;
            if (debug.messageEnabled()) {
                debug.message("LDAPFilterCondition.isMember():Got membership from cache userLocalDN: " + userLocalDN + ", ldapConditionFilter: " + this.ldapConditionFilter + " , member:" + matchFound);
            }
            if (result = matchFound.booleanValue()) {
                return result;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition:isMember(): ldapConditionFilter:" + this.ldapConditionFilter + " not in subject evaluation cache, " + " fetching from directory server.");
        }
        int beginIndex = userLocalDN.indexOf("=");
        int endIndex = userLocalDN.indexOf(",");
        if (beginIndex <= 0 || endIndex <= 0 || beginIndex >= endIndex) {
            throw new PolicyException("amPolicy", "ldapusers_subject_invalid_local_user_dn", null, null);
        }
        String userName = userLocalDN.substring(beginIndex + 1, endIndex);
        String userMappingFilter = PolicyUtils.constructUserFilter(token, this.userRDNAttrName, userName, this.aliasEnabled);
        boolean multipleFilters = false;
        String searchFilter = null;
        if (this.userSearchFilter != null && !this.userSearchFilter.equals("")) {
            searchFilter = this.trimAndParenthesise(this.userSearchFilter) + this.trimAndParenthesise(userMappingFilter);
            multipleFilters = true;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.getConditionDecision():  user search filter is: " + this.userSearchFilter);
            debug.message("LDAPFilterCondition.getConditionDecision():  user mapping filter is: " + userMappingFilter);
            debug.message("LDAPFilterCondition.getConditionDecision():  condition ldapConditionFilter is: " + this.ldapConditionFilter);
        }
        if (this.ldapConditionFilter != null && this.ldapConditionFilter.length() != 0) {
            multipleFilters = true;
            searchFilter = searchFilter + this.trimAndParenthesise(this.ldapConditionFilter);
        }
        if (multipleFilters) {
            searchFilter = this.trimAndParenthesise(AMPERSAND + searchFilter);
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.getConditionDecision():  combined filter : " + searchFilter);
        }
        member = this.searchFilterSatisfied(searchFilter);
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition:isMember(): caching result, searchFilter:" + searchFilter + ", member:" + member);
        }
        SubjectEvaluationCache.addEntry(tokenID, this.ldapServer, this.ldapConditionFilter, member);
        if (!listenerAdded && !PolicyEvaluator.ssoListenerRegistry.containsKey(tokenID)) {
            token.addSSOTokenListener(PolicyEvaluator.ssoListener);
            PolicyEvaluator.ssoListenerRegistry.put(tokenID, PolicyEvaluator.ssoListener);
            if (debug.messageEnabled()) {
                debug.message("LDAPFilterCondition.isMember(): sso listener added .\n");
            }
            listenerAdded = true;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.isMember():member=" + member);
        }
        return member;
    }

    private boolean searchFilterSatisfied(String searchFilter) throws SSOException, PolicyException {
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.searchFilterSatified():entering, searchFitler=" + searchFilter);
        }
        boolean filterSatisfied = false;
        String[] attrs = new String[]{this.userRDNAttrName};
        LDAPConnection ld = this.connPool.getConnection();
        LDAPSearchConstraints constraints = ld.getSearchConstraints();
        constraints.setMaxResults(this.maxResults);
        constraints.setServerTimeLimit(this.timeLimit);
        try {
            ld.authenticate(this.authid, this.authpw);
            LDAPSearchResults res = ld.search(this.baseDN, this.userSearchScope, searchFilter, attrs, false, constraints);
            if (res.hasMoreElements()) {
                filterSatisfied = true;
            }
        }
        catch (LDAPException lde) {
            int ldapErrorCode = lde.getLDAPResultCode();
            if (ldapErrorCode == 49) {
                throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
            }
            if (ldapErrorCode == 32) {
                Object[] objs = new String[]{this.baseDN};
                throw new PolicyException("amPolicy", "no_such_ldap_users_base_dn", objs, null);
            }
            String errorMsg = lde.getLDAPErrorMessage();
            String additionalMsg = lde.errorCodeToString();
            if (additionalMsg != null) {
                throw new PolicyException(errorMsg + ": " + additionalMsg);
            }
            throw new PolicyException(errorMsg);
        }
        finally {
            this.connPool.close(ld);
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.searchFilterSatified():returning, filterSatisfied=" + filterSatisfied);
        }
        return filterSatisfied;
    }

    private void resetPolicyConfig(Map env) throws PolicyException {
        if (System.currentTimeMillis() > this.policyConfigExpiresAt) {
            Map policyConfigParams = (Map)env.get("sun.am.policyConfig");
            this.setPolicyConfig(policyConfigParams);
        }
    }

    private synchronized void setPolicyConfig(Map configParams) throws PolicyException {
        if (System.currentTimeMillis() < this.policyConfigExpiresAt) {
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.setPolicyConfig():policy config expired, resetting");
        }
        if (configParams == null) {
            debug.error("LDAPFilterCondition.setPolicyConfig():configParams is null");
            throw new PolicyException("amPolicy", "ldapfiltercondition_setpolicyconfig_null_policy_config", null, null);
        }
        String configuredLdapServer = (String)configParams.get("iplanet-am-policy-config-ldap-server");
        if (configuredLdapServer == null) {
            debug.error("LDAPFilterCondition.initialize(): failed to get LDAP server name. If you enter more than one server name in the policy config service's Primary LDAP Server field, please make sure the ldap server name is preceded with the local server name.");
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        this.ldapServer = configuredLdapServer.toLowerCase();
        this.aliasEnabled = Boolean.valueOf((String)configParams.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)configParams.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)configParams.get("iplanet-am-policy-config-ldap-bind-password");
        if (this.authpw != null) {
            this.authpw = PolicyUtils.decrypt(this.authpw);
        }
        this.baseDN = (String)configParams.get("iplanet-am-policy-config-ldap-users-base-dn");
        this.userSearchFilter = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-filter");
        String scope = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = scope.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (scope.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)configParams.get("iplanet-am-policy-config-ldap-users-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)configParams.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException nfe) {
            throw new PolicyException(nfe);
        }
        String ssl = (String)configParams.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = ssl.equalsIgnoreCase("true");
        Set orgNameSet = (Set)configParams.get("OrganizationName");
        if (orgNameSet != null && orgNameSet.size() != 0) {
            Iterator items = orgNameSet.iterator();
            this.orgName = (String)items.next();
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPFilterCondition.setPolicyConfig(): getting params\nldapServer: " + this.ldapServer + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(this.ldapServer, this.authid, this.authpw, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(this.ldapServer);
        this.policyConfigExpiresAt = System.currentTimeMillis() + PolicyConfig.getSubjectsResultTtl(configParams);
    }

    private boolean validateProperties(Map properties) throws PolicyException {
        if (properties == null || properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_can_not_be_null_or_empty", null, null);
        }
        Set keySet = properties.keySet();
        if (!keySet.contains("ldapFilter")) {
            Object[] args = new String[]{"ldapFilter"};
            throw new PolicyException("amPolicy", "property_value_not_defined", args, null);
        }
        Iterator keys = keySet.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if ("ldapFilter".equals(key)) continue;
            Object[] args = new String[]{key};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property", args, null);
        }
        Set ldapFilterSet = (Set)properties.get("ldapFilter");
        if (ldapFilterSet != null) {
            this.validateLdapFilterSet(ldapFilterSet);
        }
        return true;
    }

    private boolean validateLdapFilterSet(Set ldapFilterSet) throws PolicyException {
        if (ldapFilterSet.isEmpty()) {
            Object[] args = new String[]{"ldapFilter"};
            throw new PolicyException("amPolicy", "property_does_not_allow_empty_values", args, null);
        }
        if (ldapFilterSet.size() > 1) {
            Object[] args = new String[]{"ldapFilter"};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", args, null);
        }
        try {
            this.ldapConditionFilter = (String)ldapFilterSet.iterator().next();
        }
        catch (ClassCastException e) {
            Object[] args = new String[]{"ldapFilter"};
            throw new PolicyException("amPolicy", "property_is_not_a_String", args, null);
        }
        return true;
    }

    private String trimAndParenthesise(String str) {
        String parenthesisedString = str;
        if (str != null) {
            if (!(str = str.trim()).startsWith(OPEN_PARENTHESIS)) {
                parenthesisedString = OPEN_PARENTHESIS + str + CLOSE_PARENTHESIS;
            }
        } else {
            parenthesisedString = "()";
        }
        return parenthesisedString;
    }

    public Object clone() {
        LDAPFilterCondition theClone = null;
        try {
            theClone = (LDAPFilterCondition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this.properties != null) {
            theClone.properties = new HashMap();
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                HashSet values = new HashSet();
                values.addAll((Set)this.properties.get(o));
                theClone.properties.put(o, values);
            }
        }
        return theClone;
    }

    static {
        propertyNames.add("ldapFilter");
    }
}

