/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyCache;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

class SharedSubject
implements Subject,
Cloneable {
    String subjectName;
    SubjectTypeManager stm;
    SubjectTypeManager mstm;
    private static final Debug debug = PolicyManager.debug;

    SharedSubject(String subjectName, SubjectTypeManager stm) {
        this.subjectName = subjectName;
        this.stm = stm;
    }

    public Syntax getValueSyntax(SSOToken token) throws SSOException, PolicyException {
        return this.stm.getSubjectByName(this.subjectName).getValueSyntax(token);
    }

    public ValidValues getValidValues(SSOToken token) throws SSOException, PolicyException {
        return this.stm.getSubjectByName(this.subjectName).getValidValues(token);
    }

    public ValidValues getValidValues(SSOToken token, String pattern) throws SSOException, PolicyException {
        return this.stm.getSubjectByName(this.subjectName).getValidValues(token, pattern);
    }

    public String getDisplayNameForValue(String value, Locale locale) throws NameNotFoundException {
        Subject subject = null;
        try {
            subject = this.stm.getSubjectByName(this.subjectName);
        }
        catch (PolicyException pe) {
            Object[] objs = new String[]{this.subjectName};
            throw new NameNotFoundException("amPolicy", "realm_subject_not_found", objs, this.subjectName, 5);
        }
        if (subject != null) {
            return subject.getDisplayNameForValue(value, locale);
        }
        Object[] objs = new String[]{this.subjectName};
        throw new NameNotFoundException("amPolicy", "realm_subject_not_found", objs, this.subjectName, 5);
    }

    public Set getValues() {
        Subject subject;
        block3: {
            subject = null;
            try {
                subject = this.stm.getSubjectByName(this.subjectName);
            }
            catch (PolicyException pe) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("Could not find realm subject :" + this.subjectName + " could not getValues()", (Throwable)pe);
            }
        }
        if (subject != null) {
            return subject.getValues();
        }
        return Collections.EMPTY_SET;
    }

    public void initialize(Map configParams) throws PolicyException {
    }

    public void setValues(Set names) throws InvalidNameException {
        throw new InvalidNameException("amPolicy", "can_not_set_values_in_shared_subject", null, "ALL", 10);
    }

    public boolean isMember(SSOToken token) throws SSOException, PolicyException {
        Subject subject;
        boolean member = false;
        if (this.mstm == null) {
            String realmName = this.stm.getPolicyManager().getOrganizationDN();
            this.mstm = PolicyCache.getInstance().getPolicyManager(realmName).getSubjectTypeManager();
        }
        if ((subject = this.mstm.getCachedSubjectByName(this.subjectName)) != null) {
            member = subject.isMember(token);
        } else if (debug.warningEnabled()) {
            debug.warning("Realm subject: " + this.subjectName + " not found");
        }
        return member;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public Object clone() {
        Object theClone = null;
        try {
            theClone = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return theClone;
    }
}

