/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.ResponseProvider;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.PluginSchema;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ResponseProviderTypeManager {
    private static String RESPONSE_PROVIDER = "ResponseProvider";
    private SSOToken token;
    private PolicyManager pm;
    private ResourceBundle rb;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private static Debug debug = PolicyManager.debug;

    ResponseProviderTypeManager() throws SSOException {
        this.token = ServiceTypeManager.getSSOToken();
        String lstr = this.token.getProperty("Locale");
        java.util.Locale loc = Locale.getLocale((String)lstr);
        this.rb = amCache.getResBundle("amPolicy", loc);
    }

    public ResponseProviderTypeManager(PolicyManager pm) {
        java.util.Locale loc;
        this.pm = pm;
        this.token = pm.token;
        try {
            String lstr = this.token.getProperty("Locale");
            loc = Locale.getLocale((String)lstr);
        }
        catch (SSOException ex) {
            debug.error("ResponseProviderTypeManager:Unable to retreive locale from SSOToken", (Throwable)((Object)ex));
            loc = Locale.getDefaultLocale();
        }
        if (debug.messageEnabled()) {
            debug.message("ResponseProviderTypeManager locale=" + loc + "\tI18nFileName = " + "amPolicy");
        }
        this.rb = amCache.getResBundle("amPolicy", loc);
    }

    public Set getResponseProviderTypeNames() throws SSOException, PolicyException {
        return PolicyManager.getPluginSchemaNames(RESPONSE_PROVIDER);
    }

    public Set getSelectedResponseProviderTypeNames() throws SSOException, PolicyException {
        Object answer;
        String org = this.pm.getOrganizationDN();
        Map map = PolicyConfig.getPolicyConfig(org);
        if (map != null && (answer = map.get("sun-am-policy-selected-responseproviders")) != null) {
            return (Set)answer;
        }
        return Collections.EMPTY_SET;
    }

    public String getResponseProviderTypeName(ResponseProvider respProvider) {
        return ResponseProviderTypeManager.responseProviderTypeName(respProvider);
    }

    public static String responseProviderTypeName(ResponseProvider respProvider) {
        if (respProvider == null) {
            return null;
        }
        String name = null;
        String className = respProvider.getClass().getName();
        Iterator items = PolicyManager.getPluginSchemaNames(RESPONSE_PROVIDER).iterator();
        while (items.hasNext()) {
            String pluginName = (String)items.next();
            PluginSchema ps = PolicyManager.getPluginSchema(RESPONSE_PROVIDER, pluginName);
            if (!className.equals(ps.getClassName())) continue;
            name = pluginName;
            break;
        }
        return name;
    }

    protected String getI18NPropertiesFileName(String responseProviderTypeName) {
        PluginSchema ps = PolicyManager.getPluginSchema(RESPONSE_PROVIDER, responseProviderTypeName);
        if (ps != null) {
            return ps.getI18NFileName();
        }
        return null;
    }

    public String getI18NKey(String responseProviderName) {
        PluginSchema ps = PolicyManager.getPluginSchema(RESPONSE_PROVIDER, responseProviderName);
        if (ps != null) {
            return ps.getI18NKey();
        }
        return null;
    }

    public String getDisplayName(String responseProviderTypeName) {
        String displayName = null;
        String i18nKey = this.getI18NKey(responseProviderTypeName);
        displayName = i18nKey == null || i18nKey.length() == 0 ? responseProviderTypeName : Locale.getString((ResourceBundle)this.rb, (String)i18nKey, (Debug)debug);
        return displayName;
    }

    public ResponseProvider getResponseProvider(String responseProviderTypeName) throws NameNotFoundException, PolicyException {
        PluginSchema ps = PolicyManager.getPluginSchema(RESPONSE_PROVIDER, responseProviderTypeName);
        if (ps == null) {
            throw new NameNotFoundException("amPolicy", "invalid_response_provider", null, responseProviderTypeName, 7);
        }
        ResponseProvider respProvider = null;
        try {
            String className = ps.getClassName();
            respProvider = (ResponseProvider)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
        respProvider.initialize(this.pm.getPolicyConfig());
        return respProvider;
    }

    public String getViewBeanURL(ResponseProvider respProvider) {
        return PolicyManager.getViewBeanURL(RESPONSE_PROVIDER, respProvider.getClass().getName());
    }
}

