/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvaluatorFactory;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.sm.ServiceManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import netscape.ldap.util.DN;

public class ProxyPolicyEvaluator {
    private static final String TOP_LEVEL_ADMIN_ROLE = "cn=Top-level Admin Role,";
    private static final String TOP_LEVEL_POLICY_ADMIN_ROLE = "cn=Top-level Policy Admin Role,";
    private static final String ORG_ADMIN_ROLE = "cn=Organization Admin Role,";
    private static final String ORG_POLICY_ADMIN_ROLE = "cn=Organization Policy Admin Role,";
    private SSOToken adminToken;
    private AMUser adminUser;
    private String serviceType;
    private PolicyEvaluator policyEvaluator;
    private static String baseDNString = ServiceManager.getBaseDN();
    private static DN baseDN = new DN(baseDNString);

    ProxyPolicyEvaluator(SSOToken token, String serviceType) throws NoPermissionException, NameNotFoundException, PolicyException, SSOException {
        SSOTokenManager.getInstance().validateToken(token);
        this.adminToken = token;
        this.serviceType = serviceType;
        AMStoreConnection conn = new AMStoreConnection(this.adminToken);
        this.adminUser = conn.getUser(this.adminToken.getPrincipal().getName());
        this.policyEvaluator = PolicyEvaluatorFactory.getInstance().getPolicyEvaluator(token, serviceType);
    }

    public boolean isAllowed(String principalName, String resourceName, String actionName, Map env) throws PolicyException, SSOException {
        SSOToken token = this.getProxyToken(principalName);
        boolean allowed = this.policyEvaluator.isAllowed(token, resourceName, actionName, env);
        return allowed;
    }

    public PolicyDecision getPolicyDecision(String principalName, String resourceName, Map env) throws PolicyException, SSOException {
        String decision;
        SSOToken token = this.getProxyToken(principalName);
        PolicyDecision pd = this.policyEvaluator.getPolicyDecision(token, resourceName, null, env);
        if (PolicyUtils.logStatus && (decision = pd.toString()) != null && decision.length() != 0) {
            String[] objs = new String[]{this.adminToken.getPrincipal().getName(), principalName, resourceName, decision};
            PolicyUtils.logAccessMessage("PROXIED_POLICY_EVALUATION", objs, this.adminToken);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message(" Admin: " + this.adminToken.getPrincipal().getName() + " got policy decision " + " for principal: " + token.getPrincipal().getName() + " for resourceName:" + resourceName + " for serviceType :" + this.serviceType + " is " + pd);
        }
        return pd;
    }

    public PolicyDecision getPolicyDecisionIgnoreSubjects(String resourceName, Set actionNames, Map env) throws PolicyException, SSOException {
        String decision;
        PolicyDecision pd = this.policyEvaluator.getPolicyDecisionIgnoreSubjects(resourceName, actionNames, env);
        if (PolicyUtils.logStatus && (decision = pd.toString()) != null && decision.length() != 0) {
            String[] objs = new String[]{this.adminToken.getPrincipal().getName(), resourceName, decision};
            PolicyUtils.logAccessMessage("PROXIED_POLICY_EVALUATION_IGNORING_SUBJECTS", objs, this.adminToken);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message(" Admin: " + this.adminToken.getPrincipal().getName() + " got policy decision " + " ignoring subjects " + " for resourceName:" + resourceName + " for serviceType :" + this.serviceType + " is " + pd);
        }
        return pd;
    }

    public Set getProtectedResourcesIgnoreConditions(String principalName, String rootResource) throws PolicyException, SSOException {
        SSOToken token = this.getProxyToken(principalName);
        return this.policyEvaluator.getProtectedResourcesIgnoreConditions(token, rootResource);
    }

    private SSOToken getProxyToken(String principalName) throws PolicyException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.adminToken);
        SSOToken token = null;
        boolean proxyPermission = false;
        try {
            AuthContextLocal ac = AuthUtils.getAuthContext(baseDNString);
            ac.login(AuthContext.IndexType.USER, principalName, true);
            token = ac.getSSOToken();
        }
        catch (AuthException ae) {
            throw new PolicyException((Throwable)((Object)ae));
        }
        catch (LoginException le) {
            throw new PolicyException(le);
        }
        if (token == null) {
            throw new SSOException(new PolicyException("amPolicy", "can_not_get_proxy_sso_token", null, null));
        }
        try {
            AMStoreConnection conn = new AMStoreConnection(this.adminToken);
            AMUser user = conn.getUser(token.getPrincipal().getName());
            String userOrg = user.getOrganizationDN();
            DN userOrgDN = new DN(userOrg);
            Set adminRoles = this.adminUser.getRoleDNs();
            String roleOrg = null;
            DN roleOrgDN = null;
            Iterator roleIter = adminRoles.iterator();
            while (roleIter.hasNext()) {
                String role = (String)roleIter.next();
                if (role.startsWith(TOP_LEVEL_ADMIN_ROLE)) {
                    roleOrg = role.substring(TOP_LEVEL_ADMIN_ROLE.length());
                    roleOrgDN = new DN(roleOrg);
                    if (!roleOrgDN.equals(baseDN)) continue;
                    proxyPermission = true;
                    break;
                }
                if (role.startsWith(TOP_LEVEL_POLICY_ADMIN_ROLE)) {
                    roleOrg = role.substring(TOP_LEVEL_POLICY_ADMIN_ROLE.length());
                    roleOrgDN = new DN(roleOrg);
                    if (!roleOrgDN.equals(baseDN)) continue;
                    proxyPermission = true;
                    break;
                }
                if (role.startsWith(ORG_ADMIN_ROLE)) {
                    roleOrg = role.substring(ORG_ADMIN_ROLE.length());
                    roleOrgDN = new DN(roleOrg);
                    if (!userOrgDN.equals(roleOrgDN) && !userOrgDN.isDescendantOf(roleOrgDN)) continue;
                    proxyPermission = true;
                    break;
                }
                if (!role.startsWith(ORG_POLICY_ADMIN_ROLE) || !userOrgDN.equals(roleOrgDN = new DN(roleOrg = role.substring(ORG_POLICY_ADMIN_ROLE.length()))) && !userOrgDN.isDescendantOf(roleOrgDN)) continue;
                proxyPermission = true;
                break;
            }
            if (!proxyPermission) {
                SSOTokenManager.getInstance().destroyToken(token);
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Admin : " + this.adminToken.getPrincipal().getName() + " can not create proxy sso token for user " + principalName);
                }
                throw new PolicyException("amPolicy", "no_permission_to_create_proxy_sso_token", null, null);
            }
        }
        catch (AMException ae) {
            throw new PolicyException(ae);
        }
        return token;
    }
}

