/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ValidationErrorHandler;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLHandler;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSEntry;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class PolicyUtils {
    public static boolean logStatus = false;
    public static final String EMPTY_STRING = "";
    public static final String NULL_STRING = "null";
    public static final String NEW_LINE = "\n";
    public static final String ADVICES_TAG_NAME = "Advices";
    public static final String ADVICES_START_TAG = "<Advices>";
    public static final String ADVICES_END_TAG = "</Advices>";
    private static LogMessageProvider msgProvider;
    private static Logger accessLogger;
    private static Logger errorLogger;
    static final String ENV_PARAMETERS = "EnvParameters";
    static final String GET_RESPONSE_DECISIONS = "GetResponseDecisions";
    static final String ATTRIBUTE_VALUE_PAIR = "AttributeValuePair";
    static final String ATTRIBUTE_VALUE_PAIR_BEGIN = "<AttributeValuePair>";
    static final String ATTRIBUTE_VALUE_PAIR_END = "</AttributeValuePair>";
    static final String ATTRIBUTE = "Attribute";
    static final String ATTRIBUTE_NAME = "name";
    static final String VALUE = "Value";
    static final String VALUE_BEGIN = "<Value>";
    static final String VALUE_END = "</Value>";
    static final String ATTRIBUTE_NAME_BEGIN = "<Attribute name=";
    static final String ATTRIBUTE_NAME_END = "/>";
    static final String CRLF = "\r\n";

    static Map addMapToMap(Map mapToAdd, Map toMap) {
        if (mapToAdd != null && toMap != null) {
            Set keySet = mapToAdd.keySet();
            Iterator keyIter = keySet.iterator();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                Set values = (Set)mapToAdd.get(key);
                PolicyUtils.addElementToMap(key, values, toMap);
            }
        }
        return toMap;
    }

    public static Map appendMapToMap(Map mapToAdd, Map toMap) {
        if (mapToAdd != null && toMap != null) {
            Set keySet = mapToAdd.keySet();
            Iterator keyIter = keySet.iterator();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                Set values = (Set)mapToAdd.get(key);
                PolicyUtils.appendElementToMap(key, values, toMap);
            }
        }
        return toMap;
    }

    static Map addElementToMap(String key, Set values, Map toMap) {
        if (key != null && toMap != null) {
            toMap.put(key, values);
        }
        return toMap;
    }

    public static Map appendElementToMap(String key, Set values, Map toMap) {
        if (key != null && values != null && !values.isEmpty() && toMap != null) {
            Set previousValues = (Set)toMap.get(key);
            if (previousValues != null && !previousValues.isEmpty()) {
                previousValues.addAll(values);
            } else {
                toMap.put(key, values);
            }
        }
        return toMap;
    }

    public static String getDisplayName(String dn) {
        String[] componentValues = LDAPDN.explodeDN((String)dn, (boolean)true);
        return componentValues.length > 0 ? componentValues[0] : EMPTY_STRING;
    }

    static PolicyDecision appendPolicyDecisionToPolicyDecision(PolicyDecision pd1, PolicyDecision pd2) throws PolicyException {
        Map actionDecisions = pd1.getActionDecisions();
        Iterator actionNames = actionDecisions.keySet().iterator();
        while (actionNames.hasNext()) {
            String actionName = (String)actionNames.next();
            ActionDecision actionDecision = (ActionDecision)actionDecisions.get(actionName);
            pd2.addActionDecision(actionDecision);
        }
        return pd2;
    }

    public static Map parseEnvParameters(Node pNode) throws PolicyException {
        Node node = null;
        Set nodeSet = XMLUtils.getChildNodes((Node)pNode, (String)ATTRIBUTE_VALUE_PAIR);
        if (nodeSet == null) {
            PolicyManager.debug.error("parseEnvParameters: missing element AttributeValuePair");
            Object[] objs = new String[]{ATTRIBUTE_VALUE_PAIR};
            throw new PolicyException("amPolicy", "missing_element", objs, null);
        }
        HashMap<String, Set> envParams = new HashMap<String, Set>();
        Iterator nodes = nodeSet.iterator();
        while (nodes.hasNext()) {
            node = (Node)nodes.next();
            String attributeName = PolicyUtils.getAttributeName(node);
            if (attributeName == null) {
                PolicyManager.debug.error("PolicyUtils.parseEnvParameters(): missing attribute name");
                Object[] objs = new String[]{ATTRIBUTE_NAME};
                throw new PolicyException("amPolicy", "missing_attribute", objs, null);
            }
            Set values = PolicyUtils.getAttributeValues(node);
            if (values == null) {
                PolicyManager.debug.error("PolicyUtils.parseEnvParameters(): missing attribute value");
                Object[] objs = new String[]{VALUE};
                throw new PolicyException("amPolicy", "missing_attribute", objs, null);
            }
            envParams.put(attributeName, values);
        }
        return envParams;
    }

    public static Set parseResponseAttributes(Node pNode) throws PolicyException {
        Set nodeSet = XMLUtils.getChildNodes((Node)pNode, (String)ATTRIBUTE);
        if (nodeSet == null) {
            PolicyManager.debug.error("parseResponseAttributes:  missing element Attribute");
            Object[] objs = new String[]{ATTRIBUTE};
            throw new PolicyException("amPolicy", "missing_element", objs, null);
        }
        HashSet<String> attrs = new HashSet<String>();
        Node node = null;
        Iterator nodes = nodeSet.iterator();
        while (nodes.hasNext()) {
            node = (Node)nodes.next();
            String attrName = XMLUtils.getNodeAttributeValue((Node)node, (String)ATTRIBUTE_NAME);
            if (attrName == null) {
                PolicyManager.debug.error("parseResponseAttributes:  missing attribute name");
                Object[] objs = new String[]{ATTRIBUTE_NAME};
                throw new PolicyException("amPolicy", "missing_attribute", objs, null);
            }
            attrs.add(attrName);
        }
        return attrs;
    }

    public static Map parseAttributeValuePairs(Node pNode) {
        Node node = null;
        Set nodeSet = XMLUtils.getChildNodes((Node)pNode, (String)ATTRIBUTE_VALUE_PAIR);
        if (nodeSet == null) {
            PolicyManager.debug.error("parseAttribiteValuePairs: missing element AttributeValuePair");
            return null;
        }
        HashMap<String, Set> attrValuePairs = new HashMap<String, Set>();
        Iterator nodes = nodeSet.iterator();
        while (nodes.hasNext()) {
            node = (Node)nodes.next();
            String attributeName = PolicyUtils.getAttributeName(node);
            if (attributeName == null) {
                PolicyManager.debug.error("PolicyUtils.parseAttribiteValuePairs():missing attribute name");
                return null;
            }
            Set values = PolicyUtils.getAttributeValues(node);
            if (values == null) {
                PolicyManager.debug.error("PolicyUtils.parseAttribiteValuePairs():missing attribute value");
                return null;
            }
            attrValuePairs.put(attributeName, values);
        }
        return attrValuePairs;
    }

    public static String getAttributeName(Node pNode) {
        Node node = XMLUtils.getChildNode((Node)pNode, (String)ATTRIBUTE);
        if (node == null) {
            PolicyManager.debug.error("PolicyUtils.getAttributeName(): missing element Attribute");
            return null;
        }
        String attrName = XMLUtils.getNodeAttributeValue((Node)node, (String)ATTRIBUTE_NAME);
        if (attrName == null) {
            PolicyManager.debug.error("PolicyUtils.getAttributeName(): missing attribute name for element Attribute");
            return null;
        }
        return attrName;
    }

    public static Set getAttributeValues(Node pNode) {
        Set nodeSet = XMLUtils.getChildNodes((Node)pNode, (String)VALUE);
        if (nodeSet == null) {
            PolicyManager.debug.error("PolicyUtils.getAttributeValues() : missing element Value");
            return null;
        }
        Iterator nodes = nodeSet.iterator();
        HashSet<String> values = new HashSet<String>();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            String value = XMLUtils.getValueOfValueNode((Node)node);
            if (value != null) {
                values.add(value);
                continue;
            }
            values.add(EMPTY_STRING);
        }
        return values;
    }

    public static String envParametersToXMLString(Map envMap) {
        StringBuffer xmlSB = new StringBuffer(1000);
        xmlSB.append("<EnvParameters>\r\n");
        Set keySet = envMap.keySet();
        Iterator keyIter = keySet.iterator();
        while (keyIter.hasNext()) {
            String name = (String)keyIter.next();
            Set values = (Set)envMap.get(name);
            xmlSB.append(PolicyUtils.attributeValuePairToXMLString(name, values));
        }
        xmlSB.append("</EnvParameters>\r\n");
        return xmlSB.toString();
    }

    public static String responseAttributesToXMLString(Set attrs) {
        StringBuffer xmlSB = new StringBuffer(1000);
        xmlSB.append("<GetResponseDecisions>\r\n");
        Iterator names = attrs.iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            xmlSB.append("<Attribute name=\"" + XMLUtils.escapeSpecialCharacters((String)name) + "\"/>" + CRLF);
        }
        xmlSB.append("</GetResponseDecisions>\r\n");
        return xmlSB.toString();
    }

    public static String mapToXMLString(Map envMap) {
        StringBuffer xmlSB = new StringBuffer(1000);
        Set keySet = envMap.keySet();
        Iterator keyIter = keySet.iterator();
        while (keyIter.hasNext()) {
            String name = (String)keyIter.next();
            Set values = (Set)envMap.get(name);
            xmlSB.append(PolicyUtils.attributeValuePairToXMLString(name, values));
        }
        return xmlSB.toString();
    }

    public static String attributeValuePairToXMLString(String name, Set values) {
        StringBuffer xmlSB = new StringBuffer(1000);
        xmlSB.append("<AttributeValuePair>\r\n");
        xmlSB.append("<Attribute name=\"" + XMLUtils.escapeSpecialCharacters((String)name) + "\"/>" + CRLF);
        if (values != null) {
            Iterator itr = values.iterator();
            while (itr.hasNext()) {
                String value = (String)itr.next();
                xmlSB.append(VALUE_BEGIN);
                xmlSB.append(XMLUtils.escapeSpecialCharacters((String)value));
                xmlSB.append("</Value>\r\n");
            }
        }
        xmlSB.append("</AttributeValuePair>\r\n");
        return xmlSB.toString();
    }

    public static String quote(String s) {
        if (s == null) {
            s = EMPTY_STRING;
        }
        return "\"" + s + "\"";
    }

    public static String quote(int i) {
        return PolicyUtils.quote(Integer.toString(i));
    }

    public static String quote(long l) {
        return PolicyUtils.quote(Long.toString(l));
    }

    public static void logAccessMessage(String msgIdName, String[] data, SSOToken token) throws SSOException {
        LogRecord lr;
        if (accessLogger != null && msgProvider != null && (lr = msgProvider.createLogRecord(msgIdName, data, token)) != null) {
            SSOToken ssoToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            accessLogger.log(lr, ssoToken);
        }
    }

    public static void logErrorMessage(String msgIdName, String[] data, SSOToken token) throws SSOException {
        LogRecord lr;
        if (errorLogger != null && msgProvider != null && (lr = msgProvider.createLogRecord(msgIdName, data, token)) != null) {
            SSOToken ssoToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            errorLogger.log(lr, ssoToken);
        }
    }

    public static String getISDSHostName() {
        try {
            DSConfigMgr mgr = DSConfigMgr.getDSConfigMgr();
            return mgr.getHostName("default");
        }
        catch (LDAPServiceException e) {
            PolicyManager.debug.error("Unable to get LDAP server host from DSConfigMgr: ", (Throwable)e);
            return null;
        }
    }

    public static boolean isLocalDS(String hostName) throws PolicyException {
        if (hostName == null) {
            throw new PolicyException("amPolicy", "invalid_ldap_server_host", null, null);
        }
        return hostName.equalsIgnoreCase(PolicyConfig.ISDS_HOST);
    }

    public static String constructUserFilter(SSOToken token, String userRDNAttrName, String userName, boolean aliasEnabled) throws SSOException {
        String principalsString;
        StringBuffer userFilter = new StringBuffer();
        if (aliasEnabled && (principalsString = token.getProperty("Principals")) != null) {
            StringTokenizer st = new StringTokenizer(principalsString, "|");
            while (st.hasMoreTokens()) {
                String userID;
                DN ldapDN;
                String[] components;
                String principalName = st.nextToken();
                if (!DN.isDN((String)principalName) || (components = (ldapDN = new DN(principalName)).explodeDN(true)) == null || components.length < 1 || (userID = components[0]).equalsIgnoreCase(userName)) continue;
                userFilter.append("(").append(userRDNAttrName).append("=").append(userID).append(")");
            }
        }
        if (userFilter.length() == 0) {
            userFilter.append("(").append(userRDNAttrName).append("=").append(userName).append(")");
        } else {
            userFilter.insert(0, "(|");
            userFilter.append("(").append(userRDNAttrName).append("=").append(userName).append("))");
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyUtils.constructUserFilter(): filter: " + userFilter.toString());
        }
        return userFilter.toString();
    }

    public static void removePolicyRules(SSOToken token, String serviceName) throws SSOException, AMException {
        try {
            Rule ruleDeleted;
            Rule rule;
            String ruleName;
            Iterator ruleItr;
            Policy p;
            String policyName;
            String dn;
            AMStoreConnection dpStore = new AMStoreConnection(token);
            PolicyManager pm = new PolicyManager(token);
            String org = pm.getOrganizationDN();
            AMOrganization rootOrg = dpStore.getOrganization(org);
            HashMap policyDNs = new HashMap();
            HashMap levelDNs = new HashMap();
            DN rootDN = new DN(SMSEntry.getRootSuffix());
            HashMap avPair = new HashMap();
            HashSet<String> value = new HashSet<String>();
            value.add("iPlanetAMPolicyConfigService");
            avPair.put("sunRegisteredServiceName", value);
            Set subOrgs = null;
            subOrgs = rootOrg.searchSubOrganizations("*", avPair, 2);
            Iterator iterOrg = subOrgs.iterator();
            while (iterOrg.hasNext()) {
                dn = (String)iterOrg.next();
                PolicyManager pmSubOrg = new PolicyManager(token, dn);
                Set policyNames = pmSubOrg.getPolicyNames();
                Iterator iter = policyNames.iterator();
                while (iter.hasNext()) {
                    policyName = (String)iter.next();
                    p = pmSubOrg.getPolicy(policyName);
                    if (!p.isReferralPolicy()) {
                        ruleItr = p.getRuleNames().iterator();
                        while (ruleItr.hasNext()) {
                            ruleName = (String)ruleItr.next();
                            rule = p.getRule(ruleName);
                            if (!rule.getServiceTypeName().equalsIgnoreCase(serviceName)) continue;
                            if (PolicyManager.debug.messageEnabled()) {
                                PolicyManager.debug.message("PolicyUtils.removePolicyRules():policy: " + policyName + ",rule: " + ruleName);
                            }
                            if ((ruleDeleted = p.removeRule(ruleName)) == null) continue;
                            pmSubOrg.replacePolicy(p);
                        }
                        continue;
                    }
                    if (policyDNs.containsKey(dn)) {
                        ((Vector)policyDNs.get(dn)).add(policyName);
                    } else {
                        Vector<String> policies = new Vector<String>();
                        policies.add(policyName);
                        policyDNs.put(dn, policies);
                    }
                    DN tmpDN = new DN(dn);
                    String levelDiff = String.valueOf(rootDN.countRDNs() - tmpDN.countRDNs());
                    if (levelDNs.containsKey(levelDiff)) {
                        ((Vector)levelDNs.get(levelDiff)).add(dn);
                        continue;
                    }
                    Vector<String> DNs = new Vector<String>();
                    DNs.add(dn);
                    levelDNs.put(levelDiff, DNs);
                }
            }
            TreeMap sortedDNs = new TreeMap(levelDNs);
            Iterator levelItr = sortedDNs.keySet().iterator();
            while (levelItr.hasNext()) {
                String level = (String)levelItr.next();
                Vector vDNs = (Vector)sortedDNs.get(level);
                for (int i = 0; i < vDNs.size(); ++i) {
                    dn = (String)vDNs.get(i);
                    PolicyManager pmRefOrg = new PolicyManager(token, dn);
                    Vector vPolicies = (Vector)policyDNs.get(dn);
                    for (int j = 0; j < vPolicies.size(); ++j) {
                        policyName = (String)vPolicies.get(j);
                        p = pmRefOrg.getPolicy(policyName);
                        ruleItr = p.getRuleNames().iterator();
                        while (ruleItr.hasNext()) {
                            ruleName = (String)ruleItr.next();
                            rule = p.getRule(ruleName);
                            if (!rule.getServiceTypeName().equalsIgnoreCase(serviceName)) continue;
                            if (PolicyManager.debug.messageEnabled()) {
                                PolicyManager.debug.message("PolicyUtils.removePolicyRules():referral policy: " + policyName + ",rule: " + ruleName);
                            }
                            if ((ruleDeleted = p.removeRule(ruleName)) == null) continue;
                            pmRefOrg.replacePolicy(p);
                        }
                    }
                }
            }
        }
        catch (PolicyException pe) {
            PolicyManager.debug.error("PolicyUtils.removePolicyRules():", (Throwable)pe);
        }
    }

    public static Set delimStringToSet(String str, String delimiter) {
        HashSet<String> valSet = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreTokens()) {
            valSet.add(st.nextToken().trim());
        }
        return valSet;
    }

    public static String getDNDisplayString(String strDN) {
        String displayString = null;
        if (!DN.isDN((String)strDN)) {
            displayString = strDN;
        } else {
            StringBuffer buff = new StringBuffer(1024);
            DN dn = new DN(strDN);
            Vector rdns = dn.getRDNs();
            int sz = rdns.size();
            for (int i = sz - 1; i >= 0; --i) {
                RDN rdn = (RDN)rdns.get(i);
                buff.append(rdn.getValues()[0]);
                if (i <= 0) continue;
                buff.append(" > ");
            }
            displayString = buff.toString();
        }
        return displayString;
    }

    public static Map parseAdvicesXML(String advicesXML) throws PolicyException {
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyUtils.parseAdvicesXML(): entering, advicesXML= " + advicesXML);
        }
        Map advices = null;
        if (advicesXML != null) {
            Document document = XMLUtils.toDOMDocument((String)advicesXML, (Debug)PolicyManager.debug);
            if (document != null) {
                Node advicesNode = XMLUtils.getRootNode((Document)document, (String)ADVICES_TAG_NAME);
                if (advicesNode != null) {
                    advices = XMLUtils.parseAttributeValuePairTags((Node)advicesNode);
                } else if (PolicyManager.debug.messageEnabled()) {
                    PolicyManager.debug.message("PolicyUtils.parseAdvicesXML(): advicesNode is null");
                }
            } else if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message("PolicyUtils.parseAdvicesXML(): document is null");
            }
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyUtils.parseAdvicesXML(): returning, advices= " + advices);
        }
        return advices;
    }

    public static String advicesToXMLString(Map advices) throws PolicyException {
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyUtils.advicesToXMLString(): entering, advices = " + advices);
        }
        String advicesXML = null;
        StringBuffer sb = new StringBuffer(200);
        sb.append(ADVICES_START_TAG).append(NEW_LINE);
        if (advices != null) {
            sb.append(PolicyUtils.mapToXMLString(advices));
        }
        sb.append(ADVICES_END_TAG).append(NEW_LINE);
        advicesXML = sb.toString();
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("PolicyUtils.advicesToXMLString(): returning, advicesXML = " + advicesXML);
        }
        return advicesXML;
    }

    public static boolean principalNameEqualsUuid(SSOToken token) throws SSOException {
        String principalName = token.getPrincipal().getName();
        String uuid = token.getProperty("sun.am.UniversalIdentifier");
        return principalName.equals(uuid);
    }

    public static void createPolicies(PolicyManager pm, InputStream xmlPolicies) throws PolicyException, SSOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ValidationErrorHandler());
            builder.setEntityResolver((EntityResolver)new XMLHandler());
            Element topElement = builder.parse(xmlPolicies).getDocumentElement();
            NodeList childElements = topElement.getChildNodes();
            int len = childElements.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = childElements.item(i);
                if (node == null || node.getNodeType() != 1) continue;
                pm.addPolicy(new Policy(pm, node));
            }
        }
        catch (IOException e) {
            throw new PolicyException(e);
        }
        catch (SAXException e) {
            throw new PolicyException(e);
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
    }

    public static Map cloneMap(Map map) {
        HashMap clonedMap = null;
        if (map != null) {
            clonedMap = new HashMap();
            Set keys = map.keySet();
            Iterator keysIter = keys.iterator();
            while (keysIter.hasNext()) {
                Object key = keysIter.next();
                Object value = map.get(key);
                if (value instanceof Set) {
                    HashSet values = new HashSet();
                    values.addAll((Set)value);
                    clonedMap.put(key, values);
                    continue;
                }
                clonedMap.put(key, (HashSet<Object>)value);
            }
        }
        return clonedMap;
    }

    public static String encrypt(String plainText) {
        if (plainText != null) {
            return Crypt.encode((String)plainText);
        }
        return plainText;
    }

    public static String decrypt(String encryptedText) {
        if (encryptedText != null) {
            return Crypt.decode((String)encryptedText);
        }
        return encryptedText;
    }

    static {
        String status = SystemProperties.get("com.iplanet.am.logstatus");
        boolean bl = logStatus = status != null && status.equalsIgnoreCase("ACTIVE");
        if (logStatus) {
            try {
                accessLogger = (Logger)Logger.getLogger("amPolicy.access");
                errorLogger = (Logger)Logger.getLogger("amPolicy.error");
                msgProvider = MessageProviderFactory.getProvider("Policy");
            }
            catch (IOException e) {
                PolicyManager.debug.error("PolicyUtils.<init>", (Throwable)e);
                logStatus = false;
            }
        }
    }
}

