/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.AttributeSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class PolicyDecision {
    static final String POLICY_DECISION = "PolicyDecision";
    static final String RESPONSE_DECISIONS = "ResponseDecisions";
    static final String RESPONSE_ATTRIBUTES = "ResponseAttributes";
    Map actionDecisions = new HashMap();
    private Map responseDecisions;
    private Map responseAttributes;
    private long timeToLive = Long.MAX_VALUE;
    private boolean advicesAreSet = false;

    public Map getActionDecisions() {
        return this.actionDecisions;
    }

    void addActionDecision(ActionDecision newActionDecision, ServiceType resourceType) {
        String action = newActionDecision.getActionName();
        ActionDecision oldActionDecision = (ActionDecision)this.actionDecisions.get(action);
        if (oldActionDecision == null) {
            this.addActionDecision(newActionDecision);
        } else {
            ActionSchema actionSchema = null;
            AttributeSchema.Syntax actionSyntax = null;
            try {
                actionSchema = resourceType.getActionSchema(action);
                actionSyntax = actionSchema.getSyntax();
            }
            catch (InvalidNameException e) {
                PolicyManager.debug.error("can not find action schmea for action = " + action, (Throwable)e);
            }
            if (!AttributeSchema.Syntax.BOOLEAN.equals(actionSyntax)) {
                this.addActionDecision(newActionDecision);
            } else {
                String falseValue = actionSchema.getFalseValue();
                String trueValue = actionSchema.getTrueValue();
                this.addActionDecision(newActionDecision, trueValue, falseValue);
            }
        }
    }

    public void addActionDecision(ActionDecision newActionDecision, String trueValue, String falseValue) {
        String action = newActionDecision.getActionName();
        ActionDecision oldActionDecision = (ActionDecision)this.actionDecisions.get(action);
        if (oldActionDecision == null || trueValue == null || falseValue == null) {
            this.addActionDecision(newActionDecision);
        } else {
            long newTtl = newActionDecision.getTimeToLive();
            long oldTtl = oldActionDecision.getTimeToLive();
            Set oldActionValues = oldActionDecision.getValues();
            Set newActionValues = newActionDecision.getValues();
            Map advices = null;
            Map oldAdvices = oldActionDecision.getAdvices();
            Map newAdvices = newActionDecision.getAdvices();
            advices = PolicyUtils.addMapToMap(oldAdvices, newAdvices);
            if (oldActionValues != null && oldActionValues.contains(falseValue)) {
                if (newActionValues != null && newActionValues.contains(falseValue)) {
                    oldActionDecision.setTimeToLive(Math.max(newTtl, oldTtl));
                }
            } else if (oldActionValues != null && oldActionValues.contains(trueValue)) {
                if (newActionValues != null && newActionValues.contains(falseValue)) {
                    this.actionDecisions.put(action, newActionDecision);
                } else if (newActionDecision.getValues().contains(trueValue)) {
                    oldActionDecision.setTimeToLive(Math.max(newTtl, oldTtl));
                }
            } else {
                this.actionDecisions.put(action, newActionDecision);
            }
            ActionDecision ad = (ActionDecision)this.actionDecisions.get(action);
            ad.setAdvices(advices);
            this.setTimeToLive();
        }
    }

    public void addActionDecision(ActionDecision actionDecision) {
        ActionDecision oldDecision = (ActionDecision)this.actionDecisions.get(actionDecision.getActionName());
        if (oldDecision == null) {
            this.actionDecisions.put(actionDecision.getActionName(), actionDecision);
        } else {
            Set oldValues = oldDecision.getValues();
            if (oldValues == Collections.EMPTY_SET || oldValues == null) {
                oldDecision.setValues(actionDecision.getValues());
            } else {
                oldValues.addAll(actionDecision.getValues());
            }
            if (actionDecision.getTimeToLive() < oldDecision.getTimeToLive()) {
                oldDecision.setTimeToLive(actionDecision.getTimeToLive());
            }
            PolicyUtils.appendMapToMap(actionDecision.getAdvices(), oldDecision.getAdvices());
        }
        this.setTimeToLive();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.responseAttributes != null && this.responseAttributes != Collections.EMPTY_MAP) {
            Iterator attrNames = this.responseAttributes.keySet().iterator();
            while (attrNames.hasNext()) {
                String attrName = (String)attrNames.next();
                Set attrValues = (Set)this.responseAttributes.get(attrName);
                sb.append(attrName + "=" + attrValues + "\n");
            }
        }
        Iterator actionNames = this.actionDecisions.keySet().iterator();
        while (actionNames.hasNext()) {
            String actionName = (String)actionNames.next();
            ActionDecision actionDecision = (ActionDecision)this.actionDecisions.get(actionName);
            Set actionValues = actionDecision.getValues();
            sb.append(actionName + "=" + actionValues + "\n");
        }
        return sb.toString();
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append(POLICY_DECISION).append(">").append("\r\n");
        if (this.responseAttributes != null && this.responseAttributes != Collections.EMPTY_MAP) {
            sb.append("<").append(RESPONSE_ATTRIBUTES);
            sb.append(">").append("\r\n");
            sb.append(PolicyUtils.mapToXMLString(this.responseAttributes));
            sb.append("<").append("/").append(RESPONSE_ATTRIBUTES);
            sb.append(">").append("\r\n");
        }
        Iterator actionNames = this.actionDecisions.keySet().iterator();
        while (actionNames.hasNext()) {
            String actionName = (String)actionNames.next();
            ActionDecision actionDecision = (ActionDecision)this.actionDecisions.get(actionName);
            sb.append(actionDecision.toXML());
        }
        if (this.responseDecisions != null) {
            sb.append("<").append(RESPONSE_DECISIONS).append(">").append("\r\n");
            sb.append(PolicyUtils.mapToXMLString(this.responseDecisions));
            sb.append("</").append(RESPONSE_DECISIONS).append(">").append("\r\n");
        }
        sb.append("</").append(POLICY_DECISION).append(">");
        sb.append("\r\n");
        return sb.toString();
    }

    public static PolicyDecision parsePolicyDecision(Node policyDecisionNode) throws PolicyException {
        Set responseNodeSet;
        Node node;
        PolicyDecision policyDecision = new PolicyDecision();
        Set nodeSet = XMLUtils.getChildNodes((Node)policyDecisionNode, (String)"ActionDecision");
        if (nodeSet == null) {
            PolicyManager.debug.error("parsePolicyDecision: Required element not found in policy decision node:ActionDecision");
            Object[] args = new Object[]{"ActionDecision"};
            throw new PolicyException("amPolicy", "missing_element", args, null);
        }
        Iterator nodes = nodeSet.iterator();
        while (nodes.hasNext()) {
            node = (Node)nodes.next();
            ActionDecision actionDecision = ActionDecision.parseActionDecision(node);
            policyDecision.addActionDecision(actionDecision);
        }
        Set resposeAttrsSet = XMLUtils.getChildNodes((Node)policyDecisionNode, (String)RESPONSE_ATTRIBUTES);
        if (resposeAttrsSet != null && !resposeAttrsSet.isEmpty()) {
            node = (Node)resposeAttrsSet.iterator().next();
            Map responseAttrsMap = PolicyUtils.parseAttributeValuePairs(node);
            policyDecision.setResponseAttributes(responseAttrsMap);
        }
        if ((responseNodeSet = XMLUtils.getChildNodes((Node)policyDecisionNode, (String)RESPONSE_DECISIONS)) != null && !responseNodeSet.isEmpty()) {
            Node node2 = (Node)responseNodeSet.iterator().next();
            Map responseMap = PolicyUtils.parseAttributeValuePairs(node2);
            policyDecision.setResponseDecisions(responseMap);
        }
        return policyDecision;
    }

    public Map getResponseDecisions() {
        return this.responseDecisions;
    }

    public void setResponseDecisions(Map responseDecisions) {
        this.responseDecisions = responseDecisions;
    }

    public Map getResponseAttributes() {
        return this.responseAttributes;
    }

    public void setResponseAttributes(Map responseAttributes) {
        this.responseAttributes = responseAttributes;
    }

    public Object clone() {
        String key;
        PolicyDecision clone = new PolicyDecision();
        clone.actionDecisions = new HashMap(this.actionDecisions.size());
        Iterator actionDecisionIter = this.actionDecisions.keySet().iterator();
        while (actionDecisionIter.hasNext()) {
            String key2 = (String)actionDecisionIter.next();
            ActionDecision ad = (ActionDecision)this.actionDecisions.get(key2);
            clone.addActionDecision((ActionDecision)ad.clone());
        }
        if (this.responseDecisions != null) {
            clone.responseDecisions = new HashMap(this.responseDecisions.size());
            Iterator responseDecisionsIter = this.responseDecisions.keySet().iterator();
            while (responseDecisionsIter.hasNext()) {
                key = (String)responseDecisionsIter.next();
                clone.responseDecisions.put(key, this.responseDecisions.get(key));
            }
        }
        if (this.responseAttributes != null) {
            clone.responseAttributes = new HashMap(this.responseAttributes.size());
            Iterator responseAttributesIter = this.responseAttributes.keySet().iterator();
            while (responseAttributesIter.hasNext()) {
                key = (String)responseAttributesIter.next();
                clone.responseAttributes.put(key, this.responseAttributes.get(key));
            }
        }
        return clone;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    private void setTimeToLive() {
        this.timeToLive = Long.MAX_VALUE;
        this.advicesAreSet = false;
        Iterator actionDecisionIter = this.actionDecisions.keySet().iterator();
        while (actionDecisionIter.hasNext()) {
            String key = (String)actionDecisionIter.next();
            ActionDecision ad = (ActionDecision)this.actionDecisions.get(key);
            long actionTtl = ad.getTimeToLive();
            if (actionTtl < this.timeToLive) {
                this.timeToLive = actionTtl;
            }
            this.advicesAreSet = this.advicesAreSet || ad.getAdvices() != null && !ad.getAdvices().isEmpty();
        }
    }

    void setTimeToLive(long ttl) {
        this.timeToLive = ttl;
    }

    public boolean hasAdvices() {
        return this.advicesAreSet;
    }
}

