/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.PluginSchema;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ConditionTypeManager {
    private static String CONDITION = "Condition";
    private SSOToken token;
    private PolicyManager pm;
    private ResourceBundle rb;
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    static Debug debug = PolicyManager.debug;

    ConditionTypeManager() throws SSOException {
        this.token = ServiceTypeManager.getSSOToken();
        String lstr = this.token.getProperty("Locale");
        java.util.Locale loc = Locale.getLocale((String)lstr);
        this.rb = amCache.getResBundle("amPolicy", loc);
    }

    ConditionTypeManager(PolicyManager pm) {
        java.util.Locale loc;
        this.pm = pm;
        this.token = pm.token;
        try {
            String lstr = this.token.getProperty("Locale");
            loc = Locale.getLocale((String)lstr);
        }
        catch (SSOException ex) {
            debug.error("ConditionTypeManager:Unable to retreive locale fromSSOToken", (Throwable)((Object)ex));
            loc = Locale.getDefaultLocale();
        }
        if (debug.messageEnabled()) {
            debug.message("SubjectManager locale=" + loc + "\tI18nFileName = " + "amPolicy");
        }
        this.rb = amCache.getResBundle("amPolicy", loc);
    }

    public Set getConditionTypeNames() throws SSOException, PolicyException {
        return PolicyManager.getPluginSchemaNames(CONDITION);
    }

    public Set getSelectedConditionTypeNames() throws SSOException, PolicyException {
        Object answer;
        String org = this.pm.getOrganizationDN();
        Map map = PolicyConfig.getPolicyConfig(org);
        if (map != null && (answer = map.get("iplanet-am-policy-selected-conditions")) != null) {
            return (Set)answer;
        }
        return Collections.EMPTY_SET;
    }

    public String getConditionTypeName(Condition condition) {
        return ConditionTypeManager.conditionTypeName(condition);
    }

    protected String getI18NPropertiesFileName(String conditionType) {
        PolicyManager.getPluginSchema(CONDITION, conditionType);
        return null;
    }

    public String getI18NKey(String conditionType) {
        PluginSchema ps = PolicyManager.getPluginSchema(CONDITION, conditionType);
        if (ps != null) {
            return ps.getI18NKey();
        }
        return null;
    }

    public String getDisplayName(String conditionType) {
        String displayName = null;
        String i18nKey = this.getI18NKey(conditionType);
        displayName = i18nKey == null || i18nKey.length() == 0 ? conditionType : Locale.getString((ResourceBundle)this.rb, (String)i18nKey, (Debug)debug);
        return displayName;
    }

    public Condition getCondition(String conditionType) throws NameNotFoundException, PolicyException {
        PluginSchema ps = PolicyManager.getPluginSchema(CONDITION, conditionType);
        if (ps == null) {
            throw new NameNotFoundException("amPolicy", "invalid_condition", null, conditionType, 5);
        }
        Condition condition = null;
        try {
            String className = ps.getClassName();
            condition = (Condition)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
        return condition;
    }

    static String conditionTypeName(Condition condition) {
        if (condition == null) {
            return null;
        }
        String name = null;
        String className = condition.getClass().getName();
        Iterator items = PolicyManager.getPluginSchemaNames(CONDITION).iterator();
        while (items.hasNext()) {
            String pluginName = (String)items.next();
            PluginSchema ps = PolicyManager.getPluginSchema(CONDITION, pluginName);
            if (!className.equals(ps.getClassName())) continue;
            name = pluginName;
            break;
        }
        return name;
    }

    public String getViewBeanURL(Condition condition) {
        return PolicyManager.getViewBeanURL(CONDITION, condition.getClass().getName());
    }
}

