/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.service;

import com.iplanet.dpro.parser.WebtopParser;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.log.service.LogOperation;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.session.util.RestrictedTokenHelper;
import com.sun.identity.session.util.SessionUtils;
import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogService
implements RequestHandler {
    private static String loggedBySid;
    private static final String pkg = "com.sun.identity.log.service.";
    private static final String LOG_SERVICE = "iplanet.webtop.service.logging";
    WebtopParser parser = new WebtopParser();

    public LogService() throws Exception {
        this.parser.register("logRecWrite", "com.sun.identity.log.service.LogRecWrite");
        this.parser.register("log", "com.sun.identity.log.service.Log");
        this.parser.register("logRecord", "com.sun.identity.log.service.LogRecord");
        this.parser.register("level", "com.sun.identity.log.service.Level");
        this.parser.register("recMsg", "com.sun.identity.log.service.RecMsg");
        this.parser.register("recType", "com.sun.identity.log.service.RecType");
        this.parser.register("logType", "com.sun.identity.log.service.LogType");
        this.parser.register("logInfoMap", "com.sun.identity.log.service.LogInfoMap");
        this.parser.register("logInfo", "com.sun.identity.log.service.LogInfo");
        this.parser.register("infoKey", "com.sun.identity.log.service.InfoKey");
        this.parser.register("infoValue", "com.sun.identity.log.service.InfoValue");
        this.parser.register("parameters", "com.sun.identity.log.service.Parameters");
        this.parser.register("parameter", "com.sun.identity.log.service.Parameter");
        this.parser.register("paramIndex", "com.sun.identity.log.service.ParamIndex");
        this.parser.register("paramValue", "com.sun.identity.log.service.ParamValue");
    }

    public ResponseSet process(Vector requests, HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServletContext servletContext) {
        if (Debug.messageEnabled()) {
            Debug.message("LogService.process() called :requests are");
            for (int i = 0; i < requests.size(); ++i) {
                Debug.message("xml = " + ((Request)requests.elementAt(i)).getContent());
            }
        }
        ResponseSet rset = new ResponseSet(LOG_SERVICE);
        for (int i = 0; i < requests.size(); ++i) {
            Response res;
            Request req = (Request)requests.elementAt(i);
            String xmlRequestString = req.getContent();
            if (xmlRequestString == null || xmlRequestString.equals("null")) {
                Debug.error("Received a null log request");
                res = new Response("NULL_LOG_REQUEST");
                rset.addResponse(res);
                continue;
            }
            int l = xmlRequestString.length();
            int sidi = xmlRequestString.indexOf("sid=");
            int sidj = xmlRequestString.indexOf("</log");
            loggedBySid = xmlRequestString.substring(sidi + 5, sidj - 2);
            try {
                InetAddress remoteClient = SessionUtils.getClientAddress(servletRequest);
                SSOToken ssoToken = RestrictedTokenHelper.resolveRestrictedToken(loggedBySid, remoteClient);
                SSOTokenManager ssom = SSOTokenManager.getInstance();
                if (!ssom.isValidToken(ssoToken)) {
                    String loggedByID = ssoToken.getPrincipal().getName();
                    Debug.error("LogService::process(): access denied for user :" + loggedByID);
                    res = new Response("UNAUTHORIZED");
                    rset.addResponse(res);
                    return rset;
                }
            }
            catch (SSOException e) {
                Debug.error("LogService::process(): SSOException", (Throwable)((Object)e));
                res = new Response("UNAUTHORIZED");
                rset.addResponse(res);
                return rset;
            }
            catch (Exception e) {
                Debug.error("LogService::process(): ", e);
                res = new Response("ERROR");
                rset.addResponse(res);
            }
            try {
                ByteArrayInputStream bin = new ByteArrayInputStream(xmlRequestString.getBytes("UTF-8"));
                LogOperation op = (LogOperation)this.parser.parse(bin);
                res = op.execute();
            }
            catch (Exception e) {
                Debug.error("LogService::process():", e);
                res = new Response("ERROR");
            }
            rset.addResponse(res);
        }
        return rset;
    }
}

