/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.messageid;

import com.sun.identity.log.LogRecord;
import com.sun.identity.log.messageid.LogMessageID;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.shared.xml.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LogMessageProviderBase
implements LogMessageProvider {
    private List messageIDs = new ArrayList();
    private Map hashMessageIDs = new HashMap();
    private String xmlDefinitionFilename;

    protected LogMessageProviderBase(String xmlDef) throws IOException {
        this.xmlDefinitionFilename = xmlDef;
        this.registerMessageIDs();
    }

    public List getAllMessageIDs() {
        return this.messageIDs;
    }

    public LogRecord createLogRecord(String messageIDName, String[] dataInfo, Object ssoToken) {
        LogRecord logRec = null;
        LogMessageID logMsgId = (LogMessageID)this.hashMessageIDs.get(messageIDName);
        if (logMsgId != null) {
            logRec = ssoToken != null ? new LogRecord(logMsgId.getLogLevel(), this.formatMessage(dataInfo, logMsgId), ssoToken) : new LogRecord(logMsgId.getLogLevel(), this.formatMessage(dataInfo, logMsgId));
            logRec.addLogInfo("MessageID", logMsgId.getPrefix() + "-" + logMsgId.getID());
        } else {
            Debug.error("LogMessageProviderBase.createLogRecord: unable to locate message ID object for " + messageIDName);
        }
        return logRec;
    }

    public LogRecord createLogRecord(String messageIDName, String[] dataInfo, Hashtable ssoProperties) {
        LogRecord logRec = null;
        LogMessageID logMsgId = (LogMessageID)this.hashMessageIDs.get(messageIDName);
        if (logMsgId != null) {
            logRec = new LogRecord(logMsgId.getLogLevel(), this.formatMessage(dataInfo, logMsgId), ssoProperties);
            logRec.addLogInfo("MessageID", logMsgId.getPrefix() + "-" + logMsgId.getID());
        } else {
            Debug.error("LogMessageProviderBase.createLogRecord: unable to locale message ID object for " + messageIDName);
        }
        return logRec;
    }

    private String formatMessage(String[] dataInfo, LogMessageID logMsgId) {
        StringBuffer buff = new StringBuffer();
        if (dataInfo != null) {
            int sz = dataInfo.length;
            if (logMsgId.getNumberOfEntriesInDataColumn() != sz) {
                Debug.error("LogMessageProviderBase.formatMessage: " + logMsgId.getName() + " mismatch in number of elements in string array with " + "that is defined in message ID XML file");
            }
            for (int i = 0; i < sz; ++i) {
                if (i > 0) {
                    buff.append("|");
                }
                buff.append(dataInfo[i]);
            }
        }
        return buff.toString();
    }

    protected void registerMessageIDs() throws IOException {
        Element topElement;
        String tagName;
        Document doc = this.getXMLDoc();
        if (doc != null && (tagName = (topElement = doc.getDocumentElement()).getNodeName()).equals("logmessages")) {
            String prefix = topElement.getAttribute("prefix");
            NodeList children = topElement.getChildNodes();
            int numChildren = children.getLength();
            for (int i = 0; i < numChildren; ++i) {
                LogMessageID id = LogMessageID.createInstance(prefix, children.item(i));
                if (id == null) continue;
                this.messageIDs.add(id);
                this.hashMessageIDs.put(id.getName(), id);
            }
        }
    }

    private Document getXMLDoc() throws IOException {
        Document xmlDoc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ValidationErrorHandler());
            builder.setEntityResolver(new XMLHandler());
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.xmlDefinitionFilename);
            if (is == null) {
                throw new IOException(this.xmlDefinitionFilename + " cannot be found.");
            }
            xmlDoc = builder.parse(is);
        }
        catch (SAXParseException e) {
            Debug.error("LogMessageProviderBase.getXMLDoc", e);
        }
        catch (SAXException e) {
            Debug.error("LogMessageProviderBase.getXMLDoc", e);
        }
        catch (ParserConfigurationException e) {
            Debug.error("LogMessageProviderBase.getXMLDoc", e);
        }
        return xmlDoc;
    }

    class XMLHandler
    extends DefaultHandler {
        XMLHandler() {
        }

        public InputSource resolveEntity(String aPublicID, String aSystemID) {
            InputSource source = null;
            String sysid = aSystemID.trim();
            if (sysid.toLowerCase().startsWith("jar://")) {
                String dtdname = sysid.substring(5);
                String dtdValue = Resource.read((String)dtdname).trim();
                source = new InputSource(new StringReader(dtdValue));
            }
            return source;
        }
    }

    class ValidationErrorHandler
    implements ErrorHandler {
        ValidationErrorHandler() {
        }

        public void fatalError(SAXParseException e) throws SAXParseException {
            System.err.println(LogMessageProviderBase.this.xmlDefinitionFilename + "\n" + e.getMessage() + "\nLine Number in XML file : " + e.getLineNumber() + "\nColumn Number in XML file : " + e.getColumnNumber());
        }

        public void error(SAXParseException e) throws SAXParseException {
            System.err.println(LogMessageProviderBase.this.xmlDefinitionFilename + "\n" + e.getMessage() + "\nLine Number in XML file : " + e.getLineNumber() + "\nColumn Number in XML file : " + e.getColumnNumber());
            throw e;
        }

        public void warning(SAXParseException e) throws SAXParseException {
            System.err.println(LogMessageProviderBase.this.xmlDefinitionFilename + "\n" + e.getMessage() + "\nLine Number in XML file : " + e.getLineNumber() + "\nColumn Number in XML file : " + e.getColumnNumber());
        }
    }
}

