/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.log.NullLocationException;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogQuery;
import com.sun.identity.log.LogReader;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.FormatterInitException;
import com.sun.identity.log.secure.LogSign;
import com.sun.identity.log.secure.LogVerifier;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.secure.VerifierList;
import com.sun.identity.log.spi.Archiver;
import com.sun.identity.log.spi.Authorizer;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.Token;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.security.keystore.AMPassword;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class SecureFileHandler
extends Handler {
    private LogManager lmanager = LogManagerUtil.getLogManager();
    private static String PREFIX = "_secure.";
    private OutputStream output;
    private Writer writer;
    private MeteredStream meteredStream;
    private static Hashtable archiverTable = new Hashtable();
    private static Map currentFileList = new HashMap();
    private static Hashtable helperTable = new Hashtable();
    private static boolean verificationInitialized = false;
    private boolean headerWritten;
    private int maxFileSize;
    private String location;
    private String logName;
    private int filesPerKeyStore;
    private String archiverClass;
    private SignTask signTask = null;
    private long signInterval = 0L;
    private static AMPassword logPassword = null;
    private static AMPassword verPassword = null;
    private SecureLogHelper helper = null;
    private LogVerifier lv = null;
    private static String token = null;

    private void setOutputStream(OutputStream out) throws SecurityException, UnsupportedEncodingException {
        if (out == null && Debug.warningEnabled()) {
            Debug.warning(this.logName + ":SecureFileHandler: " + "OutputStream is null");
        }
        this.output = out;
        this.headerWritten = false;
        String encoding = this.getEncoding();
        if (encoding == null) {
            this.writer = new OutputStreamWriter(this.output);
        } else {
            try {
                this.writer = new OutputStreamWriter(this.output, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                Debug.error(this.logName + ":SecureFileHandler: " + "Unsupported Encoding", ex);
                throw new UnsupportedEncodingException(ex.getMessage());
            }
        }
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        if (this.output == null) {
            return;
        }
        this.flush();
        this.writer = encoding == null ? new OutputStreamWriter(this.output) : new OutputStreamWriter(this.output, encoding);
    }

    private void configure() throws NullLocationException, FormatterInitException {
        String archiverClassString;
        String filesPerKeyStoreString;
        String Interval = this.lmanager.getProperty("iplanet-am-logging-signature-period-in-seconds");
        this.signInterval = Interval == null || Interval.length() == 0 ? 600000L : Long.parseLong(Interval) * 1000L;
        String strMaxFileSize = this.lmanager.getProperty("iplanet-am-logging-max-file-size");
        this.maxFileSize = strMaxFileSize == null || strMaxFileSize.length() == 0 ? 0 : Integer.parseInt(strMaxFileSize);
        this.location = this.lmanager.getProperty("iplanet-am-logging." + this.logName + ".location");
        if (this.location == null) {
            this.location = this.lmanager.getProperty("iplanet-am-logging-location");
        }
        if (this.location == null || this.location.length() == 0) {
            throw new NullLocationException("Location Not Specified");
        }
        if (!this.location.endsWith(File.separator)) {
            this.location = this.location + File.separator;
        }
        if ((filesPerKeyStoreString = this.lmanager.getProperty("iplanet-am-logging-files-per-keystore")) == null || filesPerKeyStoreString.length() == 0) {
            if (Debug.warningEnabled()) {
                Debug.warning(this.logName + ":Archiver: could not get the files " + "per keystore str setting it to 1");
            }
            filesPerKeyStoreString = "5";
        }
        this.filesPerKeyStore = Integer.parseInt(filesPerKeyStoreString);
        if (Debug.messageEnabled()) {
            Debug.message(this.logName + ":Files per Key Store = " + filesPerKeyStoreString);
        }
        if ((archiverClassString = this.lmanager.getProperty("iplanet-am-logging-archiver-class")) == null || archiverClassString.length() == 0) {
            throw new NullLocationException("Archvier class not specified");
        }
        this.archiverClass = archiverClassString;
    }

    private void openFiles(String fileName) throws IOException {
        this.open(new File(fileName), true);
    }

    private void open(File fileName, boolean append) throws IOException {
        int len = 0;
        len = (int)fileName.length();
        FileOutputStream fout = new FileOutputStream(fileName.toString(), true);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meteredStream = new MeteredStream(bout, len);
        this.setOutputStream(this.meteredStream);
        this.checkForHeaderWritten(fileName.toString());
    }

    public SecureFileHandler(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return;
        }
        this.logName = fileName;
        try {
            this.configure();
        }
        catch (NullLocationException nle) {
            Debug.error(this.logName + ":SecureFileHandler: Location not specified", nle);
        }
        catch (FormatterInitException fie) {
            Debug.error(this.logName + ":SecureFileHandler: could not instantiate Formatter", fie);
        }
        fileName = this.location + PREFIX + fileName;
        Logger logger = (Logger)Logger.getLogger(this.logName);
        if (logger.getLevel() != Level.OFF) {
            try {
                this.openFiles(fileName);
            }
            catch (IOException ioe) {
                Debug.error(this.logName + ":SecureFileHandler: Unable to open Files", ioe);
            }
            logger.setCurrentFile(PREFIX + this.logName);
            this.initializeSecurity();
        }
    }

    public void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception ex) {
                Debug.error(this.logName + ":SecureFileHandler: " + "Could not Flush Output", ex);
            }
        }
    }

    public void close() {
        if (Debug.messageEnabled()) {
            Debug.message(this.logName + ":SecureFileHandler: close() called");
        }
        this.flush();
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException ioe) {
            Debug.error(this.logName + ":SecureFileHandler: Could not close writer", ioe);
        }
        if (this.signTask != null) {
            this.stopPeriodicLogSigner();
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":Stopped Log Signer");
            }
        }
        if (this.lv != null) {
            this.lv.stopLogVerifier();
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":Stopped Log Verifier");
            }
        }
    }

    public synchronized void publish(java.util.logging.LogRecord lrecord) {
        if (this.writer == null) {
            Debug.warning(this.logName + ":SecureFileHandler: Writer is null");
            return;
        }
        if (!this.isLoggable(lrecord)) {
            return;
        }
        String message = "";
        message = this.getFormatter().format(lrecord);
        try {
            if (!this.headerWritten) {
                this.writer.write(this.getFormatter().getHead(this));
                this.headerWritten = true;
            }
            this.writer.write(message);
        }
        catch (IOException ex) {
            Debug.error(this.logName + ":SecureFileHandler: could not write to file", ex);
        }
        this.flush();
        if (!this.lv.getVerificationFlag()) {
            this.helper.setLastLineforLogger(true);
        }
        if (Debug.messageEnabled()) {
            Debug.message(this.logName + ":Check for file size = " + this.maxFileSize + " with size written = " + this.meteredStream.written);
        }
        if (message.length() > 0 && this.meteredStream.written >= this.maxFileSize) {
            if (Debug.messageEnabled()) {
                Debug.message("SecureFileHandler: FileFull Event reached");
            }
            this.archive();
        }
    }

    public static Archiver getArchiver(String logName) {
        if (logName == null || logName.length() == 0) {
            Debug.warning(logName + ":Logger: could not get archiver, null logName");
            return null;
        }
        return (Archiver)archiverTable.get(logName);
    }

    public static void setArchiver(String logName, Archiver archiver) {
        if (logName == null || logName.length() == 0) {
            if (Debug.warningEnabled()) {
                Debug.warning(logName + ":Logger: Could not set archiver, null logName");
            }
            return;
        }
        archiverTable.put(logName, archiver);
    }

    private void archive() {
        Archiver archiver = SecureFileHandler.getArchiver(this.logName);
        String message = "";
        String signature = "Signature";
        try {
            LogSign ls = new LogSign(this.logName);
            signature = ls.sign();
        }
        catch (Exception e) {
            Debug.error(this.logName + ":SecureFileHandler: could not generate signature");
        }
        LogRecord lr = new LogRecord(Level.INFO, "Signature");
        lr.setLoggerName(this.logName);
        lr.addLogInfo("Signature", signature);
        message = this.getFormatter().format(lr);
        try {
            this.writer.write(message);
        }
        catch (IOException ioe) {
            Debug.error(this.logName + ":SecureLogHelper: could not write signature to file", ioe);
        }
        this.flush();
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException ioe) {
            Debug.error(this.logName + ":SecureFileHandler: Couldnot close writer", ioe);
        }
        try {
            archiver.archive(this.logName, this.location);
            int fileCount = archiver.checkCount();
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":Files per keystore=" + this.filesPerKeyStore + " and current file count = " + fileCount);
            }
            if (fileCount >= this.filesPerKeyStore) {
                Debug.message(this.logName + ":Keystore limit reached");
                archiver.archiveKeyStore(this.logName, this.location);
                Debug.message(this.logName + ":FilesPerKeystore counter = " + archiver.checkCount());
                this.initializeKeyStore();
            }
        }
        catch (Exception ioe) {
            Debug.error(this.logName + ":SecureFileHandler: Could not archive file", ioe);
        }
        try {
            this.open(new File(this.location + PREFIX + this.logName), false);
            this.writer.write(this.getFormatter().getHead(this));
            this.headerWritten = true;
            int fileCount = archiver.checkCount();
            if (fileCount != 0) {
                this.writer.write(message);
            }
        }
        catch (IOException ex) {
            Debug.error(this.logName + ":SecureFileHandler: could not write to file", ex);
        }
        this.flush();
    }

    private void checkForHeaderWritten(String fileName) {
        byte[] bytes = new byte[1024];
        try {
            FileInputStream fins = new FileInputStream(new File(fileName));
            fins.read(bytes);
        }
        catch (IOException ioe) {
            Debug.error(this.logName + ":SecureFileHandler: could not read file content", ioe);
        }
        String fileContent = new String(bytes);
        fileContent = fileContent.trim();
        if (fileContent.startsWith("#Version")) {
            this.headerWritten = true;
        }
    }

    public static void setLogPassword(AMPassword logPass, Object token) {
        if (Authorizer.isAuthorized(token)) {
            logPassword = logPass;
        }
    }

    public static void setVerPassword(AMPassword verPass, Object token) {
        if (Authorizer.isAuthorized(token)) {
            verPassword = verPass;
        }
    }

    static AMPassword getLogPassword() {
        return logPassword;
    }

    static AMPassword getVerPassword() {
        return verPassword;
    }

    public static SecureLogHelper getSecureLogHelperInst() {
        SecureLogHelper helper = null;
        String helperClass = LogManagerUtil.getLogManager().getProperty("iplanet-am-logging-secure-log-helper-class-name");
        if (Debug.messageEnabled()) {
            Debug.message("Configured SecureLogHelper Impl class : " + helperClass);
        }
        try {
            helper = (SecureLogHelper)Class.forName(helperClass).newInstance();
        }
        catch (Exception e) {
            Debug.error("Could not instantiate class " + helperClass, e);
        }
        return helper;
    }

    public static SecureLogHelper getSecureLogHelper(String logName) {
        if (logName == null || logName.length() == 0) {
            Debug.warning(logName + ":Logger: could not get SecureLogHelper , null logName");
            return null;
        }
        return (SecureLogHelper)helperTable.get(logName);
    }

    private static void setSecureLogHelper(String logName, SecureLogHelper helper) {
        if (logName == null || logName.length() == 0) {
            Debug.warning(logName + ":Logger: Could not set SecureLogHelper , null logName");
            return;
        }
        helperTable.put(logName, helper);
    }

    void initializeSecurity() {
        String currentFileName = this.logName;
        try {
            String logPath = this.lmanager.getProperty("iplanet-am-logging-location");
            if (!logPath.endsWith("/")) {
                logPath = logPath + "/";
            }
            String FileName = currentFileName;
            String loggerFileName = logPath + PREFIX + "log." + FileName;
            String verifierFileName = logPath + PREFIX + "ver." + FileName;
            this.helper = SecureFileHandler.getSecureLogHelper(this.logName);
            if (this.helper == null) {
                this.helper = SecureFileHandler.getSecureLogHelperInst();
                SecureFileHandler.setSecureLogHelper(this.logName, this.helper);
            }
            this.helper.initializeSecureLogHelper(loggerFileName, logPassword, verifierFileName, logPassword);
            if (verificationInitialized) {
                this.helper.initializeVerifier(verifierFileName, logPassword, verPassword);
            }
        }
        catch (Exception e) {
            Debug.error(this.logName + ":Logger: exception thrown while initializing secure logger", e);
        }
        Archiver archiver = null;
        try {
            if (SecureFileHandler.getArchiver(this.logName) == null) {
                archiver = (Archiver)Class.forName(this.archiverClass).newInstance();
                SecureFileHandler.setArchiver(this.logName, archiver);
            }
        }
        catch (Exception e) {
            Debug.error(this.logName + ":SecureFileHandler: Could Not set Archiver", e);
        }
        String Interval = this.lmanager.getProperty("iplanet-am-logging-signature-period-in-seconds");
        this.signInterval = Interval == null || Interval.length() == 0 ? 600000L : Long.parseLong(Interval) * 1000L;
        this.startPeriodicLogSigner();
        if (verificationInitialized) {
            this.startVerifierThread();
        }
        Debug.message(this.logName + ":Done initializeSecurity in Handler");
        VerifierList vl = new VerifierList();
        String path = this.location;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        TreeMap tm = vl.getKeysAndFiles(new File(path), this.logName);
        Vector logFiles = (Vector)tm.get(PREFIX + "log." + this.logName);
        for (int j = 1; j < logFiles.size(); ++j) {
            String name = (String)logFiles.elementAt(j);
            name = name.substring(PREFIX.length(), name.length());
            SecureFileHandler.addToCurrentFileList(name, name, this.logName);
            if (archiver == null) continue;
            archiver.incrementCount();
        }
        String name = (String)logFiles.elementAt(0);
        name = name.substring(PREFIX.length(), name.length());
        SecureFileHandler.addToCurrentFileList(name, name, this.logName);
    }

    public static void initializeVerifier(AMPassword verPass, Object token) {
        try {
            SecureFileHandler.setVerPassword(verPass, token);
            LogManager lmanager = LogManagerUtil.getLogManager();
            String logPath = lmanager.getProperty("iplanet-am-logging-location");
            if (!logPath.endsWith("/")) {
                logPath = logPath + "/";
            }
            LogManager manager = LogManagerUtil.getLogManager();
            Enumeration<String> e = manager.getLoggerNames();
            while (e.hasMoreElements()) {
                String FileName = e.nextElement();
                String verifierFileName = logPath + PREFIX + "ver." + FileName;
                SecureLogHelper helper = SecureFileHandler.getSecureLogHelper(FileName);
                AMPassword logPassword = SecureFileHandler.getLogPassword();
                if (helper != null) {
                    helper.initializeVerifier(verifierFileName, logPassword, verPassword);
                    try {
                        Debug.message(FileName + ":Trying to start the Verifier Thread");
                        Logger logger = (Logger)Logger.getLogger(FileName);
                        Handler[] handlers = logger.getHandlers();
                        ((SecureFileHandler)handlers[0]).startVerifierThread();
                        Debug.message(FileName + ":Started Log Verifier thread");
                    }
                    catch (Exception ex) {
                        Debug.error(FileName + ":Unable to start Verifier Thread", ex);
                    }
                }
                verificationInitialized = true;
            }
        }
        catch (Exception e) {
            Debug.error("Error initializing Verification", e);
        }
    }

    LogVerifier getVerifier() {
        return this.lv;
    }

    void startVerifierThread() {
        try {
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":Trying to start the Verifier Thread");
            }
            this.lv = new LogVerifier(this.logName, verPassword);
            this.lv.startLogVerifier();
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":Started Log Verifier thread");
            }
        }
        catch (Exception e) {
            Debug.error(this.logName + ":Unable to start Verifier Thread", e);
        }
    }

    public static void addToCurrentFileList(String oldFileName, String newFileName, String logName) {
        ArrayList<String> fileList = (ArrayList<String>)currentFileList.get(PREFIX + logName);
        if (fileList == null) {
            fileList = new ArrayList<String>();
        }
        currentFileList.remove(PREFIX + logName);
        fileList.remove(PREFIX + oldFileName);
        fileList.add(PREFIX + newFileName);
        if (!oldFileName.equals(newFileName)) {
            fileList.add(PREFIX + oldFileName);
        }
        currentFileList.put(PREFIX + logName, fileList);
    }

    public static ArrayList getCurrentFileList(String logName) {
        return (ArrayList)currentFileList.get(PREFIX + logName);
    }

    public static void resetCurrentFileList(String logName) {
        currentFileList.remove(PREFIX + logName);
    }

    public void initializeKeyStore() {
        try {
            Logger logger = (Logger)Logger.getLogger(this.logName);
            SecureFileHandler.resetCurrentFileList(this.logName);
            SecureFileHandler.addToCurrentFileList(this.logName, this.logName, this.logName);
            String logPath = this.lmanager.getProperty("iplanet-am-logging-location");
            if (!logPath.endsWith("/")) {
                logPath = logPath + "/";
            }
            String fileName = this.logName;
            String loggerFileName = logPath + PREFIX + "log." + fileName;
            String verifierFileName = logPath + PREFIX + "ver." + fileName;
            Debug.message(this.logName + ":Logger Keystore name = " + loggerFileName);
            Debug.message(this.logName + ":Verifier Keystore name= " + verifierFileName);
            this.helper.initializeSecureLogHelper(loggerFileName, logPassword, verifierFileName, logPassword);
            Debug.message(this.logName + ":Initialized SecureLogHelper");
            this.helper.initializeVerifier(verifierFileName, logPassword, verPassword);
            Debug.message(this.logName + ":Done init of SecureLogHelper and Verifier");
        }
        catch (Exception e) {
            Debug.error(this.logName + ":Logger: exception thrown while initializing secure logger", e);
        }
    }

    public static void setTokenName(String tokenName) {
        if (tokenName != null) {
            token = tokenName;
        }
    }

    public static String getTokenName() {
        return token;
    }

    public static void setLoggerKeyName(String name) {
        SecureLogHelper.setLoggerKeyName(name);
    }

    public static String getLoggerKeyName() {
        return SecureLogHelper.getLoggerKeyName();
    }

    public SecureLogHelper getSecureLogHelper() {
        return this.helper;
    }

    void startPeriodicLogSigner() {
        if (this.signTask == null) {
            this.signTask = new SignTask(this.signInterval);
            SystemTimer.getTimer().schedule((TaskRunnable)this.signTask, new Date((System.currentTimeMillis() + this.signInterval) / 1000L * 1000L));
        }
    }

    void stopPeriodicLogSigner() {
        if (this.signTask != null) {
            Debug.message(this.logName + "Sign Thread being stopped");
            this.signTask.cancel();
            this.signTask = null;
        }
    }

    static {
        String logPass = (String)AccessController.doPrivileged(new AdminPasswordAction());
        AMPassword passwd = new AMPassword(logPass.toCharArray());
        SecureFileHandler.setLogPassword(passwd, new Object());
        SecureFileHandler.initializeVerifier(passwd, new Object());
        SecureFileHandler.setTokenName(null);
    }

    class SignTask
    extends GeneralTaskRunnable {
        private long runPeriod;

        public SignTask(long runPeriod) {
            this.runPeriod = runPeriod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Logger logger = (Logger)Logger.getLogger(SecureFileHandler.this.logName);
            try {
                Logger.rwLock.readRequest();
                Logger logger2 = logger;
                synchronized (logger2) {
                    block15: {
                        try {
                            String[][] result = LogReader.read(PREFIX + SecureFileHandler.this.logName, new LogQuery(1), Token.createToken("Auditor", new String(logPassword.getChars())));
                            if (result == null || result.length == 0) {
                                Debug.message(SecureFileHandler.this.logName + ": Read returned null records");
                                break block15;
                            }
                            LogSign logSign = new LogSign(SecureFileHandler.this.logName);
                            int signPos = -1;
                            String signFieldName = "Signature";
                            for (int j = 0; j < result[0].length; ++j) {
                                if (!result[0][j].equalsIgnoreCase(signFieldName)) continue;
                                signPos = j;
                                break;
                            }
                            if (signPos == -1) {
                                Debug.error("Could not locate sign header");
                                return;
                            }
                            if (result.length > 1 && result[1][signPos].trim().equals("-")) {
                                String signature = logSign.sign();
                                if (signature != null && !signature.equals("")) {
                                    LogRecord lr = new LogRecord(Level.SEVERE, "Signature");
                                    lr.addLogInfo("Signature", signature);
                                    SecureFileHandler.this.publish(lr);
                                    break block15;
                                } else {
                                    Debug.warning(SecureFileHandler.this.logName + "Signature is Null");
                                }
                                break block15;
                            }
                            Debug.message(SecureFileHandler.this.logName + ": Read returned only header or last " + "record was a signature ");
                        }
                        catch (Exception e) {
                            Debug.error(SecureFileHandler.this.logName + ":Error Writing Signature", e);
                        }
                    }
                    return;
                }
            }
            finally {
                Logger.rwLock.readDone();
            }
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.written += b.length;
        }

        public void write(byte[] b, int offset, int length) throws IOException {
            this.out.write(b, offset, length);
            this.written += length;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

