/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.secure.MACGenerator;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.IGenerator;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;

public class SecureELFFormatter
extends Formatter {
    private LogManager lmanager = (LogManager)LogManagerUtil.getLogManager();
    private String[] allFields;
    private IGenerator fieldGenerator = new MACGenerator();
    private ITimestampGenerator secureTimestampGenerator;

    public SecureELFFormatter() {
        String timestampGeneratorClass = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clz = Class.forName(timestampGeneratorClass);
            this.secureTimestampGenerator = (ITimestampGenerator)clz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            Debug.error("SecureELFFormatter: TimeStamp Generator Class not found", cnfe);
        }
        catch (InstantiationException ie) {
            Debug.error("SecureELFFormatter: Timestamp Generator Could not be Instantiated", ie);
        }
        catch (IllegalAccessException iae) {
            Debug.error("SecureELFFormatter: Timestamp Generator Could not be Instantiated", iae);
        }
    }

    private void getAllFields() {
        String strAllFields = this.lmanager.getProperty("iplanet-am-logging-allfields");
        StringTokenizer strToken = new StringTokenizer(strAllFields, ", ");
        int count = strToken.countTokens();
        this.allFields = new String[count];
        count = 0;
        while (strToken.hasMoreElements()) {
            this.allFields[count++] = strToken.nextToken().trim();
        }
        String temp = "";
        for (int i = 0; i < count; ++i) {
            temp = temp + this.allFields[i] + "\t";
        }
    }

    public String format(java.util.logging.LogRecord logRecord) {
        StringBuffer sbuffer = new StringBuffer();
        StringBuffer stringForMAC = new StringBuffer();
        Map logInfoTable = ((LogRecord)logRecord).getLogInfoMap();
        try {
            this.getAllFields();
            Set selectedFields = this.getSelectedFieldSet();
            String strTime = this.secureTimestampGenerator.getTimestamp();
            sbuffer.append("\"").append(strTime).append("\"\t");
            stringForMAC.append("\"").append(strTime).append("\"");
            String message = this.processString(this.formatMessage(logRecord));
            if (message.indexOf(32) != -1 || message.indexOf(9) != -1) {
                sbuffer.append("\"").append(message).append("\"\t");
                stringForMAC.append("\"").append(message).append("\"");
            } else {
                sbuffer.append(message).append("\t");
                stringForMAC.append(message);
            }
            String key = null;
            String value = null;
            for (int i = 2; i < this.allFields.length; ++i) {
                key = this.allFields[i];
                if (key != null && key.length() != 0 && selectedFields != null && logInfoTable != null && selectedFields.contains(key)) {
                    value = (String)logInfoTable.get(key);
                    value = value != null && value.length() != 0 ? this.processString(value) : "Not Available";
                    if (value.indexOf(32) != -1 || value.indexOf(9) != -1) {
                        sbuffer.append("\"").append(value).append("\"\t");
                        stringForMAC.append("\"").append(value).append("\"");
                        continue;
                    }
                    sbuffer.append(value).append("\t");
                    stringForMAC.append(value);
                    continue;
                }
                sbuffer.append("-").append("\t");
                stringForMAC.append("-");
            }
        }
        catch (Exception e) {
            Debug.error("SecureELFFormatter: Exception in String Handling", e);
        }
        String key = "Signature";
        if (logInfoTable.containsKey(key)) {
            sbuffer.append("-\t").append(logInfoTable.get(key));
        } else {
            try {
                Object[] obj = new Object[]{logRecord.getLoggerName()};
                String mac = this.fieldGenerator.generateLogField(stringForMAC.toString(), obj);
                sbuffer.append(mac).append("\t").append("-");
            }
            catch (Exception e) {
                Debug.error("SecureLFFormatter: couldnot generate mac", e);
                sbuffer.append("\"MAC NOT AVAILABLE\"").append("\t").append("-");
            }
        }
        sbuffer.append("\n");
        return sbuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("#Version: 1.0").append("\n");
        sbuffer.append("#Fields: ").append(this.constructHeader()).append("\n");
        return sbuffer.toString();
    }

    public String getTail(Handler handler) {
        return "";
    }

    private String constructHeader() {
        StringBuffer sbuffer = new StringBuffer();
        for (int i = 0; i < this.allFields.length; ++i) {
            sbuffer.append(this.allFields[i]).append("\t");
        }
        sbuffer.append("MAC").append("\t");
        sbuffer.append("Signature");
        return sbuffer.toString();
    }

    private Set getSelectedFieldSet() {
        HashSet<String> selectedFields = new HashSet<String>();
        String strSelectedFields = this.lmanager.getProperty("iplanet-am-logging-logfields");
        if (strSelectedFields != null && strSelectedFields.length() != 0) {
            StringTokenizer stoken = new StringTokenizer(strSelectedFields, ", ");
            while (stoken.hasMoreElements()) {
                selectedFields.add(stoken.nextToken());
            }
        }
        return selectedFields;
    }

    private String processString(String field) {
        StringBuffer sbuffer = new StringBuffer();
        int len = field.length();
        boolean hasUniqueChar = false;
        for (int i = 0; i < len; ++i) {
            char currentCharacter = field.charAt(i);
            if (currentCharacter == '\"') {
                sbuffer.append("\"\"");
                hasUniqueChar = true;
            }
            if (currentCharacter == '\r') {
                sbuffer.append("\\\\r");
                hasUniqueChar = true;
            }
            if (currentCharacter == '\n') {
                sbuffer.append("\\\\n");
                hasUniqueChar = true;
            }
            if (!hasUniqueChar) {
                sbuffer.append(currentCharacter);
            }
            hasUniqueChar = false;
        }
        return sbuffer.toString();
    }
}

