/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;

public class ELFFormatter
extends Formatter {
    private LogManager lmanager = (LogManager)LogManagerUtil.getLogManager();
    private String[] allFields;
    private ITimestampGenerator secureTimestampGenerator;

    public ELFFormatter() {
        String timestampGeneratorClass = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clz = Class.forName(timestampGeneratorClass);
            this.secureTimestampGenerator = (ITimestampGenerator)clz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            Debug.error("ELFFormatter: TimeStamp Generator Class not found", cnfe);
        }
        catch (InstantiationException ie) {
            Debug.error("ELFFormatter: Timestamp Generator Could not be Instantiated", ie);
        }
        catch (IllegalAccessException iae) {
            Debug.error("ELFFormatter: Timestamp Generator Could not be Instantiated", iae);
        }
    }

    private void getAllFields() {
        String strAllFields = this.lmanager.getProperty("iplanet-am-logging-allfields");
        StringTokenizer strToken = new StringTokenizer(strAllFields, ", ");
        int count = strToken.countTokens();
        this.allFields = new String[count];
        count = 0;
        while (strToken.hasMoreElements()) {
            this.allFields[count++] = strToken.nextToken().trim();
        }
        String temp = "";
        for (int i = 0; i < count; ++i) {
            temp = temp + this.allFields[i] + "\t";
        }
    }

    public String format(java.util.logging.LogRecord logRecord) {
        StringBuffer sbuffer = new StringBuffer();
        Map logInfoTable = ((LogRecord)logRecord).getLogInfoMap();
        try {
            this.getAllFields();
            Set selectedFields = this.getSelectedFieldSet();
            String strTime = "";
            if (this.secureTimestampGenerator != null) {
                strTime = this.secureTimestampGenerator.getTimestamp();
            }
            sbuffer.append("\"").append(strTime).append("\"\t");
            String message = this.processString(this.formatMessage(logRecord));
            if (message.indexOf(32) != -1 || message.indexOf(9) != -1) {
                sbuffer.append("\"").append(message).append("\"\t");
            } else {
                sbuffer.append(message).append("\t");
            }
            String key = null;
            String value = null;
            for (int i = 2; i < this.allFields.length; ++i) {
                key = this.allFields[i];
                if (key != null && key.length() != 0 && selectedFields != null && logInfoTable != null && selectedFields.contains(key)) {
                    value = (String)logInfoTable.get(key);
                    value = value != null && value.length() != 0 ? this.processString(value) : "Not Available";
                    if (value.indexOf(32) != -1 || value.indexOf(9) != -1) {
                        sbuffer.append("\"").append(value).append("\"\t");
                        continue;
                    }
                    sbuffer.append(value).append("\t");
                    continue;
                }
                sbuffer.append("-").append("\t");
            }
        }
        catch (Exception e) {
            Debug.error("ELFFormatter: Exception in String handling loop", e);
        }
        sbuffer.append("\n");
        return sbuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("#Version: 1.0").append("\n");
        sbuffer.append("#Fields: ").append(this.constructHeader()).append("\n");
        return sbuffer.toString();
    }

    public String getTail(Handler handler) {
        return "";
    }

    private String constructHeader() {
        StringBuffer sbuffer = new StringBuffer();
        for (int i = 0; i < this.allFields.length; ++i) {
            sbuffer.append(this.allFields[i]).append("\t");
        }
        return sbuffer.toString();
    }

    private Set getSelectedFieldSet() {
        HashSet<String> selectedFields = new HashSet<String>();
        String strSelectedFields = this.lmanager.getProperty("iplanet-am-logging-logfields");
        if (strSelectedFields != null && strSelectedFields.length() != 0) {
            StringTokenizer stoken = new StringTokenizer(strSelectedFields, ", ");
            while (stoken.hasMoreElements()) {
                selectedFields.add(stoken.nextToken());
            }
        }
        return selectedFields;
    }

    private String processString(String field) {
        StringBuffer sbuffer = new StringBuffer();
        int len = field.length();
        boolean hasUniqueChar = false;
        for (int i = 0; i < len; ++i) {
            char currentCharacter = field.charAt(i);
            if (currentCharacter == '\"') {
                sbuffer.append("\"\"");
                hasUniqueChar = true;
            }
            if (currentCharacter == '\r') {
                sbuffer.append("\\\\r");
                hasUniqueChar = true;
            }
            if (currentCharacter == '\n') {
                sbuffer.append("\\\\n");
                hasUniqueChar = true;
            }
            if (!hasUniqueChar) {
                sbuffer.append(currentCharacter);
            }
            hasUniqueChar = false;
        }
        return sbuffer.toString();
    }
}

