/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;

public class DBFormatter
extends Formatter {
    private LogManager lmanager = LogManagerUtil.getLogManager();
    private String[] allFields;
    private ITimestampGenerator secureTimestampGenerator;
    private final String NOTAVAIL = "Not Available";
    private String dateTimeFormat = null;
    private boolean isMySQL = false;

    public DBFormatter() {
        String timestampGeneratorClass = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clz = Class.forName(timestampGeneratorClass);
            this.secureTimestampGenerator = (ITimestampGenerator)clz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            Debug.error("DBFormatter: TimeStamp Generator Class not found", cnfe);
        }
        catch (InstantiationException ie) {
            Debug.error("DBFormatter: Timestamp Generator Could not be Instantiated", ie);
        }
        catch (IllegalAccessException iae) {
            Debug.error("DBFormatter: Timestamp Generator Could not be Instantiated", iae);
        }
        String driver = this.lmanager.getProperty("iplanet-am-logging-db-driver");
        if (driver == null || driver.length() == 0) {
            Debug.error("DBFormatter:DB driver not provided; assume not MySQL");
        } else if (driver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
            this.dateTimeFormat = this.lmanager.getProperty("sun-am-logging-ora-dbdate-format");
        } else if (driver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
            this.dateTimeFormat = this.lmanager.getProperty("sun-am-logging-mysql-dbdate-format");
        } else {
            this.isMySQL = false;
            this.dateTimeFormat = this.lmanager.getProperty("sun-am-logging-ora-dbdate-format");
            Debug.error("DBFormatter:assuming driver: '" + driver + "' is Oracle-compatible.");
        }
    }

    public String getHead(Handler h) {
        String retString = this.lmanager.getProperty("iplanet-am-logging-allfields");
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter: Returned String from getHead is " + retString);
        }
        return retString;
    }

    public String getTail(Handler h) {
        return "";
    }

    public String format(java.util.logging.LogRecord logRecord) {
        this.getAllFields();
        StringBuffer sbuffer = new StringBuffer();
        Map logInfoTable = ((LogRecord)logRecord).getLogInfoMap();
        Set selectedFields = this.getSelectedFieldSet();
        String strTime = "";
        if (this.secureTimestampGenerator != null) {
            strTime = this.secureTimestampGenerator.getTimestamp();
        }
        String toDate = null;
        toDate = !this.isMySQL ? "TO_DATE('" : "STR_TO_DATE('";
        sbuffer.append(toDate + strTime + "', '" + this.dateTimeFormat + "'), ");
        String tstr = this.formatMessage(logRecord);
        if (tstr.length() > 0 && tstr.indexOf("'") != -1) {
            StringTokenizer tmps = new StringTokenizer(tstr, "'");
            StringBuffer thisfield = new StringBuffer();
            if (Debug.messageEnabled()) {
                Debug.message("DBFormatter:found single-quote in data: " + tstr);
            }
            if (tstr.indexOf("'") == 0) {
                thisfield.append("''");
                if (tmps.hasMoreTokens()) {
                    thisfield.append(tmps.nextToken());
                }
                if (Debug.messageEnabled()) {
                    Debug.message("DBFormatter:thisfield1 = #" + thisfield.toString() + "#");
                }
            } else if (tmps.hasMoreTokens()) {
                thisfield.append(tmps.nextToken());
            }
            while (tmps.hasMoreTokens()) {
                thisfield.append("''").append(tmps.nextToken());
                if (!Debug.messageEnabled()) continue;
                Debug.message("DBFormatter:thisfield2 = #" + thisfield.toString() + "#");
            }
            if (tstr.indexOf("'", tstr.length() - 1) != -1) {
                thisfield.append("''");
            }
            tstr = thisfield.toString();
        }
        sbuffer.append("'").append(tstr).append("', ");
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:thisfield3 = #" + sbuffer.toString() + "#");
        }
        int len = this.allFields.length;
        for (int i = 2; i < len - 1; ++i) {
            if (logInfoTable != null && selectedFields != null && selectedFields.contains(this.allFields[i])) {
                String tempstr = (String)logInfoTable.get(this.allFields[i]);
                if (tempstr != null && tempstr.length() > 0 && tempstr.indexOf("'") != -1) {
                    StringTokenizer tmps = new StringTokenizer(tempstr, "'");
                    StringBuffer thisfield = new StringBuffer();
                    if (Debug.messageEnabled()) {
                        Debug.message("DBFormatter:found single-quote in: " + tempstr);
                    }
                    if (tempstr.indexOf("'") == 0) {
                        thisfield.append("''");
                        if (tmps.hasMoreTokens()) {
                            thisfield.append(tmps.nextToken());
                        }
                    } else if (tmps.hasMoreTokens()) {
                        thisfield.append(tmps.nextToken());
                    }
                    while (tmps.hasMoreTokens()) {
                        thisfield.append("''").append(tmps.nextToken());
                    }
                    if (tempstr.indexOf("'", tempstr.length() - 1) != -1) {
                        thisfield.append("''");
                    }
                    tempstr = thisfield.toString();
                }
                if (tempstr == null) {
                    tempstr = "Not Available";
                }
                sbuffer.append("'").append(tempstr).append("', ");
                continue;
            }
            sbuffer.append("'Not Available'").append(", ");
        }
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:format1: sbuffer = " + sbuffer.toString());
        }
        if (selectedFields.contains(this.allFields[len - 1])) {
            String tmpstr = (String)logInfoTable.get(this.allFields[len - 1]);
            if (tmpstr == null) {
                tmpstr = "Not Available";
            }
            sbuffer.append("'").append(tmpstr).append("'");
        } else {
            sbuffer.append("'Not Available'");
        }
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:format2: sbuffer = " + sbuffer.toString());
        }
        return sbuffer.toString();
    }

    private void getAllFields() {
        String strAllFields = this.lmanager.getProperty("iplanet-am-logging-allfields");
        StringTokenizer strToken = new StringTokenizer(strAllFields, ", ");
        int count = strToken.countTokens();
        this.allFields = new String[count];
        count = 0;
        while (strToken.hasMoreElements()) {
            this.allFields[count++] = strToken.nextToken().trim();
        }
        String temp = "";
        for (int i = 0; i < count; ++i) {
            temp = temp + this.allFields[i] + "\t";
        }
    }

    private Set getSelectedFieldSet() {
        HashSet<String> selectedFields = new HashSet<String>();
        String strSelectedFields = this.lmanager.getProperty("iplanet-am-logging-logfields");
        StringTokenizer stoken = new StringTokenizer(strSelectedFields, ", ");
        String temp = "";
        String temp1 = "";
        while (stoken.hasMoreElements()) {
            temp1 = stoken.nextToken();
            if (Debug.messageEnabled()) {
                Debug.message("DBFormatter:getSelectedFieldSet: temp1 = " + temp1);
            }
            selectedFields.add(temp1);
            temp = temp + temp1 + "\t";
        }
        return selectedFields;
    }
}

