/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.sun.identity.log.AMLogException;
import com.sun.identity.log.LogConstants;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogQuery;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.LogReadDBHandler;
import com.sun.identity.log.handlers.LogReadHandler;
import com.sun.identity.log.spi.Authorizer;
import com.sun.identity.log.spi.Debug;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.LogManager;

public class LogReader {
    private static int maxReordToReturn = 1;
    private static final String FILE_SOURCE = "File";
    private static LogManager manager;
    private static String[][] queryResult;
    private static String logFileName;
    private static String logPathName;
    private static String logFields;
    private static String fileHandlerClass;
    private static String maxRecStr;
    private static String dbHandlerClass;
    private static String logStorageType;
    private static String logSecurity;
    private static String securityPrefix;
    private static String loggerName;
    private static LogReadHandler currentHandler;
    private static LogReadDBHandler currentDBHandler;
    private static boolean logTypeIsFile;

    private LogReader() {
        manager = LogManagerUtil.getLogManager();
    }

    public static int getSizeUnits() throws Exception {
        LogReader lr = new LogReader();
        try {
            lr.readConfiguration();
        }
        catch (Exception ex) {
            Debug.error("LogReader.getSizeUnits:could not read configuration");
            throw ex;
        }
        int i = 0;
        if (logTypeIsFile) {
            return 1;
        }
        return i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getSize(String logName) throws IOException, Exception {
        LogReader lr = new LogReader();
        try {
            lr.readConfiguration();
        }
        catch (Exception ex) {
            Debug.error("LogReader.getSize: could not read configuration");
            throw ex;
        }
        if (!logTypeIsFile) return currentDBHandler.getNumberOfRows(manager, logName);
        String file = logPathName + logName;
        File thisFile = new File(file);
        if (!thisFile.exists()) throw new IOException(logName + " does not exist.");
        return thisFile.length();
    }

    public static Set getLogNames() {
        HashSet<String> logNames;
        block8: {
            block7: {
                LogReader lr = new LogReader();
                logNames = new HashSet<String>();
                try {
                    lr.readConfiguration();
                }
                catch (Exception ex) {
                    return logNames;
                }
                if (!logTypeIsFile) break block7;
                File dir = new File(logPathName);
                String[] dirList = dir.list();
                if (dirList == null) break block8;
                int numFiles = Array.getLength(dirList);
                int numDefFiles = Array.getLength(LogConstants.LOGFILENAMES);
                if (numFiles <= 0) break block8;
                block2: for (int i = 0; i < numFiles; ++i) {
                    for (int j = 0; j < numDefFiles; ++j) {
                        String nmToCompare = LogConstants.LOGFILENAMES[j];
                        if (logSecurity.equalsIgnoreCase("ON")) {
                            nmToCompare = securityPrefix + "." + nmToCompare;
                        }
                        if (dirList[i].indexOf(nmToCompare) <= -1) continue;
                        logNames.add(dirList[i]);
                        continue block2;
                    }
                }
                break block8;
            }
            queryResult = currentDBHandler.getTableNames(manager);
            int szOfList = Array.getLength(queryResult);
            int numDefFiles = Array.getLength(LogConstants.LOGFILENAMES);
            block4: for (int i = 0; i < szOfList; ++i) {
                String tFile = queryResult[i][0].replace('_', '.');
                String thisFile = tFile.toUpperCase();
                String thatFile = null;
                for (int j = 0; j < numDefFiles; ++j) {
                    thatFile = LogConstants.LOGFILENAMES[j].toUpperCase();
                    if (thatFile.indexOf(thisFile) <= -1) continue;
                    logNames.add(queryResult[i][0]);
                    continue block4;
                }
            }
        }
        return logNames;
    }

    public static ArrayList getLogFields() {
        ArrayList<String> lFHS = new ArrayList<String>();
        LogReader lr = new LogReader();
        try {
            lr.readConfiguration();
        }
        catch (Exception ex) {
            return lFHS;
        }
        lFHS.add("time");
        lFHS.add("Data");
        if (logFields != null && logFields.length() != 0) {
            StringTokenizer stok = new StringTokenizer(logFields, ", ");
            while (stok.hasMoreElements()) {
                lFHS.add(stok.nextToken());
            }
        }
        return lFHS;
    }

    public static synchronized String[][] read(String fileName, Object userCrdential) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader lr = new LogReader();
        lr.readConfiguration();
        if (fileName == null) {
            throw new IllegalArgumentException("filename can't be null");
        }
        LogReader.setLoggerName(fileName);
        if (!lr.isAllowed(userCrdential)) {
            throw new AMLogException(fileName + ":" + "Log read authorization failure");
        }
        String fullFileName = logPathName + fileName;
        LogQuery qry = new LogQuery(-2);
        queryResult = logTypeIsFile ? currentHandler.logRecRead(fullFileName, qry, false) : currentDBHandler.logRecRead(fileName, qry, manager, false);
        return queryResult;
    }

    public static synchronized String[][] read(String logName, String logType, Object userCrdential) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        queryResult = LogReader.read(logName, logType, null, null, userCrdential);
        return queryResult;
    }

    public static synchronized String[][] read(String logName, String logType, String timeStamp, Object userCrdential) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        queryResult = LogReader.read(logName, logType, timeStamp, null, userCrdential);
        return queryResult;
    }

    public static synchronized String[][] read(String logName, String logType, LogQuery logQuery, Object userCrdential) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        queryResult = LogReader.read(logName, logType, null, logQuery, userCrdential);
        return queryResult;
    }

    public static String[][] read(String logname, String logtype, String timeStamp, LogQuery logQuery, Object userCrdential) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        String mainFileName = new String();
        LogReader.setLoggerName(logname, logtype);
        mainFileName = loggerName;
        if (timeStamp != null) {
            if (mainFileName.length() == 0) {
                return null;
            }
            mainFileName = mainFileName + "." + timeStamp;
        }
        queryResult = LogReader.read(mainFileName, logQuery, userCrdential);
        return queryResult;
    }

    public static String[][] read(String fileName, LogQuery logQuery, Object userCrdential) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader lr = new LogReader();
        lr.readConfiguration();
        if (fileName == null) {
            throw new IllegalArgumentException("filename can't be null");
        }
        if (maxReordToReturn <= 0) {
            maxReordToReturn = 1;
        }
        if (logQuery != null) {
            if (logQuery.getNumRecordsWanted() < -2) {
                logQuery.setMaxRecord(maxReordToReturn);
            } else if (logQuery.getNumRecordsWanted() == -1 && logTypeIsFile) {
                logQuery.setMaxRecord(maxReordToReturn);
            }
        } else {
            logQuery = new LogQuery(maxReordToReturn);
        }
        LogReader.setLoggerName(fileName);
        if (!lr.isAllowed(userCrdential)) {
            throw new AMLogException(fileName + ":" + "Log read authorization failure");
        }
        if (logTypeIsFile) {
            String fullFileName = logPathName + fileName;
            queryResult = currentHandler.logRecRead(fullFileName, logQuery, true);
        } else {
            queryResult = currentDBHandler.logRecRead(fileName, logQuery, manager, true);
        }
        return queryResult;
    }

    public static String[][] read(Set fileNames, LogQuery logQuery, Object userCrdential) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader lr = new LogReader();
        lr.readConfiguration();
        if (fileNames == null) {
            throw new IllegalArgumentException("filenames can't be null");
        }
        if (fileNames.isEmpty()) {
            throw new IllegalArgumentException("filenames can't be empty");
        }
        Iterator it = fileNames.iterator();
        while (it.hasNext()) {
            String ss = (String)it.next();
            if (ss != null) {
                ss = ss.trim();
            }
            if (ss != null && ss.length() != 0) continue;
            throw new IllegalArgumentException("filename cannot be null");
        }
        if (maxReordToReturn <= 0) {
            maxReordToReturn = 1;
        }
        if (logQuery != null) {
            if (logQuery.getNumRecordsWanted() < -2) {
                logQuery.setMaxRecord(maxReordToReturn);
            } else if (logQuery.getNumRecordsWanted() == -1 && logTypeIsFile) {
                logQuery.setMaxRecord(maxReordToReturn);
            }
        } else {
            logQuery = new LogQuery(maxReordToReturn);
        }
        String tmpF = LogReader.getAllFilenames(fileNames);
        LogReader.setLoggerName(tmpF);
        if (!lr.isAllowed(userCrdential)) {
            throw new AMLogException(tmpF + ":" + "Log read authorization failure");
        }
        if (logTypeIsFile) {
            HashSet<String> fullFileNames = new HashSet<String>();
            Iterator it2 = fileNames.iterator();
            while (it2.hasNext()) {
                String ss = (String)it2.next();
                ss = logPathName + ss;
                fullFileNames.add(ss);
            }
            queryResult = currentHandler.logRecRead(fullFileNames, logQuery, true);
        } else {
            queryResult = currentDBHandler.logRecRead(fileNames, logQuery, manager, true);
        }
        return queryResult;
    }

    private static String getAllFilenames(Set fileNames) {
        StringBuffer fsSB = new StringBuffer();
        if (fileNames == null) {
            return null;
        }
        if (fileNames.isEmpty()) {
            return "";
        }
        String ts = null;
        Iterator it = fileNames.iterator();
        while (it.hasNext()) {
            ts = (String)it.next();
            fsSB.append(ts);
        }
        ts = fsSB.toString();
        return ts;
    }

    private static String getCurrentFile(String logname, String logtype, Object userCrdential) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader.setLoggerName(logname, logtype);
        Logger logInstance = (Logger)Logger.getLogger(loggerName);
        try {
            logFileName = logInstance.getCurrentFile();
        }
        catch (RuntimeException e) {
            Debug.error("LogReader:getCurrentFile:RuntimeException: ", e);
            logFileName = null;
            throw e;
        }
        return logFileName;
    }

    private boolean isAllowed(Object userCredential) throws Exception {
        boolean isAuthorized = false;
        try {
            isAuthorized = Authorizer.isAuthorized(loggerName, "READ", userCredential);
        }
        catch (Exception e) {
            Debug.error("LogReader:isAllowed:Exception: ", e);
            throw e;
        }
        return isAuthorized;
    }

    private void readConfiguration() throws Exception {
        this.cleanup();
        try {
            logPathName = manager.getProperty("iplanet-am-logging-location");
            if (logPathName == null) {
                Debug.error("LogReader:readConfiguration:unable to get log location");
                return;
            }
            logStorageType = manager.getProperty("iplanet-am-logging-type");
            maxRecStr = manager.getProperty("iplanet-am-logging-max-records");
            if (maxRecStr == null || maxRecStr.length() == 0) {
                maxRecStr = "500";
            }
            logFields = manager.getProperty("iplanet-am-logging-logfields");
            logTypeIsFile = true;
            if (logStorageType.equals(FILE_SOURCE)) {
                fileHandlerClass = manager.getProperty("iplanet-am-logging-file-read-handler");
                if (!logPathName.endsWith(File.separator)) {
                    logPathName = logPathName + File.separator;
                }
                logSecurity = manager.getProperty("iplanet-am-logging-security-status");
            } else {
                logTypeIsFile = false;
                dbHandlerClass = manager.getProperty("sun-am-logging-db-read-handler");
            }
        }
        catch (Exception e) {
            Debug.error("LogReader:readConfiguration:Exception: ", e);
            throw e;
        }
        try {
            Class<?> clz;
            if (logStorageType.compareToIgnoreCase(FILE_SOURCE) == 0) {
                clz = Class.forName(fileHandlerClass);
                currentHandler = (LogReadHandler)clz.newInstance();
            } else if (logStorageType.compareToIgnoreCase("DB") == 0) {
                clz = Class.forName(dbHandlerClass);
                currentDBHandler = (LogReadDBHandler)clz.newInstance();
            }
        }
        catch (Exception e) {
            Debug.error("LogReader:readConfiguration:Exception: ", e);
            throw e;
        }
        try {
            if (maxRecStr != null) {
                maxRecStr = maxRecStr.trim();
                maxReordToReturn = Integer.parseInt(maxRecStr);
            }
        }
        catch (Exception ex) {
            Debug.error("LogReader:readConfiguration:Exception: ", ex);
            throw ex;
        }
    }

    private static void setLoggerName(String name) {
        if (name.startsWith(securityPrefix)) {
            name = name.substring(securityPrefix.length() + 1, name.length());
        }
        int datePos = name.lastIndexOf(".");
        int strLen = name.length();
        String dateCheck = name.substring(++datePos + 1, strLen);
        try {
            Long longTm = new Long(dateCheck);
            long dateValue = longTm;
            if (dateValue >= 1L) {
                name = name.substring(0, datePos - 1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        loggerName = name;
    }

    private static void setLoggerName(String logname, String logtype) {
        if (logname != null) {
            loggerName = logname;
        }
        if (logtype != null) {
            if (logname != null) {
                loggerName = loggerName + ".";
            }
            loggerName = loggerName + logtype;
        }
    }

    private void cleanup() {
        maxReordToReturn = -1;
        queryResult = null;
        currentHandler = null;
    }

    static {
        queryResult = null;
        logFileName = null;
        logPathName = null;
        logFields = null;
        fileHandlerClass = null;
        maxRecStr = null;
        dbHandlerClass = null;
        logStorageType = null;
        logSecurity = null;
        securityPrefix = "_secure";
        currentHandler = null;
        currentDBHandler = null;
        logTypeIsFile = true;
    }
}

