/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.Logger;
import com.sun.identity.log.s1is.LogConfigReader;
import com.sun.identity.log.spi.Debug;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;

public class LogManager
extends java.util.logging.LogManager {
    public static boolean isLocal = false;
    public static String HANDLER = "Handler";
    public static String FORMATTER = "Formatter";
    public static boolean setMonitoringStatus;
    private boolean securityStatus = false;
    private String[] allFields;
    private Set selectedFieldSet;
    protected Level loggingLevel = null;
    static /* synthetic */ Class class$java$lang$String;

    public boolean addLogger(java.util.logging.Logger logger) {
        String name = logger.getName();
        if (name != null && name.length() != 0 && !name.equals("global")) {
            String rbName = logger.getResourceBundleName();
            logger = new Logger(name, rbName);
        }
        return super.addLogger(logger);
    }

    public final boolean isSecure() {
        return this.securityStatus;
    }

    public final String[] getAllFields() {
        return this.allFields;
    }

    public final Set getSelectedFieldSet() {
        return this.selectedFieldSet;
    }

    private final void readAllFields() {
        String strAllFields = this.getProperty("iplanet-am-logging-allfields");
        StringTokenizer strToken = new StringTokenizer(strAllFields, ", ");
        int count = strToken.countTokens();
        String[] localAllFields = new String[count];
        count = 0;
        while (strToken.hasMoreElements()) {
            localAllFields[count++] = strToken.nextToken().trim();
        }
        this.allFields = localAllFields;
    }

    private final void readSelectedFieldSet() {
        HashSet<String> fieldSet = new HashSet<String>();
        String strSelectedFields = this.getProperty("iplanet-am-logging-logfields");
        if (strSelectedFields != null && strSelectedFields.length() != 0) {
            StringTokenizer stoken = new StringTokenizer(strSelectedFields, ", ");
            while (stoken.hasMoreElements()) {
                fieldSet.add(stoken.nextToken());
            }
        }
        this.selectedFieldSet = fieldSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readConfiguration() throws IOException, SecurityException {
        try {
            Logger.rwLock.writeRequest();
            Class clazz = Logger.class;
            synchronized (clazz) {
                Enumeration<String> loggerNames = this.getLoggerNames();
                String oldLocation = this.getProperty("iplanet-am-logging-location");
                LogManagerUtil.setupEnv();
                try {
                    if (SystemProperties.isServerMode()) {
                        LogConfigReader logConfigReader = new LogConfigReader();
                    } else {
                        super.readConfiguration();
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    LogManagerUtil.resetEnv();
                }
                if (isLocal) {
                    boolean loggingOff;
                    File dir;
                    String newLocation;
                    this.securityStatus = false;
                    this.readAllFields();
                    this.readSelectedFieldSet();
                    if (this.getProperty("iplanet-am-logging-type").equals("DB")) {
                        HANDLER = this.getProperty("iplanet-am-logging-jdbc-handler");
                        FORMATTER = this.getProperty("iplanet-am-logging-db-formatter");
                        String driver = this.getProperty("iplanet-am-logging-db-driver");
                    } else if (this.getProperty("iplanet-am-logging-security-status").equalsIgnoreCase("ON")) {
                        this.securityStatus = true;
                        HANDLER = this.getProperty("iplanet-am-logging-secure-file-handler");
                        FORMATTER = this.getProperty("iplanet-am-logging-secure-elf-formatter");
                    } else {
                        HANDLER = this.getProperty("iplanet-am-logging-file-handler");
                        FORMATTER = this.getProperty("iplanet-am-logging-elf-formatter");
                    }
                    if (this.getProperty("iplanet-am-logging-type").equals("File") && (newLocation = this.getProperty("iplanet-am-logging-location")) != null && oldLocation != null && !oldLocation.equals(newLocation) && !(dir = new File(newLocation)).exists() && !dir.mkdirs()) {
                        Debug.error("LogManager:readConfiguration:Unable to create the new log directory. Verify that the process has necessary permissions");
                    }
                    if (loggingOff = this.getProperty("logstatus").equals("INACTIVE")) {
                        this.loggingLevel = Level.OFF;
                    } else {
                        String strLogLevel = this.getProperty("sun-am-log-level");
                        try {
                            this.loggingLevel = Level.parse(strLogLevel);
                        }
                        catch (IllegalArgumentException iaex) {
                            this.loggingLevel = Level.INFO;
                            Debug.error("LogManager:readConfiguration:Log level '" + strLogLevel + "' unknown; setting to Level.INFO.");
                        }
                    }
                } else {
                    HANDLER = this.getProperty("iplanet-am-logging-remote-handler");
                    if (HANDLER == null) {
                        HANDLER = "com.sun.identity.log.handlers.RemoteHandler";
                    }
                    if ((FORMATTER = this.getProperty("iplanet-am-logging-remote-formatter")) == null) {
                        FORMATTER = "com.sun.identity.log.handlers.RemoteFormatter";
                    }
                }
                Logger.resolveHostName = Boolean.valueOf(this.getProperty("resolveHostName"));
                loggerNames = this.getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    String curEl = loggerNames.nextElement();
                    if (curEl.length() == 0 || curEl.length() == 0 || curEl.equals("global")) continue;
                    if (Debug.messageEnabled()) {
                        Debug.message("LogManager:readConfiguration:Processing Logger: " + curEl);
                    }
                    Logger l = (Logger)Logger.getLogger(curEl);
                    String handlerClass = HANDLER;
                    Class<?> clz = null;
                    Class[] parameters = new Class[]{class$java$lang$String == null ? LogManager.class$("java.lang.String") : class$java$lang$String};
                    Object[] parameterObjects = new Object[]{new String(l.getName())};
                    Constructor<?> cons = null;
                    Handler h = null;
                    try {
                        clz = Class.forName(handlerClass);
                    }
                    catch (Exception e) {
                        Debug.error("LogManager.readConfiguration:could not load " + handlerClass, e);
                    }
                    try {
                        cons = clz.getDeclaredConstructor(parameters);
                    }
                    catch (Exception e) {
                        Debug.error("LogManager.readConfiguration:could not instantiate" + handlerClass, e);
                    }
                    try {
                        h = (Handler)cons.newInstance(parameterObjects);
                    }
                    catch (Exception e) {
                        Debug.error("LogManager.readConfiguration:could not instantiate" + handlerClass, e);
                    }
                    String formatterClass = FORMATTER;
                    Formatter f = null;
                    try {
                        f = (Formatter)Class.forName(formatterClass).newInstance();
                    }
                    catch (Exception e) {
                        Debug.error("LogManager.readConfiguration:could not instantiate Formatter " + formatterClass, e);
                    }
                    h.setFormatter(f);
                    l.addHandler(h);
                    Level tlevel = this.loggingLevel;
                    if (this.loggingLevel != Level.OFF) {
                        String levelProp = "iplanet-am-logging." + l.getName() + ".level";
                        String lvlStr = SystemProperties.get(levelProp);
                        tlevel = this.loggingLevel;
                        if (lvlStr != null && lvlStr.length() > 0) {
                            try {
                                tlevel = Level.parse(lvlStr);
                            }
                            catch (IllegalArgumentException iaex) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.loggingLevel == null) continue;
                    l.setLevel(tlevel);
                }
            }
        }
        finally {
            Logger.rwLock.writeDone();
        }
    }
}

